/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.lite.internal.failover;

import com.dangdang.ddframe.job.lite.config.LiteJobConfiguration;
import com.dangdang.ddframe.job.lite.internal.config.ConfigurationNode;
import com.dangdang.ddframe.job.lite.internal.config.ConfigurationService;
import com.dangdang.ddframe.job.lite.internal.config.LiteJobConfigurationGsonFactory;
import com.dangdang.ddframe.job.lite.internal.failover.FailoverNode;
import com.dangdang.ddframe.job.lite.internal.failover.FailoverService;
import com.dangdang.ddframe.job.lite.internal.listener.AbstractJobListener;
import com.dangdang.ddframe.job.lite.internal.listener.AbstractListenerManager;
import com.dangdang.ddframe.job.lite.internal.sharding.ExecutionService;
import com.dangdang.ddframe.job.lite.internal.sharding.ShardingNode;
import com.dangdang.ddframe.job.lite.internal.sharding.ShardingService;
import com.dangdang.ddframe.job.reg.base.CoordinatorRegistryCenter;
import org.apache.curator.framework.recipes.cache.TreeCacheEvent;

public final class FailoverListenerManager
extends AbstractListenerManager {
    private final ConfigurationService configService;
    private final ExecutionService executionService;
    private final ShardingService shardingService;
    private final FailoverService failoverService;
    private final ConfigurationNode configNode;
    private final ShardingNode shardingNode;
    private final FailoverNode failoverNode;

    public FailoverListenerManager(CoordinatorRegistryCenter regCenter, String jobName) {
        super(regCenter, jobName);
        this.configService = new ConfigurationService(regCenter, jobName);
        this.executionService = new ExecutionService(regCenter, jobName);
        this.shardingService = new ShardingService(regCenter, jobName);
        this.failoverService = new FailoverService(regCenter, jobName);
        this.configNode = new ConfigurationNode(jobName);
        this.shardingNode = new ShardingNode(jobName);
        this.failoverNode = new FailoverNode(jobName);
    }

    @Override
    public void start() {
        this.addDataListener(new JobCrashedJobListener());
        this.addDataListener(new FailoverJobCrashedJobListener());
        this.addDataListener(new FailoverSettingsChangedJobListener());
    }

    private void failover(Integer item, TreeCacheEvent.Type eventType) {
        if (!this.isJobCrashAndNeedFailover(item, eventType)) {
            return;
        }
        this.failoverService.setCrashedFailoverFlag(item);
        if (!this.executionService.hasRunningItems(this.shardingService.getLocalShardingItems())) {
            this.failoverService.failoverIfNecessary();
        }
    }

    private boolean isJobCrashAndNeedFailover(Integer item, TreeCacheEvent.Type eventType) {
        LiteJobConfiguration jobConfig = this.configService.load(true);
        boolean isFailover = null != jobConfig && jobConfig.isFailover();
        return null != item && TreeCacheEvent.Type.NODE_REMOVED == eventType && !this.executionService.isCompleted(item) && isFailover;
    }

    class FailoverSettingsChangedJobListener
    extends AbstractJobListener {
        FailoverSettingsChangedJobListener() {
        }

        @Override
        protected void dataChanged(String path, TreeCacheEvent.Type eventType, String data) {
            if (FailoverListenerManager.this.configNode.isConfigPath(path) && TreeCacheEvent.Type.NODE_UPDATED == eventType && !LiteJobConfigurationGsonFactory.fromJson(data).isFailover()) {
                FailoverListenerManager.this.failoverService.removeFailoverInfo();
            }
        }
    }

    class FailoverJobCrashedJobListener
    extends AbstractJobListener {
        FailoverJobCrashedJobListener() {
        }

        @Override
        protected void dataChanged(String path, TreeCacheEvent.Type eventType, String data) {
            FailoverListenerManager.this.failover(FailoverListenerManager.this.failoverNode.getItemByExecutionFailoverPath(path), eventType);
        }
    }

    class JobCrashedJobListener
    extends AbstractJobListener {
        JobCrashedJobListener() {
        }

        @Override
        protected void dataChanged(String path, TreeCacheEvent.Type eventType, String data) {
            FailoverListenerManager.this.failover(FailoverListenerManager.this.shardingNode.getItemByRunningItemPath(path), eventType);
        }
    }
}

