/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.lite.internal.election;

import com.dangdang.ddframe.job.lite.internal.election.LeaderNode;
import com.dangdang.ddframe.job.lite.internal.election.LeaderService;
import com.dangdang.ddframe.job.lite.internal.listener.AbstractJobListener;
import com.dangdang.ddframe.job.lite.internal.listener.AbstractListenerManager;
import com.dangdang.ddframe.job.lite.internal.schedule.JobRegistry;
import com.dangdang.ddframe.job.lite.internal.server.ServerNode;
import com.dangdang.ddframe.job.lite.internal.server.ServerService;
import com.dangdang.ddframe.job.lite.internal.server.ServerStatus;
import com.dangdang.ddframe.job.reg.base.CoordinatorRegistryCenter;
import org.apache.curator.framework.recipes.cache.TreeCacheEvent;

public final class ElectionListenerManager
extends AbstractListenerManager {
    private final String jobName;
    private final LeaderNode leaderNode;
    private final ServerNode serverNode;
    private final LeaderService leaderService;
    private final ServerService serverService;

    public ElectionListenerManager(CoordinatorRegistryCenter regCenter, String jobName) {
        super(regCenter, jobName);
        this.jobName = jobName;
        this.leaderNode = new LeaderNode(jobName);
        this.serverNode = new ServerNode(jobName);
        this.leaderService = new LeaderService(regCenter, jobName);
        this.serverService = new ServerService(regCenter, jobName);
    }

    @Override
    public void start() {
        this.addDataListener(new LeaderElectionJobListener());
        this.addDataListener(new LeaderAbdicationJobListener());
    }

    class LeaderAbdicationJobListener
    extends AbstractJobListener {
        LeaderAbdicationJobListener() {
        }

        @Override
        protected void dataChanged(String path, TreeCacheEvent.Type eventType, String data) {
            if (ElectionListenerManager.this.leaderService.isLeader() && this.isLocalServerDisabled(path, data)) {
                ElectionListenerManager.this.leaderService.removeLeader();
            }
        }

        private boolean isLocalServerDisabled(String path, String data) {
            return ElectionListenerManager.this.serverNode.isLocalServerPath(path) && ServerStatus.DISABLED.name().equals(data);
        }
    }

    class LeaderElectionJobListener
    extends AbstractJobListener {
        LeaderElectionJobListener() {
        }

        @Override
        protected void dataChanged(String path, TreeCacheEvent.Type eventType, String data) {
            if (!JobRegistry.getInstance().isShutdown(ElectionListenerManager.this.jobName) && (this.isActiveElection(path, data) || this.isPassiveElection(path, eventType))) {
                ElectionListenerManager.this.leaderService.electLeader();
            }
        }

        private boolean isActiveElection(String path, String data) {
            return !ElectionListenerManager.this.leaderService.hasLeader() && this.isLocalServerEnabled(path, data);
        }

        private boolean isPassiveElection(String path, TreeCacheEvent.Type eventType) {
            return this.isLeaderCrashed(path, eventType) && ElectionListenerManager.this.serverService.isAvailableServer(JobRegistry.getInstance().getJobInstance(ElectionListenerManager.this.jobName).getIp());
        }

        private boolean isLeaderCrashed(String path, TreeCacheEvent.Type eventType) {
            return ElectionListenerManager.this.leaderNode.isLeaderInstancePath(path) && TreeCacheEvent.Type.NODE_REMOVED == eventType;
        }

        private boolean isLocalServerEnabled(String path, String data) {
            return ElectionListenerManager.this.serverNode.isLocalServerPath(path) && !ServerStatus.DISABLED.name().equals(data);
        }
    }
}

