/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.lite.internal.failover;

import com.dangdang.ddframe.job.lite.internal.failover.FailoverNode;
import com.dangdang.ddframe.job.lite.internal.schedule.JobRegistry;
import com.dangdang.ddframe.job.lite.internal.schedule.JobScheduleController;
import com.dangdang.ddframe.job.lite.internal.sharding.ShardingService;
import com.dangdang.ddframe.job.lite.internal.storage.JobNodeStorage;
import com.dangdang.ddframe.job.lite.internal.storage.LeaderExecutionCallback;
import com.dangdang.ddframe.job.reg.base.CoordinatorRegistryCenter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FailoverService {
    private static final Logger log = LoggerFactory.getLogger(FailoverService.class);
    private final String jobName;
    private final JobNodeStorage jobNodeStorage;
    private final ShardingService shardingService;

    public FailoverService(CoordinatorRegistryCenter regCenter, String jobName) {
        this.jobName = jobName;
        this.jobNodeStorage = new JobNodeStorage(regCenter, jobName);
        this.shardingService = new ShardingService(regCenter, jobName);
    }

    public void setCrashedFailoverFlag(int item) {
        if (!this.isFailoverAssigned(item)) {
            this.jobNodeStorage.createJobNodeIfNeeded(FailoverNode.getItemsNode(item));
        }
    }

    private boolean isFailoverAssigned(Integer item) {
        return this.jobNodeStorage.isJobNodeExisted(FailoverNode.getExecutionFailoverNode(item));
    }

    public void failoverIfNecessary() {
        if (this.needFailover()) {
            this.jobNodeStorage.executeInLeader("leader/failover/latch", new FailoverLeaderExecutionCallback());
        }
    }

    private boolean needFailover() {
        return this.jobNodeStorage.isJobNodeExisted("leader/failover/items") && !this.jobNodeStorage.getJobNodeChildrenKeys("leader/failover/items").isEmpty() && !JobRegistry.getInstance().isJobRunning(this.jobName);
    }

    public void updateFailoverComplete(Collection<Integer> items) {
        for (int each : items) {
            this.jobNodeStorage.removeJobNodeIfExisted(FailoverNode.getExecutionFailoverNode(each));
        }
    }

    public List<Integer> getFailoverItems(String jobInstanceId) {
        List<String> items = this.jobNodeStorage.getJobNodeChildrenKeys("sharding");
        ArrayList<Integer> result = new ArrayList<Integer>(items.size());
        for (String each : items) {
            int item = Integer.parseInt(each);
            String node = FailoverNode.getExecutionFailoverNode(item);
            if (!this.jobNodeStorage.isJobNodeExisted(node) || !jobInstanceId.equals(this.jobNodeStorage.getJobNodeDataDirectly(node))) continue;
            result.add(item);
        }
        Collections.sort(result);
        return result;
    }

    public List<Integer> getLocalFailoverItems() {
        if (JobRegistry.getInstance().isShutdown(this.jobName)) {
            return Collections.emptyList();
        }
        return this.getFailoverItems(JobRegistry.getInstance().getJobInstance(this.jobName).getJobInstanceId());
    }

    public List<Integer> getLocalTakeOffItems() {
        List<Integer> shardingItems = this.shardingService.getLocalShardingItems();
        ArrayList<Integer> result = new ArrayList<Integer>(shardingItems.size());
        for (int each : shardingItems) {
            if (!this.jobNodeStorage.isJobNodeExisted(FailoverNode.getExecutionFailoverNode(each))) continue;
            result.add(each);
        }
        return result;
    }

    public void removeFailoverInfo() {
        for (String each : this.jobNodeStorage.getJobNodeChildrenKeys("sharding")) {
            this.jobNodeStorage.removeJobNodeIfExisted(FailoverNode.getExecutionFailoverNode(Integer.parseInt(each)));
        }
    }

    class FailoverLeaderExecutionCallback
    implements LeaderExecutionCallback {
        FailoverLeaderExecutionCallback() {
        }

        @Override
        public void execute() {
            if (JobRegistry.getInstance().isShutdown(FailoverService.this.jobName) || !FailoverService.this.needFailover()) {
                return;
            }
            int crashedItem = Integer.parseInt(FailoverService.this.jobNodeStorage.getJobNodeChildrenKeys("leader/failover/items").get(0));
            log.debug("Failover job '{}' begin, crashed item '{}'", (Object)FailoverService.this.jobName, (Object)crashedItem);
            FailoverService.this.jobNodeStorage.fillEphemeralJobNode(FailoverNode.getExecutionFailoverNode(crashedItem), JobRegistry.getInstance().getJobInstance(FailoverService.this.jobName).getJobInstanceId());
            FailoverService.this.jobNodeStorage.removeJobNodeIfExisted(FailoverNode.getItemsNode(crashedItem));
            JobScheduleController jobScheduleController = JobRegistry.getInstance().getJobScheduleController(FailoverService.this.jobName);
            if (null != jobScheduleController) {
                jobScheduleController.triggerJob();
            }
        }
    }
}

