/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.lite.spring.api;

import com.dangdang.ddframe.job.api.ElasticJob;
import com.dangdang.ddframe.job.event.JobEventConfiguration;
import com.dangdang.ddframe.job.lite.api.JobScheduler;
import com.dangdang.ddframe.job.lite.api.listener.ElasticJobListener;
import com.dangdang.ddframe.job.lite.config.LiteJobConfiguration;
import com.dangdang.ddframe.job.lite.spring.job.util.AopTargetUtils;
import com.dangdang.ddframe.job.reg.base.CoordinatorRegistryCenter;
import com.google.common.base.Optional;

public final class SpringJobScheduler
extends JobScheduler {
    private final ElasticJob elasticJob;

    public SpringJobScheduler(ElasticJob elasticJob, CoordinatorRegistryCenter regCenter, LiteJobConfiguration jobConfig, ElasticJobListener ... elasticJobListeners) {
        super(regCenter, jobConfig, SpringJobScheduler.getTargetElasticJobListeners(elasticJobListeners));
        this.elasticJob = elasticJob;
    }

    public SpringJobScheduler(ElasticJob elasticJob, CoordinatorRegistryCenter regCenter, LiteJobConfiguration jobConfig, JobEventConfiguration jobEventConfig, ElasticJobListener ... elasticJobListeners) {
        super(regCenter, jobConfig, jobEventConfig, SpringJobScheduler.getTargetElasticJobListeners(elasticJobListeners));
        this.elasticJob = elasticJob;
    }

    private static ElasticJobListener[] getTargetElasticJobListeners(ElasticJobListener[] elasticJobListeners) {
        ElasticJobListener[] result = new ElasticJobListener[elasticJobListeners.length];
        for (int i = 0; i < elasticJobListeners.length; ++i) {
            result[i] = (ElasticJobListener)AopTargetUtils.getTarget(elasticJobListeners[i]);
        }
        return result;
    }

    protected Optional<ElasticJob> createElasticJobInstance() {
        return Optional.fromNullable((Object)this.elasticJob);
    }
}

