/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.spring.namespace.parser.dataflow;

import com.dangdang.ddframe.job.api.DataFlowElasticJob;
import com.dangdang.ddframe.job.api.config.impl.DataFlowJobConfiguration;
import com.dangdang.ddframe.job.api.config.impl.JobType;
import com.dangdang.ddframe.job.spring.namespace.parser.common.AbstractJobConfigurationDto;

final class DataFlowJobConfigurationDto
extends AbstractJobConfigurationDto<DataFlowJobConfiguration, DataFlowElasticJob, DataFlowJobConfiguration.DataFlowJobConfigurationBuilder> {
    private Integer processCountIntervalSeconds;
    private Integer fetchDataCount;
    private Integer concurrentDataProcessThreadCount;
    private Boolean streamingProcess;

    DataFlowJobConfigurationDto(String jobName, Class<? extends DataFlowElasticJob> jobClass, Integer shardingTotalCount, String cron) {
        super(jobName, JobType.DATA_FLOW, jobClass, shardingTotalCount, cron);
    }

    @Override
    public DataFlowJobConfiguration toJobConfiguration() {
        return (DataFlowJobConfiguration)((DataFlowJobConfiguration.DataFlowJobConfigurationBuilder)this.createBuilder()).build();
    }

    @Override
    protected DataFlowJobConfiguration.DataFlowJobConfigurationBuilder createCustomizedBuilder() {
        return new DataFlowJobConfiguration.DataFlowJobConfigurationBuilder(this.getJobName(), this.getJobClass(), this.getShardingTotalCount().intValue(), this.getCron());
    }

    @Override
    protected DataFlowJobConfiguration.DataFlowJobConfigurationBuilder buildCustomizedProperties(DataFlowJobConfiguration.DataFlowJobConfigurationBuilder builder) {
        if (null != this.getProcessCountIntervalSeconds()) {
            builder.processCountIntervalSeconds(this.getProcessCountIntervalSeconds().intValue());
        }
        if (null != this.getFetchDataCount()) {
            builder.fetchDataCount(this.getFetchDataCount().intValue());
        }
        if (null != this.getConcurrentDataProcessThreadCount()) {
            builder.concurrentDataProcessThreadCount(this.getConcurrentDataProcessThreadCount().intValue());
        }
        if (null != this.getStreamingProcess()) {
            builder.streamingProcess(this.getStreamingProcess().booleanValue());
        }
        return builder;
    }

    public Integer getProcessCountIntervalSeconds() {
        return this.processCountIntervalSeconds;
    }

    public Integer getFetchDataCount() {
        return this.fetchDataCount;
    }

    public Integer getConcurrentDataProcessThreadCount() {
        return this.concurrentDataProcessThreadCount;
    }

    public Boolean getStreamingProcess() {
        return this.streamingProcess;
    }

    public void setProcessCountIntervalSeconds(Integer processCountIntervalSeconds) {
        this.processCountIntervalSeconds = processCountIntervalSeconds;
    }

    public void setFetchDataCount(Integer fetchDataCount) {
        this.fetchDataCount = fetchDataCount;
    }

    public void setConcurrentDataProcessThreadCount(Integer concurrentDataProcessThreadCount) {
        this.concurrentDataProcessThreadCount = concurrentDataProcessThreadCount;
    }

    public void setStreamingProcess(Boolean streamingProcess) {
        this.streamingProcess = streamingProcess;
    }
}

