/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.config.common.api;

import com.dangdang.ddframe.rdb.sharding.api.rule.BindingTableRule;
import com.dangdang.ddframe.rdb.sharding.api.rule.DataSourceRule;
import com.dangdang.ddframe.rdb.sharding.api.rule.ShardingRule;
import com.dangdang.ddframe.rdb.sharding.api.rule.TableRule;
import com.dangdang.ddframe.rdb.sharding.api.strategy.database.DatabaseShardingStrategy;
import com.dangdang.ddframe.rdb.sharding.api.strategy.database.MultipleKeysDatabaseShardingAlgorithm;
import com.dangdang.ddframe.rdb.sharding.api.strategy.database.SingleKeyDatabaseShardingAlgorithm;
import com.dangdang.ddframe.rdb.sharding.api.strategy.table.MultipleKeysTableShardingAlgorithm;
import com.dangdang.ddframe.rdb.sharding.api.strategy.table.SingleKeyTableShardingAlgorithm;
import com.dangdang.ddframe.rdb.sharding.api.strategy.table.TableShardingStrategy;
import com.dangdang.ddframe.rdb.sharding.config.common.api.config.AutoIncrementColumnConfig;
import com.dangdang.ddframe.rdb.sharding.config.common.api.config.BindingTableRuleConfig;
import com.dangdang.ddframe.rdb.sharding.config.common.api.config.ShardingRuleConfig;
import com.dangdang.ddframe.rdb.sharding.config.common.api.config.StrategyConfig;
import com.dangdang.ddframe.rdb.sharding.config.common.api.config.TableRuleConfig;
import com.dangdang.ddframe.rdb.sharding.config.common.internal.algorithm.ClosureDatabaseShardingAlgorithm;
import com.dangdang.ddframe.rdb.sharding.config.common.internal.algorithm.ClosureTableShardingAlgorithm;
import com.dangdang.ddframe.rdb.sharding.config.common.internal.parser.InlineParser;
import com.dangdang.ddframe.rdb.sharding.id.generator.IdGenerator;
import com.dangdang.ddframe.rdb.sharding.router.strategy.MultipleKeysShardingAlgorithm;
import com.dangdang.ddframe.rdb.sharding.router.strategy.ShardingAlgorithm;
import com.dangdang.ddframe.rdb.sharding.router.strategy.ShardingStrategy;
import com.dangdang.ddframe.rdb.sharding.router.strategy.SingleKeyShardingAlgorithm;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.collections4.MapUtils;

public final class ShardingRuleBuilder {
    private final String logRoot;
    private final Map<String, DataSource> externalDataSourceMap;
    private final ShardingRuleConfig shardingRuleConfig;

    public ShardingRuleBuilder(ShardingRuleConfig shardingRuleConfig) {
        this("default", shardingRuleConfig);
    }

    public ShardingRuleBuilder(String logRoot, ShardingRuleConfig shardingRuleConfig) {
        this(logRoot, Collections.emptyMap(), shardingRuleConfig);
    }

    public ShardingRule build() {
        DataSourceRule dataSourceRule = this.buildDataSourceRule();
        Collection<TableRule> tableRules = this.buildTableRules(dataSourceRule);
        ShardingRule.ShardingRuleBuilder shardingRuleBuilder = ShardingRule.builder().dataSourceRule(dataSourceRule);
        if (!Strings.isNullOrEmpty((String)this.shardingRuleConfig.getIdGeneratorClass())) {
            shardingRuleBuilder.idGenerator(this.loadClass(this.shardingRuleConfig.getIdGeneratorClass(), IdGenerator.class));
        }
        return shardingRuleBuilder.tableRules(tableRules).bindingTableRules(this.buildBindingTableRules(tableRules)).databaseShardingStrategy(this.buildShardingStrategy(this.shardingRuleConfig.getDefaultDatabaseStrategy(), DatabaseShardingStrategy.class)).tableShardingStrategy(this.buildShardingStrategy(this.shardingRuleConfig.getDefaultTableStrategy(), TableShardingStrategy.class)).build();
    }

    private DataSourceRule buildDataSourceRule() {
        Preconditions.checkArgument((!this.shardingRuleConfig.getDataSource().isEmpty() || MapUtils.isNotEmpty(this.externalDataSourceMap) ? 1 : 0) != 0, (Object)"Sharding JDBC: No data source config");
        return this.shardingRuleConfig.getDataSource().isEmpty() ? new DataSourceRule(this.externalDataSourceMap, this.shardingRuleConfig.getDefaultDataSourceName()) : new DataSourceRule(this.shardingRuleConfig.getDataSource(), this.shardingRuleConfig.getDefaultDataSourceName());
    }

    private Collection<TableRule> buildTableRules(DataSourceRule dataSourceRule) {
        ArrayList<TableRule> result = new ArrayList<TableRule>(this.shardingRuleConfig.getTables().size());
        for (Map.Entry<String, TableRuleConfig> each : this.shardingRuleConfig.getTables().entrySet()) {
            String logicTable = each.getKey();
            TableRuleConfig tableRuleConfig = each.getValue();
            TableRule.TableRuleBuilder tableRuleBuilder = TableRule.builder((String)logicTable).dataSourceRule(dataSourceRule).dynamic(tableRuleConfig.isDynamic()).databaseShardingStrategy(this.buildShardingStrategy(tableRuleConfig.getDatabaseStrategy(), DatabaseShardingStrategy.class)).tableShardingStrategy(this.buildShardingStrategy(tableRuleConfig.getTableStrategy(), TableShardingStrategy.class));
            if (null != tableRuleConfig.getActualTables()) {
                tableRuleBuilder.actualTables(new InlineParser(tableRuleConfig.getActualTables()).evaluate());
            }
            if (!Strings.isNullOrEmpty((String)tableRuleConfig.getDataSourceNames())) {
                tableRuleBuilder.dataSourceNames(new InlineParser(tableRuleConfig.getDataSourceNames()).evaluate());
            }
            this.buildAutoIncrementColumn(tableRuleBuilder, tableRuleConfig);
            result.add(tableRuleBuilder.build());
        }
        return result;
    }

    private void buildAutoIncrementColumn(TableRule.TableRuleBuilder tableRuleBuilder, TableRuleConfig tableRuleConfig) {
        for (AutoIncrementColumnConfig each : tableRuleConfig.getAutoIncrementColumns()) {
            if (Strings.isNullOrEmpty((String)each.getColumnIdGeneratorClass())) {
                tableRuleBuilder.autoIncrementColumns(each.getColumnName());
                continue;
            }
            tableRuleBuilder.autoIncrementColumns(each.getColumnName(), this.loadClass(each.getColumnIdGeneratorClass(), IdGenerator.class));
        }
    }

    private Collection<BindingTableRule> buildBindingTableRules(final Collection<TableRule> tableRules) {
        ArrayList<BindingTableRule> result = new ArrayList<BindingTableRule>(this.shardingRuleConfig.getBindingTables().size());
        for (BindingTableRuleConfig each : this.shardingRuleConfig.getBindingTables()) {
            result.add(new BindingTableRule(Lists.transform(new InlineParser(each.getTableNames()).split(), (Function)new Function<String, TableRule>(){

                public TableRule apply(String input) {
                    return ShardingRuleBuilder.this.findTableRuleByLogicTableName(tableRules, input);
                }
            })));
        }
        return result;
    }

    private TableRule findTableRuleByLogicTableName(Collection<TableRule> tableRules, String logicTableName) {
        for (TableRule each : tableRules) {
            if (!logicTableName.equals(each.getLogicTable())) continue;
            return each;
        }
        throw new IllegalArgumentException(String.format("Sharding JDBC: Binding table `%s` is not an available Table rule", logicTableName));
    }

    private <T extends ShardingStrategy> T buildShardingStrategy(StrategyConfig config, Class<T> returnClass) {
        if (null == config) {
            return null;
        }
        Preconditions.checkArgument((Strings.isNullOrEmpty((String)config.getAlgorithmExpression()) && !Strings.isNullOrEmpty((String)config.getAlgorithmClassName()) || !Strings.isNullOrEmpty((String)config.getAlgorithmExpression()) && Strings.isNullOrEmpty((String)config.getAlgorithmClassName()) ? 1 : 0) != 0);
        Preconditions.checkState((returnClass.isAssignableFrom(DatabaseShardingStrategy.class) || returnClass.isAssignableFrom(TableShardingStrategy.class) ? 1 : 0) != 0, (Object)"Sharding-JDBC: returnClass is illegal");
        List<String> shardingColumns = new InlineParser(config.getShardingColumns()).split();
        if (Strings.isNullOrEmpty((String)config.getAlgorithmClassName())) {
            return this.buildShardingAlgorithmExpression(shardingColumns, config.getAlgorithmExpression(), returnClass);
        }
        return this.buildShardingAlgorithmClassName(shardingColumns, config.getAlgorithmClassName(), returnClass);
    }

    private <T extends ShardingStrategy> T buildShardingAlgorithmExpression(List<String> shardingColumns, String algorithmExpression, Class<T> returnClass) {
        return (T)(returnClass.isAssignableFrom(DatabaseShardingStrategy.class) ? new DatabaseShardingStrategy(shardingColumns, (MultipleKeysDatabaseShardingAlgorithm)new ClosureDatabaseShardingAlgorithm(algorithmExpression, this.logRoot)) : new TableShardingStrategy(shardingColumns, (MultipleKeysTableShardingAlgorithm)new ClosureTableShardingAlgorithm(algorithmExpression, this.logRoot)));
    }

    private <T extends ShardingStrategy> T buildShardingAlgorithmClassName(List<String> shardingColumns, String algorithmClassName, Class<T> returnClass) {
        ShardingAlgorithm shardingAlgorithm;
        try {
            shardingAlgorithm = (ShardingAlgorithm)Class.forName(algorithmClassName).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            throw new IllegalArgumentException(ex);
        }
        Preconditions.checkState((shardingAlgorithm instanceof SingleKeyShardingAlgorithm || shardingAlgorithm instanceof MultipleKeysShardingAlgorithm ? 1 : 0) != 0, (Object)"Sharding-JDBC: algorithmClassName is illegal");
        if (shardingAlgorithm instanceof SingleKeyShardingAlgorithm) {
            Preconditions.checkArgument((1 == shardingColumns.size() ? 1 : 0) != 0, (Object)"Sharding-JDBC: SingleKeyShardingAlgorithm must have only ONE sharding column");
            return (T)(returnClass.isAssignableFrom(DatabaseShardingStrategy.class) ? new DatabaseShardingStrategy(shardingColumns.get(0), (SingleKeyDatabaseShardingAlgorithm)shardingAlgorithm) : new TableShardingStrategy(shardingColumns.get(0), (SingleKeyTableShardingAlgorithm)shardingAlgorithm));
        }
        return (T)(returnClass.isAssignableFrom(DatabaseShardingStrategy.class) ? new DatabaseShardingStrategy(shardingColumns, (MultipleKeysDatabaseShardingAlgorithm)shardingAlgorithm) : new TableShardingStrategy(shardingColumns, (MultipleKeysTableShardingAlgorithm)shardingAlgorithm));
    }

    private <T> Class<? extends T> loadClass(String className, Class<T> superClass) {
        try {
            return superClass.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @ConstructorProperties(value={"logRoot", "externalDataSourceMap", "shardingRuleConfig"})
    public ShardingRuleBuilder(String logRoot, Map<String, DataSource> externalDataSourceMap, ShardingRuleConfig shardingRuleConfig) {
        this.logRoot = logRoot;
        this.externalDataSourceMap = externalDataSourceMap;
        this.shardingRuleConfig = shardingRuleConfig;
    }
}

