/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi;

import com.deepoove.poi.NiceXWPFDocument;
import com.deepoove.poi.config.Configure;
import com.deepoove.poi.exception.ResolverException;
import com.deepoove.poi.policy.RenderPolicy;
import com.deepoove.poi.render.RenderAPI;
import com.deepoove.poi.resolver.TemplateResolver;
import com.deepoove.poi.template.ElementTemplate;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XWPFTemplate {
    private static Logger logger = LoggerFactory.getLogger(XWPFTemplate.class);
    private NiceXWPFDocument doc;
    private Configure config;
    private List<ElementTemplate> eleTemplates;

    private XWPFTemplate() {
    }

    @Deprecated
    public static XWPFTemplate create(String filePath) {
        return XWPFTemplate.compile(filePath);
    }

    @Deprecated
    public static XWPFTemplate create(File file) {
        return XWPFTemplate.compile(file);
    }

    public static XWPFTemplate compile(String filePath) {
        return XWPFTemplate.compile(new File(filePath));
    }

    public static XWPFTemplate compile(File file) {
        return XWPFTemplate.compile(file, Configure.createDefault());
    }

    public static XWPFTemplate compile(String filePath, Configure config) {
        return XWPFTemplate.compile(new File(filePath), config);
    }

    public static XWPFTemplate compile(File file, Configure config) {
        try {
            XWPFTemplate instance = new XWPFTemplate();
            instance.config = config;
            instance.doc = new NiceXWPFDocument(new FileInputStream(file));
            instance.eleTemplates = new TemplateResolver(instance.config).parseElementTemplates(instance.doc);
            return instance;
        }
        catch (FileNotFoundException e) {
            logger.error("Cannot find the file", (Throwable)e);
            throw new ResolverException("Cannot find the file [" + file.getPath() + "]");
        }
        catch (IOException e) {
            logger.error("Compile template failed", (Throwable)e);
            throw new ResolverException("Compile template failed");
        }
    }

    public XWPFTemplate render(Map<String, Object> datas) {
        RenderAPI.render(this, datas);
        return this;
    }

    public XWPFTemplate render(Object datasource) {
        RenderAPI.render(this, datasource);
        return this;
    }

    @Deprecated
    public void registerPolicy(Class<?> templateClass, RenderPolicy policy) {
        this.registerPolicy(templateClass.getName(), policy);
    }

    public void registerPolicy(String templateName, RenderPolicy policy) {
        this.config.customPolicy(templateName, policy);
    }

    @Deprecated
    public RenderPolicy getPolicy(Class<? extends ElementTemplate> clazz) {
        return this.config.getCustomPolicys().get(clazz.getName());
    }

    public RenderPolicy getPolicy(String templateName) {
        return this.config.getCustomPolicys().get(templateName);
    }

    public void write(OutputStream out) throws IOException {
        this.doc.write(out);
    }

    public void close() throws IOException {
        this.doc.close();
    }

    public List<ElementTemplate> getElementTemplates() {
        return this.eleTemplates;
    }

    public NiceXWPFDocument getXWPFDocument() {
        return this.doc;
    }

    public Configure getConfig() {
        return this.config;
    }
}

