/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.policy;

import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.data.PictureRenderData;
import com.deepoove.poi.policy.RenderPolicy;
import com.deepoove.poi.template.ElementTemplate;
import com.deepoove.poi.template.run.RunTemplate;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PictureRenderPolicy
implements RenderPolicy {
    protected final Logger logger = LoggerFactory.getLogger(PictureRenderPolicy.class);

    @Override
    public void render(ElementTemplate eleTemplate, Object renderData, XWPFTemplate doc) {
        RunTemplate runTemplate = (RunTemplate)eleTemplate;
        XWPFRun run = runTemplate.getRun();
        if (renderData == null) {
            return;
        }
        PictureRenderData pictureRenderData = null;
        if (!(renderData instanceof PictureRenderData)) {
            this.logger.warn("Error render data,should be pictureRenderData:" + renderData.getClass());
            return;
        }
        pictureRenderData = (PictureRenderData)renderData;
        try {
            String blipId;
            byte[] data = pictureRenderData.getData();
            if (null == data) {
                FileInputStream is = new FileInputStream(pictureRenderData.getPath());
                blipId = doc.getXWPFDocument().addPictureData(is, this.suggestFileType(pictureRenderData.getPath()));
            } else {
                blipId = doc.getXWPFDocument().addPictureData(data, this.suggestFileType(pictureRenderData.getPath()));
            }
            doc.getXWPFDocument().addPicture(blipId, doc.getXWPFDocument().getNextPicNameNumber(this.suggestFileType(pictureRenderData.getPath())), pictureRenderData.getWidth(), pictureRenderData.getHeight(), run);
            run.setText("", 0);
        }
        catch (InvalidFormatException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private int suggestFileType(String imgFile) {
        int format = 0;
        if (imgFile.endsWith(".emf")) {
            format = 2;
        } else if (imgFile.endsWith(".wmf")) {
            format = 3;
        } else if (imgFile.endsWith(".pict")) {
            format = 4;
        } else if (imgFile.endsWith(".jpeg") || imgFile.endsWith(".jpg")) {
            format = 5;
        } else if (imgFile.endsWith(".png")) {
            format = 6;
        } else if (imgFile.endsWith(".dib")) {
            format = 7;
        } else if (imgFile.endsWith(".gif")) {
            format = 8;
        } else if (imgFile.endsWith(".tiff")) {
            format = 9;
        } else if (imgFile.endsWith(".eps")) {
            format = 10;
        } else if (imgFile.endsWith(".bmp")) {
            format = 11;
        } else if (imgFile.endsWith(".wpg")) {
            format = 12;
        } else {
            this.logger.error("Unsupported picture: " + imgFile + ". Expected emf|wmf|pict|jpeg|png|dib|gif|tiff|eps|bmp|wpg");
        }
        return format;
    }
}

