/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.util;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.imageio.ImageIO;
import org.apache.poi.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BytePictureUtils {
    private static Logger logger = LoggerFactory.getLogger(BytePictureUtils.class);

    public static byte[] getUrlByteArray(String urlPath) {
        return BytePictureUtils.toByteArray(BytePictureUtils.getUrlPictureStream(urlPath));
    }

    public static byte[] getLocalByteArray(File res) {
        FileInputStream is = null;
        byte[] byteArray = null;
        try {
            is = new FileInputStream(res);
            byteArray = BytePictureUtils.toByteArray(is);
            is.close();
        }
        catch (FileNotFoundException e) {
            logger.error("FileNotFound", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("getLocalByteArray IO error", (Throwable)e);
        }
        return byteArray;
    }

    public static byte[] getBufferByteArray(BufferedImage image) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "png", os);
        }
        catch (IOException e) {
            logger.error("getBufferByteArray error", (Throwable)e);
        }
        return os.toByteArray();
    }

    public static byte[] toByteArray(InputStream is) {
        try {
            return IOUtils.toByteArray((InputStream)is);
        }
        catch (IOException e) {
            logger.error("toByteArray error", (Throwable)e);
            return null;
        }
    }

    public static BufferedImage getUrlBufferedImage(String urlPath) {
        URL url = null;
        BufferedImage bufferImage = null;
        try {
            url = new URL(urlPath);
            bufferImage = ImageIO.read(url);
            return bufferImage;
        }
        catch (Exception e) {
            logger.error("getUrlBufferedImage error, {}, {}", (Object)urlPath, (Object)e);
            return null;
        }
    }

    public static BufferedImage getLocalBufferedImage(File res) {
        try {
            BufferedImage read = ImageIO.read(res);
            return read;
        }
        catch (FileNotFoundException e) {
            logger.error("FileNotFound", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("getLocalBufferedImage IO error", (Throwable)e);
        }
        return null;
    }

    public static InputStream getUrlPictureStream(String urlPath) {
        URL url = null;
        try {
            url = new URL(urlPath);
            return url.openConnection().getInputStream();
        }
        catch (IOException e) {
            logger.error("getUrlPictureStream error,{},{}", (Object)urlPath, (Object)e);
            return null;
        }
    }

    public static BufferedImage newBufferImage(int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 5);
        return image;
    }
}

