/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.util;

import com.deepoove.poi.data.style.Style;
import org.apache.poi.xwpf.usermodel.XWPFRun;

public final class StyleUtils {
    public static void styleRun(XWPFRun run, Style style) {
        if (null == run || null == style) {
            return;
        }
        String color = style.getColor();
        String fontFamily = style.getFontFamily();
        int fontSize = style.getFontSize();
        Boolean bold = style.isBold();
        Boolean italic = style.isItalic();
        Boolean strike = style.isStrike();
        if (null != color) {
            run.setColor(color);
        }
        if (0 != fontSize) {
            run.setFontSize(fontSize);
        }
        if (null != fontFamily) {
            run.setFontFamily(fontFamily);
        }
        if (null != bold) {
            run.setBold(bold.booleanValue());
        }
        if (null != italic) {
            run.setItalic(italic.booleanValue());
        }
        if (null != strike) {
            run.setStrikeThrough(strike.booleanValue());
        }
    }

    public static void styleRun(XWPFRun destRun, XWPFRun srcRun) {
        if (null == destRun || null == srcRun) {
            return;
        }
        destRun.setBold(srcRun.isBold());
        destRun.setColor(srcRun.getColor());
        destRun.setFontFamily(srcRun.getFontFamily());
        int fontSize = srcRun.getFontSize();
        if (-1 != fontSize) {
            destRun.setFontSize(fontSize);
        }
        destRun.setItalic(srcRun.isItalic());
        destRun.setStrikeThrough(srcRun.isStrikeThrough());
        destRun.setUnderline(srcRun.getUnderline());
    }
}

