/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.plugin.comment;

import com.deepoove.poi.plugin.comment.XWPFComment;
import com.deepoove.poi.xwpf.NiceXWPFDocument;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.poi.ooxml.POIXMLDocumentPart;
import org.apache.poi.ooxml.POIXMLException;
import org.apache.poi.ooxml.POIXMLFactory;
import org.apache.poi.ooxml.POIXMLRelation;
import org.apache.poi.ooxml.POIXMLTypeLoader;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFFactory;
import org.apache.poi.xwpf.usermodel.XWPFPictureData;
import org.apache.poi.xwpf.usermodel.XWPFRelation;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTComment;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTComments;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CommentsDocument;

public class XWPFComments
extends POIXMLDocumentPart {
    private List<XWPFComment> comments = new ArrayList<XWPFComment>();
    private List<XWPFPictureData> pictures = new ArrayList<XWPFPictureData>();
    private CTComments ctComments;
    XWPFDocument document;

    public XWPFComments(PackagePart part) {
        super(part);
    }

    public XWPFComments() {
        this.ctComments = CTComments.Factory.newInstance();
    }

    public void onDocumentRead() throws IOException {
        try (InputStream is = this.getPackagePart().getInputStream();){
            CommentsDocument doc = CommentsDocument.Factory.parse((InputStream)is, (XmlOptions)POIXMLTypeLoader.DEFAULT_XML_OPTIONS);
            this.ctComments = doc.getComments();
            for (CTComment ctComment : this.ctComments.getCommentList()) {
                this.comments.add(new XWPFComment(ctComment, this));
            }
        }
        catch (XmlException e) {
            throw new POIXMLException("Unable to read comments", (Throwable)e);
        }
        for (POIXMLDocumentPart poixmlDocumentPart : this.getRelations()) {
            if (!(poixmlDocumentPart instanceof XWPFPictureData)) continue;
            XWPFPictureData xwpfPicData = (XWPFPictureData)poixmlDocumentPart;
            this.pictures.add(xwpfPicData);
            ((NiceXWPFDocument)this.getXWPFDocument()).niceRegisterPackagePictureData(xwpfPicData);
        }
    }

    public String addPictureData(InputStream is, int format) throws InvalidFormatException, Exception {
        byte[] data = IOUtils.toByteArray((InputStream)is);
        return this.addPictureData(data, format);
    }

    public String addPictureData(byte[] pictureData, int format) throws Exception {
        XWPFPictureData xwpfPicData = ((NiceXWPFDocument)this.getXWPFDocument()).niceFindPackagePictureData(pictureData, format);
        POIXMLRelation relDesc = Child.getRelations(format);
        if (xwpfPicData == null) {
            int idx = this.getXWPFDocument().getNextPicNameNumber(format);
            xwpfPicData = (XWPFPictureData)this.createRelationship(relDesc, (POIXMLFactory)XWPFFactory.getInstance(), idx);
            PackagePart picDataPart = xwpfPicData.getPackagePart();
            try (OutputStream out = picDataPart.getOutputStream();){
                out.write(pictureData);
            }
            catch (IOException e) {
                throw new POIXMLException((Throwable)e);
            }
            ((NiceXWPFDocument)this.getXWPFDocument()).niceRegisterPackagePictureData(xwpfPicData);
            this.pictures.add(xwpfPicData);
            return this.getRelationId((POIXMLDocumentPart)xwpfPicData);
        }
        if (!this.getRelations().contains(xwpfPicData)) {
            POIXMLDocumentPart.RelationPart rp = this.addRelation(null, (POIXMLRelation)XWPFRelation.IMAGES, (POIXMLDocumentPart)xwpfPicData);
            this.pictures.add(xwpfPicData);
            return rp.getRelationship().getId();
        }
        return this.getRelationId((POIXMLDocumentPart)xwpfPicData);
    }

    protected void commit() throws IOException {
        XmlOptions xmlOptions = new XmlOptions(POIXMLTypeLoader.DEFAULT_XML_OPTIONS);
        xmlOptions.setSaveSyntheticDocumentElement(new QName(CTComments.type.getName().getNamespaceURI(), "comments"));
        PackagePart part = this.getPackagePart();
        OutputStream out = part.getOutputStream();
        this.ctComments.save(out, xmlOptions);
        out.close();
    }

    public List<XWPFPictureData> getAllPictures() {
        return Collections.unmodifiableList(this.pictures);
    }

    public CTComments getCtComments() {
        return this.ctComments;
    }

    public void setCtComments(CTComments ctComments) {
        this.ctComments = ctComments;
    }

    public List<XWPFComment> getComments() {
        return this.comments;
    }

    public void setXWPFDocument(XWPFDocument document) {
        this.document = document;
    }

    public XWPFDocument getXWPFDocument() {
        if (null != this.document) {
            return this.document;
        }
        return (XWPFDocument)this.getParent();
    }

    public XWPFComment addComment() {
        return this.createComment(this.getMaxId().add(BigInteger.ONE));
    }

    public XWPFComment createComment(BigInteger cid) {
        CTComment ctComment = this.ctComments.addNewComment();
        ctComment.setId(cid);
        XWPFComment comment = new XWPFComment(ctComment, this);
        this.comments.add(comment);
        return comment;
    }

    public BigInteger getMaxId() {
        BigInteger max = BigInteger.ZERO;
        for (XWPFComment comment : this.comments) {
            BigInteger id = comment.getCtComment().getId();
            if (null == id || id.compareTo(max) != 1) continue;
            max = id;
        }
        return max;
    }

    public XWPFComment getComment(int pos) {
        if (pos >= 0 && pos < this.ctComments.sizeOfCommentArray()) {
            return this.getComments().get(pos);
        }
        return null;
    }

    public void removeComment(int pos) {
        if (pos >= 0 && pos < this.ctComments.sizeOfCommentArray()) {
            this.comments.remove(pos);
            this.ctComments.removeComment(pos);
        }
    }

    public XWPFComment getComment(CTComment comment) {
        for (int i = 0; i < this.comments.size(); ++i) {
            if (this.comments.get(i).getCtComment() != comment) continue;
            return this.comments.get(i);
        }
        return null;
    }

    private static class Child
    extends XWPFPictureData {
        private Child() {
        }

        public static POIXMLRelation getRelations(int format) {
            return RELATIONS[format];
        }
    }
}

