/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.npm;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.ThrowingEx;
import com.diffplug.spotless.npm.NodeJSWrapper;
import com.diffplug.spotless.npm.NpmConfig;
import com.diffplug.spotless.npm.NpmFormatterStepStateBase;
import com.diffplug.spotless.npm.PrettierConfig;
import com.diffplug.spotless.npm.ReflectiveObjectWrapper;
import com.diffplug.spotless.npm.V8ArrayWrapper;
import com.diffplug.spotless.npm.V8FunctionWrapper;
import com.diffplug.spotless.npm.V8ObjectUtilsWrapper;
import com.diffplug.spotless.npm.V8ObjectWrapper;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PrettierFormatterStep {
    public static final String NAME = "prettier-format";

    public static final Map<String, String> defaultDevDependencies() {
        return PrettierFormatterStep.defaultDevDependenciesWithPrettier("1.16.4");
    }

    public static final Map<String, String> defaultDevDependenciesWithPrettier(String version) {
        return Collections.singletonMap("prettier", version);
    }

    @Deprecated
    public static FormatterStep create(Provisioner provisioner, File buildDir, @Nullable File npm, PrettierConfig prettierConfig) {
        return PrettierFormatterStep.create(PrettierFormatterStep.defaultDevDependencies(), provisioner, buildDir, npm, prettierConfig);
    }

    public static FormatterStep create(Map<String, String> devDependencies, Provisioner provisioner, File buildDir, @Nullable File npm, PrettierConfig prettierConfig) {
        Objects.requireNonNull(devDependencies);
        Objects.requireNonNull(provisioner);
        Objects.requireNonNull(buildDir);
        return FormatterStep.createLazy(NAME, () -> new State(NAME, devDependencies, provisioner, buildDir, npm, prettierConfig), State::createFormatterFunc);
    }

    public static class State
    extends NpmFormatterStepStateBase
    implements Serializable {
        private static final long serialVersionUID = -3811104513825329168L;
        private final PrettierConfig prettierConfig;

        State(String stepName, Map<String, String> devDependencies, Provisioner provisioner, File buildDir, @Nullable File npm, PrettierConfig prettierConfig) throws IOException {
            super(stepName, provisioner, new NpmConfig(State.replaceDevDependencies(State.readFileFromClasspath(PrettierFormatterStep.class, "/com/diffplug/spotless/npm/prettier-package.json"), new TreeMap<String, String>(devDependencies)), "prettier"), buildDir, npm);
            this.prettierConfig = Objects.requireNonNull(prettierConfig);
        }

        @Override
        @Nonnull
        public FormatterFunc createFormatterFunc() {
            try {
                Map[] resolvedPrettierOptions;
                V8ObjectWrapper prettier;
                NodeJSWrapper nodeJSWrapper;
                block63: {
                    nodeJSWrapper = this.nodeJSWrapper();
                    prettier = nodeJSWrapper.require(this.nodeModulePath());
                    resolvedPrettierOptions = new Map[1];
                    if (this.prettierConfig.getPrettierConfigPath() != null) {
                        Exception[] toThrow = new Exception[1];
                        try (V8FunctionWrapper resolveConfigCallback = this.createResolveConfigFunction(nodeJSWrapper, resolvedPrettierOptions, toThrow);
                             V8ObjectWrapper resolveConfigOption = this.createResolveConfigOptionObj(nodeJSWrapper);
                             V8ArrayWrapper resolveConfigParams = this.createResolveConfigParamsArray(nodeJSWrapper, resolveConfigOption);
                             V8ObjectWrapper promise = prettier.executeObjectFunction("resolveConfig", resolveConfigParams);
                             V8ArrayWrapper callbacks = nodeJSWrapper.createNewArray(resolveConfigCallback);){
                            promise.executeVoidFunction("then", callbacks);
                            this.executeResolution(nodeJSWrapper, resolvedPrettierOptions, toThrow);
                            break block63;
                        }
                    }
                    resolvedPrettierOptions[0] = this.prettierConfig.getOptions();
                }
                V8ObjectWrapper prettierConfig = nodeJSWrapper.createNewObject(resolvedPrettierOptions[0]);
                return FormatterFunc.Closeable.of(() -> Arrays.asList(prettierConfig, prettier, nodeJSWrapper).forEach(ReflectiveObjectWrapper::release), input -> {
                    try (V8ArrayWrapper formatParams = nodeJSWrapper.createNewArray(input, prettierConfig);){
                        String result;
                        String string = result = prettier.executeStringFunction("format", formatParams);
                        return string;
                    }
                });
            }
            catch (Exception e) {
                throw ThrowingEx.asRuntime(e);
            }
        }

        private V8FunctionWrapper createResolveConfigFunction(NodeJSWrapper nodeJSWrapper, Map<String, Object>[] outputOptions, Exception[] toThrow) {
            return nodeJSWrapper.createNewFunction((receiver, parameters) -> {
                try (V8ObjectWrapper configOptions = parameters.getObject(0);){
                    if (configOptions == null) {
                        toThrow[0] = new IllegalArgumentException("Cannot find or read config file " + this.prettierConfig.getPrettierConfigPath());
                    } else {
                        TreeMap<String, ? super Object> resolvedOptions = new TreeMap<String, Object>(V8ObjectUtilsWrapper.toMap(configOptions));
                        resolvedOptions.putAll(this.prettierConfig.getOptions());
                        outputOptions[0] = resolvedOptions;
                    }
                }
                catch (Exception e) {
                    toThrow[0] = e;
                }
                return receiver;
            });
        }

        private V8ObjectWrapper createResolveConfigOptionObj(NodeJSWrapper nodeJSWrapper) {
            return nodeJSWrapper.createNewObject().add("config", this.prettierConfig.getPrettierConfigPath().getAbsolutePath());
        }

        private V8ArrayWrapper createResolveConfigParamsArray(NodeJSWrapper nodeJSWrapper, V8ObjectWrapper resolveConfigOption) {
            return nodeJSWrapper.createNewArray().pushNull().push(resolveConfigOption);
        }

        private void executeResolution(NodeJSWrapper nodeJSWrapper, Map<String, Object>[] resolvedPrettierOptions, Exception[] toThrow) {
            while (resolvedPrettierOptions[0] == null && toThrow[0] == null) {
                nodeJSWrapper.handleMessage();
            }
            if (toThrow[0] != null) {
                throw ThrowingEx.asRuntime(toThrow[0]);
            }
        }
    }
}

