/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricio.async.db.util;

import com.github.mauricio.async.db.util.Execution$Implicits$;
import com.github.mauricio.async.db.util.Metrics$lambda$$stat$1;
import com.github.mauricio.async.db.util.Stat;
import com.github.mauricio.async.db.util.Stat$;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try;

public final class Metrics$ {
    public static final Metrics$ MODULE$;
    private final Logger com$github$mauricio$async$db$util$Metrics$$metricsLogger;
    private final Logger com$github$mauricio$async$db$util$Metrics$$slowLogger;
    private final LoadingCache<String, Stat> stats;

    static {
        new Metrics$();
    }

    public Logger com$github$mauricio$async$db$util$Metrics$$metricsLogger() {
        return this.com$github$mauricio$async$db$util$Metrics$$metricsLogger;
    }

    public Logger com$github$mauricio$async$db$util$Metrics$$slowLogger() {
        return this.com$github$mauricio$async$db$util$Metrics$$slowLogger;
    }

    public LoadingCache<String, Stat> stats() {
        return this.stats;
    }

    public <T> Future<T> stat(String key, Function0<Future<T>> f) {
        long start = System.currentTimeMillis();
        Future fut = (Future)f.apply();
        fut.onComplete((Function1)new Metrics$lambda$$stat$1(this, key, start), (ExecutionContext)Execution$Implicits$.MODULE$.trampoline());
        return fut;
    }

    private void logSlow(String sql, long time) {
        if (time > 50L) {
            this.com$github$mauricio$async$db$util$Metrics$$slowLogger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SQL:[", "],TIME:[", "]ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sql, BoxesRunTime.boxToLong((long)time)})));
        }
    }

    private void logMetrics(String key) {
        Stat stat2 = (Stat)this.stats().get((Object)key);
        long t = stat2.total().get();
        long c = stat2.times().get();
        long min = stat2.min().get();
        long max = stat2.max().get();
        if (c % 1000L == 0L) {
            this.com$github$mauricio$async$db$util$Metrics$$metricsLogger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[SQL-", "], count:", ", avg:", "ms, max:", ", min:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key, BoxesRunTime.boxToLong((long)c), BoxesRunTime.boxToLong((long)(t / package$.MODULE$.max(1L, c))), BoxesRunTime.boxToLong((long)max), BoxesRunTime.boxToLong((long)min)})));
        }
    }

    public final /* synthetic */ void com$github$mauricio$async$db$util$Metrics$$$anonfun$1(String key$1, long start$1, Try x0$1) {
        Try try_ = x0$1;
        long end = System.currentTimeMillis();
        long time = end - start$1;
        ((Stat)this.stats().get((Object)key$1)).add(time);
        this.logSlow(key$1, time);
        this.logMetrics(key$1);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private Metrics$() {
        MODULE$ = this;
        this.com$github$mauricio$async$db$util$Metrics$$metricsLogger = LoggerFactory.getLogger((String)"async.metrics");
        this.com$github$mauricio$async$db$util$Metrics$$slowLogger = LoggerFactory.getLogger((String)"async.slow");
        this.stats = CacheBuilder.newBuilder().maximumSize(100000L).expireAfterWrite(1L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<String, Stat>(){

            public Stat load(String key) {
                return new Stat(Stat$.MODULE$.apply$default$1(), Stat$.MODULE$.apply$default$2(), Stat$.MODULE$.apply$default$3(), Stat$.MODULE$.apply$default$4());
            }
        });
    }
}

