/*
 * Decompiled with CFR 0.152.
 */
package com.egzosn.pay.common.api;

import com.alibaba.fastjson.JSON;
import com.egzosn.pay.common.api.Callback;
import com.egzosn.pay.common.api.DefaultPayMessageHandler;
import com.egzosn.pay.common.api.PayConfigStorage;
import com.egzosn.pay.common.api.PayMessageHandler;
import com.egzosn.pay.common.api.PayMessageInterceptor;
import com.egzosn.pay.common.api.PayService;
import com.egzosn.pay.common.bean.DefaultNoticeRequest;
import com.egzosn.pay.common.bean.MethodType;
import com.egzosn.pay.common.bean.NoticeParams;
import com.egzosn.pay.common.bean.NoticeRequest;
import com.egzosn.pay.common.bean.Order;
import com.egzosn.pay.common.bean.OrderParaStructure;
import com.egzosn.pay.common.bean.PayMessage;
import com.egzosn.pay.common.bean.PayOrder;
import com.egzosn.pay.common.bean.PayOutMessage;
import com.egzosn.pay.common.bean.RefundOrder;
import com.egzosn.pay.common.bean.TransferOrder;
import com.egzosn.pay.common.http.HttpConfigStorage;
import com.egzosn.pay.common.http.HttpRequestTemplate;
import com.egzosn.pay.common.util.MatrixToImageWriter;
import com.egzosn.pay.common.util.sign.SignUtils;
import com.egzosn.pay.common.util.sign.encrypt.Base64;
import com.egzosn.pay.common.util.str.StringUtils;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.http.Consts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasePayService<PC extends PayConfigStorage>
implements PayService<PC> {
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());
    protected PC payConfigStorage;
    protected HttpRequestTemplate requestTemplate;
    protected int retrySleepMillis = 1000;
    protected int maxRetryTimes = 5;
    protected PayMessageHandler handler;
    protected List<PayMessageInterceptor<PayMessage, PayService>> interceptors = new ArrayList<PayMessageInterceptor<PayMessage, PayService>>();
    private Charset inputCharset = Consts.UTF_8;

    @Override
    public BasePayService setPayConfigStorage(PC payConfigStorage) {
        this.payConfigStorage = payConfigStorage;
        if (StringUtils.isNotEmpty(payConfigStorage.getInputCharset())) {
            this.inputCharset = Charset.forName(payConfigStorage.getInputCharset());
        }
        return this;
    }

    @Override
    public PC getPayConfigStorage() {
        return this.payConfigStorage;
    }

    @Override
    public HttpRequestTemplate getHttpRequestTemplate() {
        return this.requestTemplate;
    }

    @Override
    public BasePayService setRequestTemplateConfigStorage(HttpConfigStorage configStorage) {
        this.requestTemplate = new HttpRequestTemplate(configStorage);
        return this;
    }

    public BasePayService(PC payConfigStorage) {
        this(payConfigStorage, null);
    }

    public BasePayService(PC payConfigStorage, HttpConfigStorage configStorage) {
        this.setPayConfigStorage((PayConfigStorage)payConfigStorage);
        this.setRequestTemplateConfigStorage(configStorage);
    }

    protected String authorizationString(String user, String password) {
        String base64ClientID = null;
        try {
            base64ClientID = Base64.encode(String.format("%s:%s", user, password).getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            this.LOG.error("", (Throwable)e);
        }
        return base64ClientID;
    }

    @Override
    public String createSign(String content, String characterEncoding) {
        return SignUtils.valueOf(this.payConfigStorage.getSignType()).createSign(content, this.payConfigStorage.getKeyPrivate(), characterEncoding);
    }

    public String createSign(Map<String, Object> content, String characterEncoding) {
        return SignUtils.valueOf(this.payConfigStorage.getSignType()).sign(content, this.payConfigStorage.getKeyPrivate(), characterEncoding);
    }

    @Override
    public <O extends PayOrder> String toPay(O order) {
        if (StringUtils.isNotEmpty(order.getSubject()) && order.getSubject().contains("'")) {
            order.setSubject(order.getSubject().replace("'", ""));
        }
        if (StringUtils.isNotEmpty(order.getBody()) && order.getBody().contains("'")) {
            order.setBody(order.getBody().replace("'", ""));
        }
        Map<String, Object> orderInfo = this.orderInfo(order);
        return this.buildRequest(orderInfo, MethodType.POST);
    }

    @Override
    public <O extends PayOrder> Map<String, Object> app(O order) {
        return this.orderInfo(order);
    }

    @Override
    public <O extends PayOrder> BufferedImage genQrPay(O order) {
        return MatrixToImageWriter.writeInfoToJpgBuff(this.getQrPay(order));
    }

    @Override
    public Map<String, Object> getParameter2Map(Map<String, String[]> parameterMap, InputStream is) {
        return this.getNoticeParams(new DefaultNoticeRequest(parameterMap, is)).getBody();
    }

    @Override
    public NoticeParams getNoticeParams(NoticeRequest request) {
        Map<String, String[]> parameterMap = request.getParameterMap();
        TreeMap<String, Object> params = new TreeMap<String, Object>();
        for (Map.Entry<String, String[]> entry : parameterMap.entrySet()) {
            String name = entry.getKey();
            String[] values = entry.getValue();
            StringBuilder sb = new StringBuilder();
            int len = values.length;
            for (int i = 0; i < len; ++i) {
                sb.append(values[i]).append(i == len - 1 ? "" : Character.valueOf(','));
            }
            String valueStr = sb.toString();
            if (StringUtils.isNotEmpty(this.payConfigStorage.getInputCharset()) && !valueStr.matches("\\w+") && valueStr.equals(new String(valueStr.getBytes(Consts.ISO_8859_1), Consts.ISO_8859_1))) {
                valueStr = new String(valueStr.getBytes(Consts.ISO_8859_1), this.inputCharset);
            }
            params.put(name, valueStr);
        }
        return new NoticeParams(params);
    }

    @Override
    public <T> T query(String tradeNo, String outTradeNo, Callback<T> callback) {
        return callback.perform(this.query(tradeNo, outTradeNo));
    }

    @Override
    @Deprecated
    public <T> T close(String tradeNo, String outTradeNo, Callback<T> callback) {
        return callback.perform(this.close(tradeNo, outTradeNo));
    }

    @Override
    public <T> T cancel(String tradeNo, String outTradeNo, Callback<T> callback) {
        return callback.perform(this.cancel(tradeNo, outTradeNo));
    }

    @Override
    public Map<String, Object> cancel(String tradeNo, String outTradeNo) {
        return Collections.emptyMap();
    }

    @Override
    public <T> T refund(RefundOrder refundOrder, Callback<T> callback) {
        return callback.perform(this.refund(refundOrder).getAttrs());
    }

    @Override
    public <T> T refundquery(RefundOrder refundOrder, Callback<T> callback) {
        return callback.perform(this.refundquery(refundOrder));
    }

    @Override
    public Map<String, Object> downloadBill(Date billDate, String billType) {
        return Collections.emptyMap();
    }

    @Override
    public <T> T transfer(TransferOrder order, Callback<T> callback) {
        return callback.perform(this.transfer(order));
    }

    @Override
    public Map<String, Object> transfer(TransferOrder order) {
        return Collections.emptyMap();
    }

    @Override
    public Map<String, Object> transferQuery(String outNo, String tradeNo) {
        return Collections.emptyMap();
    }

    @Override
    public <T> T transferQuery(String outNo, String tradeNo, Callback<T> callback) {
        return callback.perform(this.transferQuery(outNo, tradeNo));
    }

    @Override
    public void setPayMessageHandler(PayMessageHandler handler) {
        this.handler = handler;
    }

    public PayMessageHandler getPayMessageHandler() {
        if (null == this.handler) {
            this.setPayMessageHandler(new DefaultPayMessageHandler());
        }
        return this.handler;
    }

    @Override
    public void addPayMessageInterceptor(PayMessageInterceptor interceptor) {
        this.interceptors.add(interceptor);
    }

    @Override
    @Deprecated
    public PayOutMessage payBack(Map<String, String[]> parameterMap, InputStream is) {
        return this.payBack(new DefaultNoticeRequest(parameterMap, is));
    }

    @Override
    public PayOutMessage payBack(NoticeRequest request) {
        NoticeParams noticeParams = this.getNoticeParams(request);
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("\u56de\u8c03\u54cd\u5e94:{}", (Object)JSON.toJSONString((Object)noticeParams));
        }
        if (!this.verify(noticeParams)) {
            return this.getPayOutMessage("fail", "\u5931\u8d25");
        }
        PayMessage payMessage = this.createMessage(noticeParams.getBody());
        HashMap<String, Object> context = new HashMap<String, Object>();
        for (PayMessageInterceptor<PayMessage, PayService> interceptor : this.interceptors) {
            if (interceptor.intercept(payMessage, context, this)) continue;
            return this.successPayOutMessage(payMessage);
        }
        return this.getPayMessageHandler().handle(payMessage, context, this);
    }

    @Override
    public PayMessage createMessage(Map<String, Object> message) {
        return new PayMessage(message);
    }

    @Override
    public <O extends PayOrder> Map<String, Object> preOrderHandler(Map<String, Object> orderInfo, O payOrder) {
        return orderInfo;
    }

    @Deprecated
    protected Map<String, Object> setParameters(Map<String, Object> parameters, String key, String value) {
        return OrderParaStructure.loadParameters(parameters, key, value);
    }

    @Deprecated
    protected Map<String, Object> setParameters(Map<String, Object> parameters, String key, Order order) {
        return OrderParaStructure.loadParameters(parameters, key, order);
    }
}

