/*
 * Decompiled with CFR 0.152.
 */
package com.egzosn.pay.common.api;

import com.egzosn.pay.common.api.PayConfigStorage;
import com.egzosn.pay.common.api.PayErrorExceptionHandler;
import com.egzosn.pay.common.api.PayMessageRouterRule;
import com.egzosn.pay.common.api.PayService;
import com.egzosn.pay.common.bean.PayMessage;
import com.egzosn.pay.common.bean.PayOutMessage;
import com.egzosn.pay.common.util.LogExceptionHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PayMessageRouter {
    protected final Logger LOG = LoggerFactory.getLogger(PayMessageRouter.class);
    private static final int DEFAULT_THREAD_POOL_SIZE = 100;
    private final List<PayMessageRouterRule> rules = new ArrayList<PayMessageRouterRule>();
    private final PayService payService;
    private ExecutorService executorService;
    private PayErrorExceptionHandler exceptionHandler;

    public PayMessageRouter(PayService payService) {
        this.payService = payService;
        this.executorService = Executors.newFixedThreadPool(100);
        this.exceptionHandler = new LogExceptionHandler();
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public void setExceptionHandler(PayErrorExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    List<PayMessageRouterRule> getRules() {
        return this.rules;
    }

    public PayMessageRouterRule rule() {
        return new PayMessageRouterRule(this);
    }

    public PayOutMessage route(Map<String, Object> payMessage, PayConfigStorage storage) {
        PayMessage message = this.payService.createMessage(payMessage);
        message.setPayType(storage.getPayType());
        return this.route(message);
    }

    public PayOutMessage route(final PayMessage payMessage) {
        ArrayList<PayMessageRouterRule> matchRules = new ArrayList<PayMessageRouterRule>();
        for (PayMessageRouterRule rule : this.rules) {
            if (!rule.test(payMessage)) continue;
            matchRules.add(rule);
            if (rule.isReEnter()) continue;
            break;
        }
        if (matchRules.isEmpty()) {
            return null;
        }
        PayOutMessage res = null;
        final ArrayList futures = new ArrayList();
        for (final PayMessageRouterRule rule : matchRules) {
            if (rule.isAsync()) {
                futures.add(this.executorService.submit(new Runnable(){

                    @Override
                    public void run() {
                        rule.service(payMessage, PayMessageRouter.this.payService, PayMessageRouter.this.exceptionHandler);
                    }
                }));
                continue;
            }
            res = rule.service(payMessage, this.payService, this.exceptionHandler);
            if (!this.LOG.isDebugEnabled()) continue;
            this.LOG.debug("End session access: async=false, fromPay=" + payMessage.getFromPay());
        }
        if (futures.size() > 0) {
            this.executorService.submit(new Runnable(){

                @Override
                public void run() {
                    for (Future future : futures) {
                        try {
                            future.get();
                            PayMessageRouter.this.LOG.debug("End session access: async=true, fromPay=" + payMessage.getFromPay());
                        }
                        catch (InterruptedException e) {
                            PayMessageRouter.this.LOG.error("Error happened when wait task finish", (Throwable)e);
                        }
                        catch (ExecutionException e) {
                            PayMessageRouter.this.LOG.error("Error happened when wait task finish", (Throwable)e);
                        }
                    }
                }
            });
        }
        return res;
    }
}

