/*
 * Decompiled with CFR 0.152.
 */
package com.egzosn.pay.wx.v3.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.egzosn.pay.common.bean.AssistOrder;
import com.egzosn.pay.common.bean.Order;
import com.egzosn.pay.common.bean.OrderParaStructure;
import com.egzosn.pay.common.bean.PayMessage;
import com.egzosn.pay.common.bean.PayOrder;
import com.egzosn.pay.common.bean.result.PayError;
import com.egzosn.pay.common.bean.result.PayException;
import com.egzosn.pay.common.exception.PayErrorException;
import com.egzosn.pay.common.http.HttpConfigStorage;
import com.egzosn.pay.common.util.MapGen;
import com.egzosn.pay.common.util.str.StringUtils;
import com.egzosn.pay.wx.v3.api.WxPayConfigStorage;
import com.egzosn.pay.wx.v3.api.WxPayService;
import com.egzosn.pay.wx.v3.bean.WxTransactionType;
import com.egzosn.pay.wx.v3.bean.combine.CombinePayMessage;
import java.util.LinkedHashMap;
import java.util.Map;

public class WxCombinePayService
extends WxPayService {
    public WxCombinePayService(WxPayConfigStorage payConfigStorage) {
        super(payConfigStorage);
    }

    public WxCombinePayService(WxPayConfigStorage payConfigStorage, HttpConfigStorage configStorage) {
        super(payConfigStorage, configStorage);
    }

    public Map<String, Object> getPublicParameters() {
        LinkedHashMap<String, Object> parameters = new LinkedHashMap<String, Object>();
        parameters.put("combine_appid", ((WxPayConfigStorage)this.payConfigStorage).getAppId());
        parameters.put("combine_mchid", ((WxPayConfigStorage)this.payConfigStorage).getMchId());
        return parameters;
    }

    public void initNotifyUrl(Map<String, Object> parameters, Order order) {
        OrderParaStructure.loadParameters(parameters, (String)"notify_url", (String)((WxPayConfigStorage)this.payConfigStorage).getNotifyUrl());
        OrderParaStructure.loadParameters(parameters, (String)"notify_url", (Order)order);
    }

    @Override
    public JSONObject unifiedOrder(PayOrder order) {
        Map<String, Object> parameters = this.getPublicParameters();
        parameters.put("combine_out_trade_no", order.getOutTradeNo());
        OrderParaStructure.loadDateParameters(parameters, (String)"time_start", (Order)order, (String)"yyyy-MM-dd'T'HH:mm:ssXXX");
        OrderParaStructure.loadDateParameters(parameters, (String)"time_expire", (Order)order, (String)"yyyy-MM-dd'T'HH:mm:ssXXX");
        this.initNotifyUrl(parameters, (Order)order);
        OrderParaStructure.loadParameters(parameters, (String)"scene_info", (Order)order);
        OrderParaStructure.loadParameters(parameters, (String)"sub_orders", (Order)order);
        if (StringUtils.isNotEmpty((CharSequence)order.getOpenid())) {
            parameters.put("combine_payer_info", new MapGen((Object)"openid", (Object)order.getOpenid()).getAttr());
        }
        return this.getAssistService().doExecute(parameters, order);
    }

    @Override
    public Map<String, Object> query(String transactionId, String outTradeNo) {
        return this.query(new AssistOrder(outTradeNo));
    }

    @Override
    public Map<String, Object> query(AssistOrder assistOrder) {
        return this.getAssistService().doExecute("", WxTransactionType.COMBINE_TRANSACTION, assistOrder.getOutTradeNo());
    }

    @Override
    public Map<String, Object> close(String transactionId, String outTradeNo) {
        throw new PayErrorException((PayError)new PayException("failure", "\u5408\u5355\u5173\u95ed\u5fc5\u987b\u8981\u6709\u5b50\u5355"));
    }

    @Override
    public Map<String, Object> close(AssistOrder assistOrder) {
        Map parameters = new MapGen((Object)"combine_appid", (Object)((WxPayConfigStorage)this.payConfigStorage).getAppId()).keyValue((Object)"sub_orders", assistOrder.getAttr("sub_orders")).getAttr();
        String requestBody = JSON.toJSONString((Object)parameters, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        return this.getAssistService().doExecute(requestBody, WxTransactionType.COMBINE_CLOSE, assistOrder.getOutTradeNo());
    }

    @Override
    public PayMessage createMessage(Map<String, Object> message) {
        return CombinePayMessage.create(message);
    }
}

