/*
 * Decompiled with CFR 0.152.
 */
package com.egzosn.pay.wx.v3.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.egzosn.pay.common.api.BasePayService;
import com.egzosn.pay.common.api.PayConfigStorage;
import com.egzosn.pay.common.api.TransferService;
import com.egzosn.pay.common.bean.AssistOrder;
import com.egzosn.pay.common.bean.BillType;
import com.egzosn.pay.common.bean.CurType;
import com.egzosn.pay.common.bean.MethodType;
import com.egzosn.pay.common.bean.NoticeParams;
import com.egzosn.pay.common.bean.NoticeRequest;
import com.egzosn.pay.common.bean.Order;
import com.egzosn.pay.common.bean.OrderParaStructure;
import com.egzosn.pay.common.bean.PayMessage;
import com.egzosn.pay.common.bean.PayOrder;
import com.egzosn.pay.common.bean.PayOutMessage;
import com.egzosn.pay.common.bean.RefundOrder;
import com.egzosn.pay.common.bean.RefundResult;
import com.egzosn.pay.common.bean.TransactionType;
import com.egzosn.pay.common.bean.TransferOrder;
import com.egzosn.pay.common.bean.result.PayError;
import com.egzosn.pay.common.bean.result.PayException;
import com.egzosn.pay.common.exception.PayErrorException;
import com.egzosn.pay.common.http.HttpConfigStorage;
import com.egzosn.pay.common.http.ResponseEntity;
import com.egzosn.pay.common.http.UriVariables;
import com.egzosn.pay.common.util.DateUtils;
import com.egzosn.pay.common.util.IOUtils;
import com.egzosn.pay.common.util.MapGen;
import com.egzosn.pay.common.util.Util;
import com.egzosn.pay.common.util.sign.SignTextUtils;
import com.egzosn.pay.common.util.sign.SignUtils;
import com.egzosn.pay.common.util.sign.encrypt.RSA2;
import com.egzosn.pay.common.util.str.StringUtils;
import com.egzosn.pay.wx.bean.WxPayError;
import com.egzosn.pay.wx.v3.api.DefaultWxPayAssistService;
import com.egzosn.pay.wx.v3.api.WxParameterStructure;
import com.egzosn.pay.wx.v3.api.WxPayAssistService;
import com.egzosn.pay.wx.v3.api.WxPayConfigStorage;
import com.egzosn.pay.wx.v3.api.WxPayServiceInf;
import com.egzosn.pay.wx.v3.bean.WxAccountType;
import com.egzosn.pay.wx.v3.bean.WxBillType;
import com.egzosn.pay.wx.v3.bean.WxTransactionType;
import com.egzosn.pay.wx.v3.bean.WxTransferType;
import com.egzosn.pay.wx.v3.bean.order.Amount;
import com.egzosn.pay.wx.v3.bean.order.RefundAmount;
import com.egzosn.pay.wx.v3.bean.response.Resource;
import com.egzosn.pay.wx.v3.bean.response.WxNoticeParams;
import com.egzosn.pay.wx.v3.bean.response.WxPayMessage;
import com.egzosn.pay.wx.v3.bean.response.WxRefundResult;
import com.egzosn.pay.wx.v3.bean.transfer.TransferDetail;
import com.egzosn.pay.wx.v3.utils.AntCertificationUtil;
import com.egzosn.pay.wx.v3.utils.WxConst;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;

public class WxPayService
extends BasePayService<WxPayConfigStorage>
implements TransferService,
WxPayServiceInf {
    private String apiServerUrl = "https://api.mch.weixin.qq.com";
    private volatile WxPayAssistService assistService;
    private volatile WxParameterStructure wxParameterStructure;

    public WxPayService(WxPayConfigStorage payConfigStorage) {
        this(payConfigStorage, null);
    }

    public WxPayService(WxPayConfigStorage payConfigStorage, HttpConfigStorage configStorage) {
        super((PayConfigStorage)payConfigStorage, configStorage);
        this.initAfter();
    }

    @Override
    public WxPayAssistService getAssistService() {
        if (null == this.assistService) {
            this.assistService = new DefaultWxPayAssistService(this);
        }
        this.assistService.refreshCertificate();
        return this.assistService;
    }

    public void setAssistService(WxPayAssistService assistService) {
        this.assistService = assistService;
    }

    protected void initAfter() {
        ((WxPayConfigStorage)this.payConfigStorage).setPartner(StringUtils.isNotEmpty((CharSequence)((WxPayConfigStorage)this.payConfigStorage).getSubMchId()));
        ((WxPayConfigStorage)this.payConfigStorage).loadCertEnvironment();
        this.wxParameterStructure = new WxParameterStructure((WxPayConfigStorage)this.payConfigStorage);
        this.setApiServerUrl("https://api.mch.weixin.qq.com");
    }

    @Override
    public WxPayService setApiServerUrl(String apiServerUrl) {
        this.apiServerUrl = apiServerUrl;
        this.getAssistService();
        return this;
    }

    @Override
    public String getApiServerUrl() {
        return this.apiServerUrl;
    }

    public WxParameterStructure getWxParameterStructure() {
        return this.wxParameterStructure;
    }

    @Override
    public String getReqUrl(TransactionType transactionType) {
        String type = transactionType.getType();
        String partnerStr = "";
        if (((WxPayConfigStorage)this.payConfigStorage).isPartner()) {
            partnerStr = "/partner";
        }
        type = type.replace("{partner}", partnerStr);
        return this.apiServerUrl + (((WxPayConfigStorage)this.payConfigStorage).isTest() ? "xdc/apiv2sandbox/" : "") + type;
    }

    public boolean verify(Map<String, Object> params) {
        throw new PayErrorException((PayError)new WxPayError("", "\u5fae\u4fe1V3\u4e0d\u652f\u6301\u65b9\u5f0f"));
    }

    @Override
    public boolean verify(NoticeParams noticeParams) {
        String serial = noticeParams.getHeader("wechatpay-serial");
        String timestamp = noticeParams.getHeader("wechatpay-timestamp");
        String nonce = noticeParams.getHeader("wechatpay-nonce");
        String signature = noticeParams.getHeader("wechatpay-signature");
        Certificate certificate = this.getAssistService().getCertificate(serial);
        String body = noticeParams.getBodyStr();
        String signText = StringUtils.joining((String)"\n", (String[])new String[]{timestamp, nonce, body});
        return RSA2.verify((String)signText, (String)signature, (Certificate)certificate, (String)((WxPayConfigStorage)this.payConfigStorage).getInputCharset());
    }

    public JSONObject unifiedOrder(PayOrder order) {
        Map<String, Object> parameters = this.wxParameterStructure.initPartner(null);
        OrderParaStructure.loadParameters(parameters, (String)"description", (String)order.getSubject());
        OrderParaStructure.loadParameters(parameters, (String)"description", (String)order.getBody());
        parameters.put("out_trade_no", order.getOutTradeNo());
        if (null != order.getExpirationTime()) {
            parameters.put("time_expire", DateUtils.formatDate((Date)order.getExpirationTime(), (String)"yyyy-MM-dd'T'HH:mm:ssXXX"));
        }
        OrderParaStructure.loadParameters(parameters, (String)"attach", (String)order.getAddition());
        this.wxParameterStructure.initNotifyUrl(parameters, (AssistOrder)order);
        OrderParaStructure.loadParameters(parameters, (String)"goods_tag", (Order)order);
        parameters.put("amount", Amount.getAmount(order.getPrice(), order.getCurType()));
        OrderParaStructure.loadParameters(parameters, (String)"detail", (Order)order);
        OrderParaStructure.loadParameters(parameters, (String)"scene_info", (Order)order);
        this.wxParameterStructure.loadSettleInfo(parameters, order);
        TransactionType transactionType = order.getTransactionType();
        ((WxTransactionType)transactionType).setAttribute(parameters, order);
        parameters.putAll(order.getAttrs());
        return this.getAssistService().doExecute(parameters, order);
    }

    public Map<String, Object> orderInfo(PayOrder order) {
        JSONObject result = this.unifiedOrder(order);
        if (((WxTransactionType)order.getTransactionType()).isReturn()) {
            return result;
        }
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        String appId = ((WxPayConfigStorage)this.payConfigStorage).getAppId();
        if (((WxPayConfigStorage)this.payConfigStorage).isPartner() && StringUtils.isNotEmpty((CharSequence)((WxPayConfigStorage)this.payConfigStorage).getSubAppId())) {
            appId = ((WxPayConfigStorage)this.payConfigStorage).getSubAppId();
        }
        String timeStamp = String.valueOf(DateUtils.toEpochSecond());
        String randomStr = SignTextUtils.randomStr();
        String prepayId = result.getString("prepay_id");
        if (WxTransactionType.JSAPI == order.getTransactionType()) {
            params.put("appId", appId);
            params.put("timeStamp", timeStamp);
            params.put("nonceStr", randomStr);
            prepayId = "prepay_id=" + prepayId;
            params.put("package", prepayId);
            params.put("signType", SignUtils.RSA.getName());
        } else if (WxTransactionType.APP == order.getTransactionType()) {
            params.put("appid", appId);
            params.put("partnerid", ((WxPayConfigStorage)this.payConfigStorage).getMchId());
            params.put("timestamp", timeStamp);
            params.put("noncestr", randomStr);
            params.put("prepayid", prepayId);
            params.put("package", "Sign=WXPay");
        }
        String signText = StringUtils.joining((String)"\n", (String[])new String[]{appId, timeStamp, randomStr, prepayId});
        String paySign = this.createSign(signText, ((WxPayConfigStorage)this.payConfigStorage).getInputCharset());
        params.put(WxTransactionType.JSAPI.equals(order.getTransactionType()) ? "paySign" : "sign", paySign);
        return params;
    }

    @Override
    public String createSign(String content, String characterEncoding) {
        PrivateKey privateKey = ((WxPayConfigStorage)this.payConfigStorage).getCertEnvironment().getPrivateKey();
        return RSA2.sign((String)content, (PrivateKey)privateKey, (String)characterEncoding);
    }

    @Deprecated
    public Map<String, Object> getParameter2Map(Map<String, String[]> parameterMap, InputStream is) {
        throw new PayErrorException((PayError)new WxPayError("failure", "\u5fae\u4fe1V3\u4e0d\u652f\u6301\u65b9\u5f0f"));
    }

    public NoticeParams getNoticeParams(NoticeRequest request) {
        WxNoticeParams noticeParams = null;
        try (InputStream is = request.getInputStream();){
            String body = IOUtils.toString((InputStream)is);
            noticeParams = (WxNoticeParams)((Object)JSON.parseObject((String)body, WxNoticeParams.class));
            noticeParams.setAttr(new MapGen((Object)WxConst.RESP_BODY, (Object)body).getAttr());
            noticeParams.setBodyStr(body);
            Resource resource = noticeParams.getResource();
            String associatedData = resource.getAssociatedData();
            String nonce = resource.getNonce();
            String ciphertext = resource.getCiphertext();
            String data = AntCertificationUtil.decryptToString(associatedData, nonce, ciphertext, ((WxPayConfigStorage)this.payConfigStorage).getV3ApiKey(), ((WxPayConfigStorage)this.payConfigStorage).getInputCharset());
            noticeParams.setBody((Map)JSON.parseObject((String)data));
        }
        catch (IOException e) {
            throw new PayErrorException((PayError)new WxPayError("failure", "\u83b7\u53d6\u56de\u8c03\u53c2\u6570\u5f02\u5e38"), (Throwable)e);
        }
        HashMap headers = new HashMap();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String name = (String)headerNames.nextElement();
            headers.put(name, Collections.list(request.getHeaders(name)));
        }
        noticeParams.setHeaders(headers);
        return noticeParams;
    }

    public PayOutMessage getPayOutMessage(String code, String message) {
        return PayOutMessage.JSON().content("code", (Object)code).content("message", (Object)message).build();
    }

    public PayOutMessage successPayOutMessage(PayMessage payMessage) {
        return this.getPayOutMessage("SUCCESS", "\u6210\u529f");
    }

    public String buildRequest(Map<String, Object> orderInfo, MethodType method) {
        String redirectUrl = StringUtils.isEmpty((CharSequence)((WxPayConfigStorage)this.payConfigStorage).getReturnUrl()) ? "" : "&redirect_url=" + UriVariables.urlEncoder((String)((WxPayConfigStorage)this.payConfigStorage).getReturnUrl());
        return String.format("<script type=\"text/javascript\">location.href=\"%s%s\"</script>", orderInfo.get("h5_url"), redirectUrl);
    }

    public String getQrPay(PayOrder order) {
        order.setTransactionType((TransactionType)WxTransactionType.NATIVE);
        Map<String, Object> orderInfo = this.orderInfo(order);
        return (String)orderInfo.get("code_url");
    }

    public Map<String, Object> microPay(PayOrder order) {
        throw new PayErrorException((PayError)new PayException("failure", "V3\u6682\u65f6\u6ca1\u6709\u63d0\u4f9b\u6b64\u529f\u80fd\uff0c\u8bf7\u67e5\u770bV2\u7248\u672c\u529f\u80fd"));
    }

    public Map<String, Object> query(String transactionId, String outTradeNo) {
        return this.query(new AssistOrder(transactionId, outTradeNo));
    }

    public Map<String, Object> query(AssistOrder assistOrder) {
        String transactionId = assistOrder.getTradeNo();
        String outTradeNo = assistOrder.getOutTradeNo();
        String parameters = UriVariables.getMapToParameters(this.wxParameterStructure.getMchParameters());
        WxTransactionType transactionType = WxTransactionType.QUERY_TRANSACTION_ID;
        String uriVariable = transactionId;
        if (StringUtils.isNotEmpty((CharSequence)outTradeNo)) {
            transactionType = WxTransactionType.QUERY_OUT_TRADE_NO;
            uriVariable = outTradeNo;
        }
        return this.getAssistService().doExecute(parameters, transactionType, uriVariable);
    }

    public Map<String, Object> close(String transactionId, String outTradeNo) {
        return this.close(new AssistOrder(outTradeNo));
    }

    public Map<String, Object> close(AssistOrder assistOrder) {
        String parameters = JSON.toJSONString(this.wxParameterStructure.getMchParameters());
        ResponseEntity<JSONObject> responseEntity = this.getAssistService().doExecuteEntity(parameters, WxTransactionType.CLOSE, assistOrder.getOutTradeNo());
        if (responseEntity.getStatusCode() == 204) {
            return new MapGen((Object)"statusCode", (Object)responseEntity.getStatusCode()).getAttr();
        }
        return (Map)responseEntity.getBody();
    }

    public RefundResult refund(RefundOrder refundOrder) {
        Map<String, Object> parameters = this.wxParameterStructure.initSubMchId(null);
        OrderParaStructure.loadParameters(parameters, (String)"transaction_id", (String)refundOrder.getTradeNo());
        OrderParaStructure.loadParameters(parameters, (String)"out_trade_no", (String)refundOrder.getOutTradeNo());
        OrderParaStructure.loadParameters(parameters, (String)"out_refund_no", (String)refundOrder.getRefundNo());
        OrderParaStructure.loadParameters(parameters, (String)"reason", (String)refundOrder.getDescription());
        OrderParaStructure.loadParameters(parameters, (String)"funds_account", (Order)refundOrder);
        this.wxParameterStructure.initNotifyUrl(parameters, (AssistOrder)refundOrder);
        RefundAmount refundAmount = new RefundAmount();
        refundAmount.setRefund(Util.conversionCentAmount((BigDecimal)refundOrder.getRefundAmount()));
        refundAmount.setTotal(Util.conversionCentAmount((BigDecimal)refundOrder.getTotalAmount()));
        CurType curType = refundOrder.getCurType();
        if (null != curType) {
            refundAmount.setCurrency(curType.getType());
        }
        parameters.put("amount", refundAmount);
        OrderParaStructure.loadParameters(parameters, (String)"amount", (Order)refundOrder);
        return WxRefundResult.create((Map<String, Object>)this.getAssistService().doExecute(parameters, WxTransactionType.REFUND));
    }

    public Map<String, Object> refundquery(RefundOrder refundOrder) {
        String parameters = UriVariables.getMapToParameters(this.wxParameterStructure.initSubMchId(null));
        return this.getAssistService().doExecute(parameters, WxTransactionType.REFUND_QUERY, refundOrder.getRefundNo());
    }

    public Map<String, Object> downloadBill(Date billDate, String billType) {
        Enum wxBillType = WxBillType.forType(billType);
        if (null == wxBillType) {
            wxBillType = WxAccountType.forType(billType);
        }
        return this.downloadBill(billDate, (BillType)wxBillType);
    }

    public Map<String, Object> downloadBill(Date billDate, BillType billType) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(5);
        parameters.put("bill_date", DateUtils.formatDate((Date)billDate, (String)"yyyy-MM-dd"));
        String fileType = billType.getFileType();
        OrderParaStructure.loadParameters(parameters, (String)"tar_type", (String)fileType);
        if (billType instanceof WxAccountType) {
            OrderParaStructure.loadParameters(parameters, (String)"account_type", (String)billType.getType());
        } else {
            this.wxParameterStructure.initSubMchId(parameters).put("bill_type", billType.getType());
        }
        String body = UriVariables.getMapToParameters(parameters);
        JSONObject result = this.getAssistService().doExecute(body, WxTransactionType.valueOf(billType.getCustom()), new Object[0]);
        String downloadUrl = result.getString("download_url");
        MethodType methodType = MethodType.GET;
        HttpEntity entity = this.getAssistService().buildHttpEntity(downloadUrl, "", methodType.name());
        ResponseEntity responseEntity = this.requestTemplate.doExecuteEntity(downloadUrl, (Object)entity, InputStream.class, methodType);
        InputStream inputStream = (InputStream)responseEntity.getBody();
        int statusCode = responseEntity.getStatusCode();
        if (statusCode >= 400) {
            try {
                String errorText = IOUtils.toString((InputStream)inputStream);
                JSONObject json = JSON.parseObject((String)errorText);
                throw new PayErrorException((PayError)new WxPayError(statusCode + "", json.getString("message"), errorText));
            }
            catch (IOException e) {
                throw new PayErrorException((PayError)new WxPayError(statusCode + "", ""));
            }
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("file", inputStream);
        return data;
    }

    public Map<String, Object> transfer(TransferOrder transferOrder) {
        if (transferOrder.getTransferType() == WxTransferType.TRANSFER_BILL_RECEIPT) {
            Map attr = new MapGen((Object)"out_batch_no", (Object)transferOrder.getBatchNo()).getAttr();
            return this.getAssistService().doExecute((Map<String, Object>)attr, (TransactionType)transferOrder.getTransferType());
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>(12);
        parameters.put("appid", ((WxPayConfigStorage)this.payConfigStorage).getAppId());
        parameters.put("out_batch_no", transferOrder.getBatchNo());
        OrderParaStructure.loadParameters(parameters, (String)"batch_name", (Order)transferOrder);
        parameters.put("batch_remark", transferOrder.getRemark());
        parameters.put("total_amount", Util.conversionCentAmount((BigDecimal)transferOrder.getAmount()));
        parameters.put("total_num", transferOrder.getAttr("total_num"));
        Object transferDetailListAttr = transferOrder.getAttr("transfer_detail_list");
        List<TransferDetail> transferDetails = this.initTransferDetailListAttr(transferDetailListAttr);
        parameters.put("transfer_detail_list", transferDetails);
        OrderParaStructure.loadParameters(parameters, (String)"transfer_scene_id", (Order)transferOrder);
        return this.getAssistService().doExecute(parameters, (TransactionType)transferOrder.getTransferType());
    }

    private List<TransferDetail> initTransferDetailListAttr(Object transferDetailListAttr) {
        List transferDetails = null;
        if (transferDetailListAttr instanceof String) {
            transferDetails = JSON.parseArray((String)((String)transferDetailListAttr), TransferDetail.class);
        } else if (null != transferDetailListAttr) {
            transferDetails = JSON.parseArray((String)JSON.toJSONString((Object)transferDetailListAttr), TransferDetail.class);
        } else {
            return null;
        }
        String serialNumber = ((WxPayConfigStorage)this.payConfigStorage).getCertEnvironment().getPlatformSerialNumber();
        Certificate certificate = this.getAssistService().getCertificate(serialNumber);
        return transferDetails.stream().peek(transferDetailListItem -> {
            String userIdCard;
            String userName = transferDetailListItem.getUserName();
            if (StringUtils.isNotEmpty((CharSequence)userName)) {
                String encryptedUserName = AntCertificationUtil.encryptToString(userName, certificate);
                transferDetailListItem.setUserName(encryptedUserName);
            }
            if (StringUtils.isNotEmpty((CharSequence)(userIdCard = transferDetailListItem.getUserIdCard()))) {
                String encryptedUserIdCard = AntCertificationUtil.encryptToString(userIdCard, certificate);
                transferDetailListItem.setUserIdCard(encryptedUserIdCard);
            }
        }).collect(Collectors.toList());
    }

    public Map<String, Object> transferQuery(AssistOrder assistOrder) {
        HashMap parameters = new HashMap(6);
        TransactionType transactionType = assistOrder.getTransactionType();
        ArrayList<String> uriVariables = new ArrayList<String>(3);
        if (StringUtils.isNotEmpty((CharSequence)assistOrder.getTradeNo())) {
            uriVariables.add(assistOrder.getTradeNo());
            String detailId = assistOrder.getAttrForString("detail_id");
            if (StringUtils.isNotEmpty((CharSequence)detailId)) {
                uriVariables.add(detailId);
            }
        } else if (StringUtils.isNotEmpty((CharSequence)assistOrder.getOutTradeNo())) {
            uriVariables.add(assistOrder.getOutTradeNo());
            String outDetailNo = assistOrder.getAttrForString("out_detail_no");
            if (StringUtils.isNotEmpty((CharSequence)outDetailNo)) {
                uriVariables.add(outDetailNo);
            }
        }
        if (transactionType == WxTransferType.QUERY_BATCH_BY_BATCH_ID || transactionType == WxTransferType.QUERY_BATCH_BY_OUT_BATCH_NO) {
            OrderParaStructure.loadParameters(parameters, (String)"need_query_detail", (Order)assistOrder);
            OrderParaStructure.loadParameters(parameters, (String)"offset", (Order)assistOrder);
            OrderParaStructure.loadParameters(parameters, (String)"limit", (Order)assistOrder);
            OrderParaStructure.loadParameters(parameters, (String)"detail_status", (Order)assistOrder);
        }
        String requestBody = UriVariables.getMapToParameters(parameters);
        return this.getAssistService().doExecute(requestBody, assistOrder.getTransactionType(), uriVariables.toArray());
    }

    public Map<String, Object> transferQuery(String outNo, String wxTransferType) {
        throw new PayErrorException((PayError)new WxPayError("", "V3\u4e0d\u652f\u6301\u6b64\u8f6c\u8d26\u67e5\u8be2\uff1a\u66ff\u4ee3\u65b9\u6cd5transferQuery(AssistOrder assistOrder)"));
    }

    public PayMessage createMessage(Map<String, Object> message) {
        return WxPayMessage.create(message);
    }
}

