/*
 * Decompiled with CFR 0.152.
 */
package com.egzosn.pay.wx.v3.api;

import com.alibaba.fastjson.JSONObject;
import com.egzosn.pay.common.bean.AssistOrder;
import com.egzosn.pay.common.bean.BillType;
import com.egzosn.pay.common.bean.MethodType;
import com.egzosn.pay.common.bean.NoticeParams;
import com.egzosn.pay.common.bean.Order;
import com.egzosn.pay.common.bean.OrderParaStructure;
import com.egzosn.pay.common.bean.PayMessage;
import com.egzosn.pay.common.bean.PayOrder;
import com.egzosn.pay.common.bean.RefundOrder;
import com.egzosn.pay.common.bean.RefundResult;
import com.egzosn.pay.common.bean.TransactionType;
import com.egzosn.pay.common.bean.TransferOrder;
import com.egzosn.pay.common.bean.result.PayError;
import com.egzosn.pay.common.bean.result.PayException;
import com.egzosn.pay.common.exception.PayErrorException;
import com.egzosn.pay.common.http.HttpConfigStorage;
import com.egzosn.pay.common.http.HttpStringEntity;
import com.egzosn.pay.common.http.UriVariables;
import com.egzosn.pay.common.util.DateUtils;
import com.egzosn.pay.common.util.MapGen;
import com.egzosn.pay.wx.bean.WxPayError;
import com.egzosn.pay.wx.v3.api.ProfitSharingService;
import com.egzosn.pay.wx.v3.api.WxPayConfigStorage;
import com.egzosn.pay.wx.v3.api.WxPayService;
import com.egzosn.pay.wx.v3.bean.WxProfitSharingTransactionType;
import com.egzosn.pay.wx.v3.bean.sharing.ProfitSharingBillType;
import com.egzosn.pay.wx.v3.bean.sharing.ProfitSharingPayMessage;
import com.egzosn.pay.wx.v3.bean.sharing.WxProfitSharingReturnResult;
import java.io.InputStream;
import java.util.Date;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;

public class WxProfitSharingService
extends WxPayService
implements ProfitSharingService {
    public WxProfitSharingService(WxPayConfigStorage payConfigStorage) {
        super(payConfigStorage);
    }

    public WxProfitSharingService(WxPayConfigStorage payConfigStorage, HttpConfigStorage configStorage) {
        super(payConfigStorage, configStorage);
    }

    @Override
    protected void initAfter() {
        ((WxPayConfigStorage)this.payConfigStorage).loadCertEnvironment();
        this.setApiServerUrl("https://api.mch.weixin.qq.com");
    }

    @Override
    public boolean verify(Map<String, Object> params) {
        throw new PayErrorException((PayError)new WxPayError("", "\u5206\u8d26\u4e0d\u652f\u6301\u65b9\u5f0f"));
    }

    @Override
    public boolean verify(NoticeParams noticeParams) {
        throw new PayErrorException((PayError)new WxPayError("", "\u5206\u8d26\u4e0d\u652f\u6301\u65b9\u5f0f"));
    }

    @Override
    public JSONObject unifiedOrder(PayOrder order) {
        Map parameters = new MapGen((Object)"appid", (Object)((WxPayConfigStorage)this.payConfigStorage).getAppId()).keyValue((Object)"transaction_id", (Object)order.getTradeNo()).keyValue((Object)"out_order_no", (Object)order.getOutTradeNo()).keyValue((Object)"receivers", order.getAttr("receivers")).keyValue((Object)"unfreeze_unsplit", order.getAttr("unfreeze_unsplit")).getAttr();
        OrderParaStructure.loadParameters((Map)parameters, (String)"sub_mchid", (Order)order);
        OrderParaStructure.loadParameters((Map)parameters, (String)"sub_appid", (Order)order);
        return this.getAssistService().doExecute((Map<String, Object>)parameters, order);
    }

    @Override
    public HttpStringEntity hookHttpEntity(HttpStringEntity entity) {
        entity.addHeader((Header)new BasicHeader("Wechatpay-Serial", ((WxPayConfigStorage)this.payConfigStorage).getCertEnvironment().getPlatformSerialNumber()));
        return entity;
    }

    @Override
    public Map<String, Object> orderInfo(PayOrder order) {
        if (null == order.getTransactionType()) {
            order.setTransactionType((TransactionType)WxProfitSharingTransactionType.ORDERS);
        }
        switch ((WxProfitSharingTransactionType)order.getTransactionType()) {
            case ORDERS_UNFREEZE: {
                return this.unfreeze(order);
            }
            case RECEIVERS_ADD: {
                return this.add(order);
            }
            case RECEIVERS_DELETE: {
                return this.delete(order);
            }
        }
        return this.unifiedOrder(order);
    }

    @Override
    @Deprecated
    public Map<String, Object> getParameter2Map(Map<String, String[]> parameterMap, InputStream is) {
        throw new PayErrorException((PayError)new WxPayError("", "\u5206\u8d26\u4e0d\u652f\u6301\u65b9\u5f0f"));
    }

    @Override
    public String buildRequest(Map<String, Object> orderInfo, MethodType method) {
        throw new PayErrorException((PayError)new WxPayError("", "\u5206\u8d26\u4e0d\u652f\u6301\u65b9\u5f0f"));
    }

    @Override
    public String getQrPay(PayOrder order) {
        throw new PayErrorException((PayError)new WxPayError("", "\u5206\u8d26\u4e0d\u652f\u6301\u65b9\u5f0f"));
    }

    @Override
    public Map<String, Object> microPay(PayOrder order) {
        throw new PayErrorException((PayError)new WxPayError("", "\u5206\u8d26\u4e0d\u652f\u6301\u65b9\u5f0f"));
    }

    @Override
    @Deprecated
    public Map<String, Object> query(String transactionId, String outTradeNo) {
        return this.query(new AssistOrder(transactionId, outTradeNo));
    }

    @Override
    public Map<String, Object> query(AssistOrder assistOrder) {
        if (null == assistOrder.getTransactionType()) {
            assistOrder.setTransactionType((TransactionType)WxProfitSharingTransactionType.ORDERS_RESULT);
        }
        switch ((WxProfitSharingTransactionType)assistOrder.getTransactionType()) {
            case AMOUNTS: {
                return this.getAssistService().doExecute("", assistOrder.getTransactionType(), assistOrder.getTradeNo());
            }
            case MCH_CONFIG: {
                return this.getAssistService().doExecute("", assistOrder.getTransactionType(), assistOrder.getAttr("sub_mchid"));
            }
        }
        Map parameters = new MapGen((Object)"transaction_id", (Object)assistOrder.getTradeNo()).getAttr();
        OrderParaStructure.loadParameters((Map)parameters, (String)"sub_mchid", (Order)assistOrder);
        return this.getAssistService().doExecute(UriVariables.getMapToParameters((Map)parameters), assistOrder.getTransactionType(), assistOrder.getOutTradeNo());
    }

    @Override
    public Map<String, Object> close(String transactionId, String outTradeNo) {
        return this.close(new AssistOrder(outTradeNo));
    }

    @Override
    public Map<String, Object> close(AssistOrder assistOrder) {
        throw new PayErrorException((PayError)new PayException("failure", "V3\u6682\u65f6\u6ca1\u6709\u63d0\u4f9b\u6b64\u529f\u80fd\uff0c\u8bf7\u67e5\u770bV2\u7248\u672c\u529f\u80fd"));
    }

    @Override
    public RefundResult refund(RefundOrder refundOrder) {
        Map parameters = new MapGen((Object)"return_mchid", (Object)((WxPayConfigStorage)this.payConfigStorage).getMchId()).keyValue((Object)"out_return_no", (Object)refundOrder.getRefundNo()).keyValue((Object)"amount", (Object)refundOrder.getRefundAmount().intValue()).keyValue((Object)"description", (Object)refundOrder.getDescription()).getAttr();
        OrderParaStructure.loadParameters((Map)parameters, (String)"sub_mchid", (Order)refundOrder);
        OrderParaStructure.loadParameters((Map)parameters, (String)"order_id", (String)refundOrder.getTradeNo());
        OrderParaStructure.loadParameters((Map)parameters, (String)"out_order_no", (String)refundOrder.getOutTradeNo());
        return WxProfitSharingReturnResult.create((Map<String, Object>)this.getAssistService().doExecute((Map<String, Object>)parameters, WxProfitSharingTransactionType.RETURN_ORDERS));
    }

    @Override
    public Map<String, Object> refundquery(RefundOrder refundOrder) {
        Map parameters = new MapGen((Object)"out_order_no", (Object)refundOrder.getOutTradeNo()).getAttr();
        OrderParaStructure.loadParameters((Map)parameters, (String)"sub_mchid", (Order)refundOrder);
        String requestBody = UriVariables.getMapToParameters((Map)parameters);
        return this.getAssistService().doExecute(requestBody, WxProfitSharingTransactionType.RETURN_ORDERS_RESULT, refundOrder.getRefundNo());
    }

    @Override
    public Map<String, Object> downloadBill(Date billDate, String billType) {
        ProfitSharingBillType wxBillType = ProfitSharingBillType.valueOf(billType);
        return this.downloadBill(billDate, wxBillType);
    }

    @Override
    public Map<String, Object> downloadBill(Date billDate, BillType billType) {
        Map parameters = new MapGen((Object)"bill_date", (Object)DateUtils.formatDate((Date)billDate, (String)"yyyy-MM-dd")).getAttr();
        OrderParaStructure.loadParameters((Map)parameters, (String)"tar_type", (String)billType.getType());
        return this.getAssistService().doExecute(UriVariables.getMapToParameters((Map)parameters), WxProfitSharingTransactionType.BILLS, new Object[0]);
    }

    @Override
    public Map<String, Object> transfer(TransferOrder order) {
        throw new PayErrorException((PayError)new WxPayError("", "\u5206\u8d26\u4e0d\u652f\u6301\u65b9\u5f0f"));
    }

    @Override
    public Map<String, Object> transferQuery(String outNo, String wxTransferType) {
        throw new PayErrorException((PayError)new WxPayError("", "\u5206\u8d26\u4e0d\u652f\u6301\u65b9\u5f0f"));
    }

    @Override
    public PayMessage createMessage(Map<String, Object> message) {
        return ProfitSharingPayMessage.create(message);
    }

    @Override
    public Map<String, Object> add(PayOrder order) {
        if (null == order.getTransactionType()) {
            order.setTransactionType((TransactionType)WxProfitSharingTransactionType.RECEIVERS_ADD);
        }
        Map parameters = new MapGen((Object)"appid", (Object)((WxPayConfigStorage)this.payConfigStorage).getAppId()).getAttr();
        OrderParaStructure.loadParameters((Map)parameters, (String)"type", (Order)order);
        OrderParaStructure.loadParameters((Map)parameters, (String)"account", (Order)order);
        OrderParaStructure.loadParameters((Map)parameters, (String)"name", (Order)order);
        OrderParaStructure.loadParameters((Map)parameters, (String)"relationType", (Order)order);
        OrderParaStructure.loadParameters((Map)parameters, (String)"customRelation", (Order)order);
        OrderParaStructure.loadParameters((Map)parameters, (String)"sub_mchid", (Order)order);
        OrderParaStructure.loadParameters((Map)parameters, (String)"sub_appid", (Order)order);
        return this.getAssistService().doExecute((Map<String, Object>)parameters, order);
    }

    @Override
    public Map<String, Object> delete(PayOrder order) {
        if (null == order.getTransactionType()) {
            order.setTransactionType((TransactionType)WxProfitSharingTransactionType.RECEIVERS_DELETE);
        }
        Map parameters = new MapGen((Object)"appid", (Object)((WxPayConfigStorage)this.payConfigStorage).getAppId()).getAttr();
        OrderParaStructure.loadParameters((Map)parameters, (String)"type", (Order)order);
        OrderParaStructure.loadParameters((Map)parameters, (String)"account", (Order)order);
        OrderParaStructure.loadParameters((Map)parameters, (String)"sub_mchid", (Order)order);
        OrderParaStructure.loadParameters((Map)parameters, (String)"sub_appid", (Order)order);
        return this.getAssistService().doExecute((Map<String, Object>)parameters, order);
    }

    @Override
    public Map<String, Object> unfreeze(PayOrder order) {
        if (null == order.getTransactionType()) {
            order.setTransactionType((TransactionType)WxProfitSharingTransactionType.ORDERS_UNFREEZE);
        }
        Map parameters = new MapGen((Object)"transaction_id", (Object)order.getTradeNo()).keyValue((Object)"out_order_no", (Object)order.getOutTradeNo()).getAttr();
        OrderParaStructure.loadParameters((Map)parameters, (String)"description", (String)order.getSubject());
        OrderParaStructure.loadParameters((Map)parameters, (String)"description", (String)order.getBody());
        OrderParaStructure.loadParameters((Map)parameters, (String)"description", (Order)order);
        OrderParaStructure.loadParameters((Map)parameters, (String)"sub_mchid", (Order)order);
        return this.getAssistService().doExecute((Map<String, Object>)parameters, order);
    }
}

