/*
 * Decompiled with CFR 0.152.
 */
package com.egzosn.pay.wx.v3.bean;

import com.egzosn.pay.common.bean.BillType;
import com.egzosn.pay.common.util.str.StringUtils;
import com.egzosn.pay.wx.v3.bean.WxTransactionType;

public enum WxAccountType implements BillType
{
    BASIC("BASIC"),
    BASIC_GZIP("BASIC", "GZIP"),
    OPERATION("OPERATION"),
    OPERATION_GZIP("OPERATION", "GZIP"),
    FEES("FEES"),
    FEES_GZIP("FEES", "GZIP");

    private String type;
    private String tarType;

    private WxAccountType(String type) {
        this.type = type;
    }

    private WxAccountType(String type, String tarType) {
        this.type = type;
        this.tarType = tarType;
    }

    public String getType() {
        return this.type;
    }

    public String getDatePattern() {
        return null;
    }

    public String getFileType() {
        return this.tarType;
    }

    public String getCustom() {
        return WxTransactionType.FUND_FLOW_BILL.name();
    }

    public static WxAccountType forType(String type) {
        for (WxAccountType wxPayBillType : WxAccountType.values()) {
            if (!wxPayBillType.getType().equals(type) || !StringUtils.isEmpty((CharSequence)wxPayBillType.getFileType())) continue;
            return wxPayBillType;
        }
        return null;
    }
}

