/*
 * Decompiled with CFR 0.152.
 */
package com.egzosn.pay.wx.v3.bean;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.egzosn.pay.common.bean.MethodType;
import com.egzosn.pay.common.bean.PayOrder;
import com.egzosn.pay.common.bean.TransactionType;
import com.egzosn.pay.common.util.MapGen;
import com.egzosn.pay.common.util.str.StringUtils;
import com.egzosn.pay.wx.v3.bean.order.H5Info;
import com.egzosn.pay.wx.v3.bean.order.SceneInfo;
import java.util.Map;

public enum WxTransactionType implements TransactionType
{
    CERT("/v3/certificates", MethodType.GET),
    JSAPI("/v3/pay{partner}/transactions/jsapi", MethodType.POST){

        @Override
        public void setAttribute(Map<String, Object> parameters, PayOrder order) {
            String key = parameters.containsKey("sub_mchid") ? "sub_openid" : "openid";
            MapGen mapGen = new MapGen((Object)key, (Object)order.getOpenid());
            parameters.put("payer", mapGen.getAttr());
        }
    }
    ,
    NATIVE("/v3/pay{partner}/transactions/native", MethodType.POST, true),
    APP("/v3/pay{partner}/transactions/app", MethodType.POST),
    H5("/v3/pay{partner}/transactions/h5", MethodType.POST, true){

        @Override
        public void setAttribute(Map<String, Object> parameters, PayOrder order) {
            H5Info h5Info;
            Object sceneInfoObj = parameters.get("scene_info");
            SceneInfo sceneInfo = null;
            if (null == sceneInfoObj) {
                sceneInfo = new SceneInfo();
            } else if (sceneInfoObj instanceof SceneInfo) {
                sceneInfo = (SceneInfo)sceneInfoObj;
            } else {
                String jsonString = JSON.toJSONString((Object)sceneInfoObj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
                sceneInfo = (SceneInfo)JSON.parseObject((String)jsonString, SceneInfo.class);
            }
            String billCreateIp = order.getSpbillCreateIp();
            if (StringUtils.isNotEmpty((CharSequence)billCreateIp)) {
                sceneInfo.setPayerClientIp(billCreateIp);
            }
            if (null == (h5Info = sceneInfo.getH5Info())) {
                sceneInfo.setH5Info(new H5Info(order.getWapName(), order.getWapUrl()));
            }
            parameters.put("scene_info", sceneInfo);
        }
    }
    ,
    MWEB("/v3/pay{partner}/transactions/h5", MethodType.POST, true){

        @Override
        public void setAttribute(Map<String, Object> parameters, PayOrder order) {
            H5.setAttribute(parameters, order);
        }
    }
    ,
    QUERY("/v3/pay{partner}/transactions/", MethodType.GET),
    QUERY_TRANSACTION_ID("/v3/pay{partner}/transactions/id/{transaction_id}", MethodType.GET),
    QUERY_OUT_TRADE_NO("/v3/pay{partner}/transactions/out-trade-no/{out_trade_no}", MethodType.GET),
    CLOSE("/v3/pay{partner}/transactions/out-trade-no/{out_trade_no}/close", MethodType.POST),
    REFUND("/v3/refund/domestic/refunds", MethodType.POST),
    REFUND_QUERY("/v3/refund/domestic/refunds/{out_refund_no}", MethodType.GET),
    TRADE_BILL("/v3/bill/tradebill", MethodType.GET),
    FUND_FLOW_BILL("/v3/bill/fundflowbill", MethodType.GET),
    COMBINE_APP("/v3/combine-transactions/app", MethodType.POST),
    COMBINE_JSAPI("/v3/combine-transactions/jsapi", MethodType.POST),
    COMBINE_H5("/v3/combine-transactions/h5", MethodType.POST, true),
    COMBINE_NATIVE("/v3/combine-transactions/native", MethodType.POST, true),
    COMBINE_TRANSACTION("/v3/combine-transactions/out-trade-no/{combine_out_trade_no}", MethodType.GET),
    COMBINE_CLOSE("/v3/combine-transactions/out-trade-no/{combine_out_trade_no}/close", MethodType.POST);

    private String type;
    private MethodType method;
    private boolean back;

    private WxTransactionType(String type, MethodType method) {
        this(type, method, false);
    }

    private WxTransactionType(String type, MethodType method, boolean back) {
        this.type = type;
        this.method = method;
        this.back = back;
    }

    public String getType() {
        return this.type;
    }

    public String getMethod() {
        return this.method.name();
    }

    public boolean isReturn() {
        return this.back;
    }

    public void setAttribute(Map<String, Object> parameters, PayOrder order) {
    }
}

