/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.okhttps;

import com.ejlchina.data.Array;
import com.ejlchina.data.Mapper;
import com.ejlchina.data.TypeRef;
import com.ejlchina.okhttps.HttpCall;
import com.ejlchina.okhttps.HttpResult;
import com.ejlchina.okhttps.HttpTask;
import com.ejlchina.okhttps.OkHttpsException;
import com.ejlchina.okhttps.TaskExecutor;
import com.ejlchina.okhttps.internal.AbstractHttpClient;
import com.ejlchina.okhttps.internal.RealHttpResult;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;

public class AHttpTask
extends HttpTask<AHttpTask> {
    private Consumer<HttpResult> onResponse;
    private Consumer<IOException> onException;
    private Consumer<HttpResult.State> onComplete;
    private boolean responseOnIO;
    private boolean exceptionOnIO;
    private boolean completeOnIO;
    private Consumer<HttpResult.Body> onResBody;
    private Consumer<Mapper> onResMapper;
    private Consumer<Array> onResArray;
    private Consumer<String> onResString;
    private Consumer<?> onResBean;
    private Consumer<?> onResList;
    private boolean resBodyOnIO;
    private boolean resMapperOnIO;
    private boolean resArrayOnIO;
    private boolean resStringOnIO;
    private boolean resBeanOnIO;
    private boolean resListOnIO;
    private Type beanType;
    private Class<?> listType;

    public AHttpTask(AbstractHttpClient client, String url) {
        super(client, url);
    }

    @Override
    public boolean isAsyncHttp() {
        return true;
    }

    public AHttpTask setOnException(Consumer<IOException> onException) {
        this.onException = onException;
        this.exceptionOnIO = this.nextOnIO;
        this.nextOnIO = false;
        return this;
    }

    public AHttpTask setOnComplete(Consumer<HttpResult.State> onComplete) {
        this.onComplete = onComplete;
        this.completeOnIO = this.nextOnIO;
        this.nextOnIO = false;
        return this;
    }

    public synchronized AHttpTask setOnResponse(Consumer<HttpResult> onResponse) {
        this.onResponse = onResponse;
        this.responseOnIO = this.nextOnIO;
        this.nextOnIO = false;
        return this;
    }

    public synchronized AHttpTask setOnResBody(Consumer<HttpResult.Body> onResBody) {
        this.onResBody = onResBody;
        this.resBodyOnIO = this.nextOnIO;
        this.nextOnIO = false;
        return this;
    }

    public synchronized <T> AHttpTask setOnResBean(Class<T> type, Consumer<T> onResBean) {
        this.initBeanType(type);
        this.onResBean = onResBean;
        this.resBeanOnIO = this.nextOnIO;
        this.nextOnIO = false;
        return this;
    }

    public synchronized <T> AHttpTask setOnResBean(TypeRef<T> type, Consumer<T> onResBean) {
        this.initBeanType(type.getType());
        this.onResBean = onResBean;
        this.resBeanOnIO = this.nextOnIO;
        this.nextOnIO = false;
        return this;
    }

    public synchronized <T> AHttpTask setOnResList(Class<T> type, Consumer<List<T>> onResList) {
        if (type == null) {
            throw new IllegalArgumentException(" list type can not be null!");
        }
        this.listType = type;
        this.onResList = onResList;
        this.resListOnIO = this.nextOnIO;
        this.nextOnIO = false;
        return this;
    }

    public synchronized AHttpTask setOnResMapper(Consumer<Mapper> onResMapper) {
        this.onResMapper = onResMapper;
        this.resMapperOnIO = this.nextOnIO;
        this.nextOnIO = false;
        return this;
    }

    public synchronized AHttpTask setOnResArray(Consumer<Array> onResArray) {
        this.onResArray = onResArray;
        this.resArrayOnIO = this.nextOnIO;
        this.nextOnIO = false;
        return this;
    }

    public synchronized AHttpTask setOnResString(Consumer<String> onResString) {
        this.onResString = onResString;
        this.resStringOnIO = this.nextOnIO;
        this.nextOnIO = false;
        return this;
    }

    public HttpCall get() {
        return this.request("GET");
    }

    public HttpCall head() {
        return this.request("HEAD");
    }

    public HttpCall post() {
        return this.request("POST");
    }

    public HttpCall put() {
        return this.request("PUT");
    }

    public HttpCall patch() {
        return this.request("PATCH");
    }

    public HttpCall delete() {
        return this.request("DELETE");
    }

    public HttpCall request(String method) {
        if (method == null || method.isEmpty()) {
            throw new IllegalArgumentException("HTTP \u8bf7\u6c42\u65b9\u6cd5 method \u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        PreHttpCall call = new PreHttpCall();
        this.registeTagTask(call);
        this.httpClient.preprocess(this, () -> {
            PreHttpCall preHttpCall = call;
            synchronized (preHttpCall) {
                if (call.canceled) {
                    this.removeTagTask();
                } else {
                    if (this.onResponse != null || this.onResBody != null) {
                        this.tag("okhttps-Async-Response-Copy");
                    }
                    call.setCall(this.executeCall(this.prepareCall(method)));
                }
            }
        }, this.skipPreproc, this.skipSerialPreproc);
        return call;
    }

    private HttpCall executeCall(Call call) {
        final OkHttpCall httpCall = new OkHttpCall(call);
        call.enqueue(new Callback(){

            public void onFailure(Call call, IOException error) {
                HttpResult.State state = AHttpTask.this.toState(error);
                RealHttpResult result = new RealHttpResult(AHttpTask.this, state, error);
                AHttpTask.this.onCallback(httpCall, result, () -> {
                    TaskExecutor executor = AHttpTask.this.httpClient.executor();
                    executor.executeOnComplete(AHttpTask.this, AHttpTask.this.onComplete, state, AHttpTask.this.completeOnIO);
                    if (!(httpCall.isCanceled() || executor.executeOnException(AHttpTask.this, httpCall, AHttpTask.this.onException, error, AHttpTask.this.exceptionOnIO) || AHttpTask.this.nothrow)) {
                        throw new OkHttpsException(state, "\u5f02\u6b65\u8bf7\u6c42\u5f02\u5e38\uff1a" + AHttpTask.this.getUrl(), error);
                    }
                });
            }

            public void onResponse(Call call, Response response) {
                TaskExecutor executor = AHttpTask.this.httpClient.executor();
                RealHttpResult result = new RealHttpResult(AHttpTask.this, response, executor);
                AHttpTask.this.onCallback(httpCall, result, () -> {
                    executor.executeOnComplete(AHttpTask.this, AHttpTask.this.onComplete, HttpResult.State.RESPONSED, AHttpTask.this.completeOnIO);
                    if (!httpCall.isCanceled()) {
                        executor.executeOnResponse(AHttpTask.this, httpCall, AHttpTask.this.complexOnResponse(httpCall), result, true);
                    }
                });
            }
        });
        return httpCall;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCallback(OkHttpCall httpCall, HttpResult result, Runnable runnable) {
        OkHttpCall okHttpCall = httpCall;
        synchronized (okHttpCall) {
            this.removeTagTask();
            if (httpCall.isCanceled() || result.getState() == HttpResult.State.CANCELED) {
                httpCall.setResult(new RealHttpResult(this, HttpResult.State.CANCELED));
            } else {
                httpCall.setResult(result);
            }
            runnable.run();
        }
    }

    private synchronized Consumer<HttpResult> complexOnResponse(final OkHttpCall call) {
        return res -> {
            Consumer<HttpResult> onResp = this.onResponse;
            Consumer<HttpResult.Body> onBody = this.onResBody;
            Consumer<Mapper> onMapper = this.onResMapper;
            Consumer<Array> onArray = this.onResArray;
            Consumer<?> onBean = this.onResBean;
            Consumer<?> onList = this.onResList;
            Consumer<String> onString = this.onResString;
            int count = 0;
            if (onResp != null) {
                ++count;
            }
            if (onBody != null) {
                ++count;
            }
            if (onMapper != null) {
                ++count;
            }
            if (onArray != null) {
                ++count;
            }
            if (onBean != null) {
                ++count;
            }
            if (onList != null) {
                ++count;
            }
            if (onString != null) {
                ++count;
            }
            final int callbackCount = count;
            HttpResult.Body body = res.getBody();
            if (callbackCount > 1) {
                body.cache();
            }
            ResponseCallback callback = (runnable, onIo) -> this.execute(new Runnable(){
                int count = 0;

                @Override
                public void run() {
                    if (!call.isCanceled()) {
                        runnable.run();
                    }
                    if (++this.count >= callbackCount) {
                        call.finish();
                    }
                }
            }, onIo);
            if (onResp != null) {
                callback.on(() -> onResp.accept((HttpResult)res), this.responseOnIO);
            }
            if (onBody != null) {
                callback.on(() -> onBody.accept(body), this.resBodyOnIO);
            }
            if (onMapper != null) {
                Mapper mapper = body.toMapper();
                callback.on(() -> onMapper.accept(mapper), this.resMapperOnIO);
            }
            if (onArray != null) {
                Array array = body.toArray();
                callback.on(() -> onArray.accept(array), this.resArrayOnIO);
            }
            if (onBean != null) {
                Object bean = body.toBean(this.beanType);
                callback.on(() -> onBean.accept(bean), this.resBeanOnIO);
            }
            if (onList != null) {
                List<?> list = body.toList(this.listType);
                callback.on(() -> onList.accept(list), this.resListOnIO);
            }
            if (onString != null) {
                String string = body.toString();
                callback.on(() -> onString.accept(string), this.resStringOnIO);
            }
        };
    }

    private void initBeanType(Type type) {
        if (type == null) {
            throw new IllegalArgumentException(" bean type can not be null!");
        }
        if (this.beanType != null) {
            throw new IllegalStateException("\u5df2\u7ecf\u6dfb\u52a0\u4e86 OnResBean \u56de\u8c03\uff01");
        }
        this.beanType = type;
    }

    public class OkHttpCall
    implements HttpCall {
        final Call call;
        HttpResult result;
        CountDownLatch latch = new CountDownLatch(1);
        boolean finished = false;

        OkHttpCall(Call call) {
            this.call = call;
        }

        @Override
        public synchronized boolean cancel() {
            if (this.result == null || !this.finished) {
                this.call.cancel();
                return true;
            }
            return false;
        }

        @Override
        public boolean isDone() {
            return this.result != null && this.finished || this.call.isCanceled();
        }

        @Override
        public boolean isCanceled() {
            return this.call.isCanceled() || this.result != null && this.result.getState() == HttpResult.State.CANCELED;
        }

        @Override
        public HttpResult getResult() {
            if (this.result == null && AHttpTask.this.timeoutAwait(this.latch)) {
                this.cancel();
                return AHttpTask.this.timeoutResult();
            }
            return this.result;
        }

        @Override
        public AHttpTask getTask() {
            return AHttpTask.this;
        }

        void setResult(HttpResult result) {
            this.result = result;
            this.latch.countDown();
        }

        public void finish() {
            this.finished = true;
        }
    }

    class PreHttpCall
    implements HttpCall {
        HttpCall call;
        boolean canceled = false;
        CountDownLatch latch = new CountDownLatch(1);

        PreHttpCall() {
        }

        @Override
        public synchronized boolean cancel() {
            this.canceled = this.call == null || this.call.cancel();
            this.latch.countDown();
            return this.canceled;
        }

        @Override
        public boolean isDone() {
            if (this.call != null) {
                return this.call.isDone();
            }
            return this.canceled;
        }

        @Override
        public boolean isCanceled() {
            return this.canceled;
        }

        void setCall(HttpCall call) {
            this.call = call;
            this.latch.countDown();
        }

        @Override
        public HttpResult getResult() {
            if (AHttpTask.this.timeoutAwait(this.latch)) {
                this.cancel();
                return AHttpTask.this.timeoutResult();
            }
            if (this.canceled || this.call == null) {
                return new RealHttpResult(AHttpTask.this, HttpResult.State.CANCELED);
            }
            return this.call.getResult();
        }

        @Override
        public AHttpTask getTask() {
            return AHttpTask.this;
        }
    }

    static interface ResponseCallback {
        public void on(Runnable var1, boolean var2);
    }
}

