/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.okhttps.okhttp;

import com.ejlchina.okhttps.DownListener;
import com.ejlchina.okhttps.DownloadHelper;
import com.ejlchina.okhttps.HTTP;
import com.ejlchina.okhttps.HttpResult;
import com.ejlchina.okhttps.MsgConvertor;
import com.ejlchina.okhttps.Platform;
import com.ejlchina.okhttps.Preprocessor;
import com.ejlchina.okhttps.Scheduler;
import com.ejlchina.okhttps.TaskExecutor;
import com.ejlchina.okhttps.TaskListener;
import com.ejlchina.okhttps.internal.CopyInterceptor;
import com.ejlchina.okhttps.internal.SerialPreprocessor;
import com.ejlchina.okhttps.okhttp.OkHttpClientWrapper;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public class OkHttpBuilderImpl
implements HTTP.Builder {
    private OkHttpClient okClient;
    private String baseUrl;
    private final List<HTTP.OkConfig> configs;
    private final Map<String, String> mediaTypes;
    private final List<String> contentTypes;
    private final List<MsgConvertor> msgConvertors;
    private final List<Preprocessor> preprocessors;
    private int preprocTimeoutTimes = 10;
    private Executor mainExecutor;
    private Scheduler taskScheduler;
    private DownListener downloadListener;
    private TaskListener<HttpResult> responseListener;
    private TaskListener<IOException> exceptionListener;
    private TaskListener<HttpResult.State> completeListener;
    private Charset charset = StandardCharsets.UTF_8;
    private String bodyType = "form";
    private DownloadHelper downloadHelper;

    public OkHttpBuilderImpl() {
        this.mediaTypes = new HashMap<String, String>();
        this.mediaTypes.put("png", "image/png");
        this.mediaTypes.put("jpg", "image/jpeg");
        this.mediaTypes.put("jpeg", "image/jpeg");
        this.mediaTypes.put("wav", "audio/wav");
        this.mediaTypes.put("mp3", "audio/mp3");
        this.mediaTypes.put("mp4", "video/mp4");
        this.mediaTypes.put("txt", "text/plain");
        this.mediaTypes.put("xls", "application/x-xls");
        this.mediaTypes.put("xlsx", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        this.mediaTypes.put("xml", "text/xml");
        this.mediaTypes.put("apk", "application/vnd.android.package-archive");
        this.mediaTypes.put("doc", "application/msword");
        this.mediaTypes.put("docx", "application/vnd.openxmlformats-officedocument.wordprocessingml.document");
        this.mediaTypes.put("html", "text/html");
        this.mediaTypes.put("rar", "application/x-rar");
        this.mediaTypes.put("jar", "application/x-java-archive");
        this.contentTypes = new ArrayList<String>();
        this.contentTypes.add("application/x-www-form-urlencoded");
        this.contentTypes.add("application/json");
        this.contentTypes.add("application/xml");
        this.contentTypes.add("application/protobuf");
        this.contentTypes.add("application/msgpack");
        this.preprocessors = new ArrayList<Preprocessor>();
        this.msgConvertors = new ArrayList<MsgConvertor>();
        this.configs = new ArrayList<HTTP.OkConfig>();
        this.downloadHelper = new DownloadHelper();
    }

    public OkHttpBuilderImpl(OkHttpClientWrapper hc) {
        this.okClient = hc.okClient();
        this.baseUrl = hc.baseUrl();
        this.mediaTypes = hc.mediaTypes();
        this.preprocessors = new ArrayList<Preprocessor>();
        Collections.addAll(this.preprocessors, hc.preprocessors());
        TaskExecutor executor = hc.executor();
        this.contentTypes = new ArrayList<String>();
        Collections.addAll(this.contentTypes, executor.getContentTypes());
        this.mainExecutor = executor.getMainExecutor();
        this.taskScheduler = executor.getTaskScheduler();
        this.downloadListener = executor.getDownloadListener();
        this.responseListener = executor.getResponseListener();
        this.exceptionListener = executor.getExceptionListener();
        this.completeListener = executor.getCompleteListener();
        this.msgConvertors = new ArrayList<MsgConvertor>();
        Collections.addAll(this.msgConvertors, executor.getMsgConvertors());
        this.preprocTimeoutTimes = hc.preprocTimeoutTimes();
        this.configs = new ArrayList<HTTP.OkConfig>();
        this.bodyType = hc.bodyType();
        this.charset = hc.charset();
        this.downloadHelper = hc.downloadHelper();
    }

    @Override
    public HTTP.Builder config(HTTP.OkConfig config) {
        if (config != null) {
            this.configs.add(config);
        }
        return this;
    }

    @Override
    public HTTP.Builder baseUrl(String baseUrl) {
        if (baseUrl != null) {
            this.baseUrl = baseUrl.trim();
        }
        return this;
    }

    @Override
    public HTTP.Builder mediaTypes(Map<String, String> mediaTypes) {
        if (mediaTypes != null) {
            this.mediaTypes.putAll(mediaTypes);
        }
        return this;
    }

    @Override
    public HTTP.Builder mediaTypes(String key, String value) {
        if (key != null && value != null) {
            this.mediaTypes.put(key, value);
        }
        return this;
    }

    @Override
    public HTTP.Builder clearContentTypes() {
        this.contentTypes.clear();
        return this;
    }

    @Override
    public HTTP.Builder contentTypes(List<String> contentTypes) {
        if (contentTypes != null) {
            this.contentTypes.addAll(contentTypes);
        }
        return this;
    }

    @Override
    public HTTP.Builder contentTypes(String contentType) {
        if (contentType != null) {
            this.contentTypes.add(contentType);
        }
        return this;
    }

    @Override
    public HTTP.Builder callbackExecutor(Executor executor) {
        this.mainExecutor = executor;
        return this;
    }

    @Override
    public HTTP.Builder taskScheduler(Scheduler scheduler) {
        this.taskScheduler = scheduler;
        return this;
    }

    @Override
    public HTTP.Builder addPreprocessor(Preprocessor preprocessor) {
        if (preprocessor != null) {
            this.preprocessors.add(preprocessor);
        }
        return this;
    }

    @Override
    public HTTP.Builder addSerialPreprocessor(Preprocessor preprocessor) {
        if (preprocessor != null) {
            this.preprocessors.add(new SerialPreprocessor(preprocessor));
        }
        return this;
    }

    @Override
    public HTTP.Builder clearPreprocessors() {
        this.preprocessors.clear();
        return this;
    }

    @Override
    public HTTP.Builder preprocTimeoutTimes(int times) {
        if (times > 0) {
            this.preprocTimeoutTimes = times;
        }
        return this;
    }

    @Override
    public HTTP.Builder responseListener(TaskListener<HttpResult> listener) {
        this.responseListener = listener;
        return this;
    }

    @Override
    public HTTP.Builder exceptionListener(TaskListener<IOException> listener) {
        this.exceptionListener = listener;
        return this;
    }

    @Override
    public HTTP.Builder completeListener(TaskListener<HttpResult.State> listener) {
        this.completeListener = listener;
        return this;
    }

    @Override
    public HTTP.Builder downloadListener(DownListener listener) {
        this.downloadListener = listener;
        return this;
    }

    @Override
    public HTTP.Builder addMsgConvertor(MsgConvertor msgConvertor) {
        if (msgConvertor != null) {
            this.msgConvertors.add(msgConvertor);
        }
        return this;
    }

    @Override
    public HTTP.Builder clearMsgConvertors() {
        this.msgConvertors.clear();
        return this;
    }

    @Override
    public HTTP.Builder charset(Charset charset) {
        if (charset != null) {
            this.charset = charset;
        }
        return this;
    }

    @Override
    public HTTP.Builder bodyType(String bodyType) {
        if (bodyType != null) {
            this.bodyType = bodyType.toLowerCase();
        }
        return this;
    }

    @Override
    public HTTP build() {
        if (this.configs.size() > 0 || this.okClient == null) {
            OkHttpClient.Builder builder = this.okClient != null ? this.okClient.newBuilder() : new OkHttpClient.Builder();
            for (HTTP.OkConfig config : this.configs) {
                config.config(builder);
            }
            if (this.needCopyInterceptor(builder.interceptors())) {
                builder.addInterceptor((Interceptor)new CopyInterceptor());
            }
            this.okClient = builder.build();
        } else if (this.needCopyInterceptor(this.okClient.interceptors())) {
            this.okClient = this.okClient.newBuilder().addInterceptor((Interceptor)new CopyInterceptor()).build();
        }
        return new OkHttpClientWrapper(this);
    }

    private boolean needCopyInterceptor(List<Interceptor> list) {
        return this.mainExecutor != null && Platform.ANDROID_SDK_INT > 24 && CopyInterceptor.notIn(list);
    }

    public OkHttpClient okClient() {
        return this.okClient;
    }

    @Override
    public String baseUrl() {
        return this.baseUrl;
    }

    @Override
    public Map<String, String> getMediaTypes() {
        return this.mediaTypes;
    }

    @Override
    public Executor mainExecutor() {
        return this.mainExecutor;
    }

    @Override
    public Preprocessor[] preprocessors() {
        return this.preprocessors.toArray(new Preprocessor[0]);
    }

    @Override
    public DownListener downloadListener() {
        return this.downloadListener;
    }

    @Override
    public TaskListener<HttpResult> responseListener() {
        return this.responseListener;
    }

    @Override
    public TaskListener<IOException> exceptionListener() {
        return this.exceptionListener;
    }

    @Override
    public TaskListener<HttpResult.State> completeListener() {
        return this.completeListener;
    }

    @Override
    public MsgConvertor[] msgConvertors() {
        return this.msgConvertors.toArray(new MsgConvertor[0]);
    }

    @Override
    public Scheduler taskScheduler() {
        return this.taskScheduler;
    }

    @Override
    public String[] contentTypes() {
        return this.contentTypes.toArray(new String[0]);
    }

    @Override
    public int preprocTimeoutTimes() {
        return this.preprocTimeoutTimes;
    }

    @Override
    public Charset charset() {
        return this.charset;
    }

    @Override
    public String bodyType() {
        return this.bodyType;
    }

    @Override
    public HTTP.Builder downloadHelper(DownloadHelper downloadHelper) {
        this.downloadHelper = downloadHelper;
        return this;
    }

    @Override
    public DownloadHelper downloadHelper() {
        return this.downloadHelper;
    }
}

