/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.okhttps.okhttp;

import com.ejlchina.okhttps.HTTP;
import com.ejlchina.okhttps.internal.AbstractHttpClient;
import com.ejlchina.okhttps.okhttp.OkHttpBuilderImpl;
import java.util.concurrent.Executor;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;

public class OkHttpClientWrapper
extends AbstractHttpClient {
    final OkHttpClient okClient;

    public OkHttpClientWrapper(OkHttpBuilderImpl builder) {
        super(builder);
        this.okClient = builder.okClient();
    }

    @Override
    public Executor ioExecutor(HTTP.Builder builder) {
        OkHttpBuilderImpl builderImpl = (OkHttpBuilderImpl)builder;
        return builderImpl.okClient().dispatcher().executorService();
    }

    @Override
    public void doCancelAll() {
        this.okClient.dispatcher().cancelAll();
    }

    @Override
    public Call request(Request request) {
        return this.okClient.newCall(request);
    }

    @Override
    public WebSocket webSocket(Request request, WebSocketListener listener) {
        return this.okClient.newWebSocket(request, listener);
    }

    public OkHttpClient okClient() {
        return this.okClient;
    }

    @Override
    public int totalTimeoutMillis() {
        return this.okClient.connectTimeoutMillis() + this.okClient.writeTimeoutMillis() + this.okClient.readTimeoutMillis();
    }

    @Override
    public HTTP.Builder newBuilder() {
        return new OkHttpBuilderImpl(this);
    }
}

