/*
 * *************************************************************************************
 *  Copyright (C) 2006-2015 EsperTech, Inc. All rights reserved.                       *
 *  http://www.espertech.com/esper                                                     *
 *  http://www.espertech.com                                                           *
 *  ---------------------------------------------------------------------------------- *
 *  The software in this package is published under the terms of the GPL license       *
 *  a copy of which has been included with this distribution in the license.txt file.  *
 * *************************************************************************************
 */

package com.espertech.esper.client.deploy;

import java.util.Set;
import java.util.List;

/**
 * Result object of an undeployment operation.
 */
public class UndeploymentResult
{
    private final String deploymentId;
    private final List<DeploymentInformationItem> statementInfo;

    /**
     * Ctor.
     * @param deploymentId id generated by deployment operation
     * @param statementInfo statement-level deployment information
     */
    public UndeploymentResult(String deploymentId, List<DeploymentInformationItem> statementInfo)
    {
        this.deploymentId = deploymentId;
        this.statementInfo = statementInfo;
    }

    /**
     * Returns the deployment id.
     * @return id
     */
    public String getDeploymentId()
    {
        return deploymentId;
    }

    /**
     * Statement-level undeploy information.
     * @return statement info
     */
    public List<DeploymentInformationItem> getStatementInfo()
    {
        return statementInfo;
    }
}
