/**************************************************************************************
 * Copyright (C) 2006-2015 EsperTech Inc. All rights reserved.                        *
 * http://www.espertech.com/esper                                                          *
 * http://www.espertech.com                                                           *
 * ---------------------------------------------------------------------------------- *
 * The software in this package is published under the terms of the GPL license       *
 * a copy of which has been included with this distribution in the license.txt file.  *
 **************************************************************************************/
package com.espertech.esper.client.soda;

import java.io.StringWriter;

/**
 * Count of (distinct) rows, equivalent to "count(*)"
 */
public class CountStarProjectionExpression extends ExpressionBase
{
    private static final long serialVersionUID = -784442964133996045L;

    /**
     * Ctor - for use to create an expression tree, without inner expression.
     */
    public CountStarProjectionExpression()
    {
    }

    public ExpressionPrecedenceEnum getPrecedence()
    {
        return ExpressionPrecedenceEnum.UNARY;
    }

    public void toPrecedenceFreeEPL(StringWriter writer)
    {
        ExpressionBase.renderAggregation(writer, "count", false, this.getChildren());
    }
}
