/***************************************************************************************
 * Attribution Notice
 *
 * This file is imported from Metrics (https://github.com/codahale/metrics subproject metrics-core).
 * Metrics is Copyright (c) 2010-2012 Coda Hale, Yammer.com
 * Metrics is Published under Apache Software License 2.0, see LICENSE in root folder.
 *
 * Thank you for the Metrics developers efforts in making their library available under an Apache license.
 * EsperTech incorporates Metrics version 0.2.2 in source code form since Metrics depends on SLF4J
 * and this dependency is not possible to introduce for Esper.
 * *************************************************************************************
 */
package com.espertech.esper.metrics.codahale_metrics.metrics.core;

import java.util.EventListener;

/**
 * Listeners for events from the registry.  Listeners must be thread-safe.
 */
public interface MetricsRegistryListener extends EventListener {
    /**
     * Called when a metric has been added to the {@link MetricsRegistry}.
     *
     * @param name   the name of the {@link Metric}
     * @param metric the {@link Metric}
     */
    void onMetricAdded(MetricName name, Metric metric);

    /**
     * Called when a metric has been removed from the {@link MetricsRegistry}.
     *
     * @param name the name of the {@link Metric}
     */
    void onMetricRemoved(MetricName name);
}
