/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.http.server;

import com.facebook.airlift.http.server.AuthenticationException;
import com.facebook.airlift.http.server.Authenticator;
import com.facebook.airlift.http.server.BasicPrincipal;
import com.facebook.airlift.http.server.JsonWebTokenConfig;
import com.facebook.airlift.security.pem.PemReader;
import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.io.Files;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.SignatureException;
import io.jsonwebtoken.SigningKeyResolver;
import io.jsonwebtoken.UnsupportedJwtException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.Principal;
import java.util.Base64;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import javax.crypto.spec.SecretKeySpec;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;

public class JsonWebTokenAuthenticator
implements Authenticator {
    private static final String DEFAULT_KEY = "default-key";
    private static final CharMatcher INVALID_KID_CHARS = CharMatcher.inRange((char)'a', (char)'z').or(CharMatcher.inRange((char)'A', (char)'Z')).or(CharMatcher.inRange((char)'0', (char)'9')).or(CharMatcher.anyOf((CharSequence)"_-")).negate();
    private static final String KEY_ID_VARIABLE = "${KID}";
    private final JwtParser jwtParser;
    private final Function<JwsHeader<?>, Key> keyLoader;

    @Inject
    public JsonWebTokenAuthenticator(JsonWebTokenConfig config) {
        Objects.requireNonNull(config, "config is null");
        this.keyLoader = config.getKeyFile().contains(KEY_ID_VARIABLE) ? new DynamicKeyLoader(config.getKeyFile()) : new StaticKeyLoader(config.getKeyFile());
        JwtParser jwtParser = Jwts.parser().setSigningKeyResolver(new SigningKeyResolver(){

            public Key resolveSigningKey(JwsHeader header, Claims claims) {
                return (Key)JsonWebTokenAuthenticator.this.keyLoader.apply(header);
            }

            public Key resolveSigningKey(JwsHeader header, String plaintext) {
                return (Key)JsonWebTokenAuthenticator.this.keyLoader.apply(header);
            }
        });
        if (config.getRequiredIssuer() != null) {
            jwtParser.requireIssuer(config.getRequiredIssuer());
        }
        if (config.getRequiredAudience() != null) {
            jwtParser.requireAudience(config.getRequiredAudience());
        }
        this.jwtParser = jwtParser;
    }

    @Override
    public Principal authenticate(HttpServletRequest request) throws AuthenticationException {
        String header = Strings.nullToEmpty((String)request.getHeader("Authorization"));
        int space = header.indexOf(32);
        if (space < 0 || !header.substring(0, space).equalsIgnoreCase("bearer")) {
            throw JsonWebTokenAuthenticator.needAuthentication(null);
        }
        String token = header.substring(space + 1).trim();
        if (token.isEmpty()) {
            throw JsonWebTokenAuthenticator.needAuthentication(null);
        }
        try {
            Jws claimsJws = this.jwtParser.parseClaimsJws(token);
            String subject = ((Claims)claimsJws.getBody()).getSubject();
            return new BasicPrincipal(subject);
        }
        catch (JwtException e) {
            throw JsonWebTokenAuthenticator.needAuthentication(e.getMessage());
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Authentication error", e);
        }
    }

    private static AuthenticationException needAuthentication(String message) {
        return new AuthenticationException(message, "Bearer realm=\"Presto\", token_type=\"JWT\"");
    }

    private static LoadedKey loadKeyFile(File file) {
        if (!file.canRead()) {
            throw new SignatureException("Unknown signing key ID");
        }
        try {
            return new LoadedKey(PemReader.loadPublicKey((File)file));
        }
        catch (Exception exception) {
            try {
                String base64Key = Files.asCharSource((File)file, (Charset)StandardCharsets.US_ASCII).read();
                byte[] rawKey = Base64.getMimeDecoder().decode(base64Key.getBytes(StandardCharsets.US_ASCII));
                return new LoadedKey(rawKey);
            }
            catch (IOException iOException) {
                throw new SignatureException("Unknown signing key id");
            }
        }
    }

    private static class LoadedKey {
        private final Key publicKey;
        private final byte[] hmacKey;

        public LoadedKey(Key publicKey) {
            this.publicKey = Objects.requireNonNull(publicKey, "publicKey is null");
            this.hmacKey = null;
        }

        public LoadedKey(byte[] hmacKey) {
            this.hmacKey = Objects.requireNonNull(hmacKey, "hmacKey is null");
            this.publicKey = null;
        }

        public Key getKey(SignatureAlgorithm algorithm) {
            if (algorithm.isHmac()) {
                if (this.hmacKey == null) {
                    throw new UnsupportedJwtException(String.format("JWT is signed with %s, but no HMAC key is configured", algorithm));
                }
                return new SecretKeySpec(this.hmacKey, algorithm.getJcaName());
            }
            if (this.publicKey == null) {
                throw new UnsupportedJwtException(String.format("JWT is signed with %s, but no key is configured", algorithm));
            }
            return this.publicKey;
        }
    }

    private static class DynamicKeyLoader
    implements Function<JwsHeader<?>, Key> {
        private final String keyFile;
        private final ConcurrentMap<String, LoadedKey> keys = new ConcurrentHashMap<String, LoadedKey>();

        public DynamicKeyLoader(String keyFile) {
            Objects.requireNonNull(keyFile, "keyFile is null");
            Preconditions.checkArgument((boolean)keyFile.contains(JsonWebTokenAuthenticator.KEY_ID_VARIABLE));
            this.keyFile = keyFile;
        }

        @Override
        public Key apply(JwsHeader<?> header) {
            String keyId = DynamicKeyLoader.getKeyId(header);
            SignatureAlgorithm algorithm = SignatureAlgorithm.forName((String)header.getAlgorithm());
            return this.keys.computeIfAbsent(keyId, this::loadKey).getKey(algorithm);
        }

        private static String getKeyId(JwsHeader<?> header) {
            String keyId = header.getKeyId();
            if (keyId == null) {
                return JsonWebTokenAuthenticator.DEFAULT_KEY;
            }
            keyId = INVALID_KID_CHARS.replaceFrom((CharSequence)keyId, '_');
            return keyId;
        }

        private LoadedKey loadKey(String keyId) {
            return JsonWebTokenAuthenticator.loadKeyFile(new File(this.keyFile.replace(JsonWebTokenAuthenticator.KEY_ID_VARIABLE, keyId)));
        }
    }

    private static class StaticKeyLoader
    implements Function<JwsHeader<?>, Key> {
        private final LoadedKey key;

        public StaticKeyLoader(String keyFile) {
            Objects.requireNonNull(keyFile, "keyFile is null");
            Preconditions.checkArgument((!keyFile.contains(JsonWebTokenAuthenticator.KEY_ID_VARIABLE) ? 1 : 0) != 0);
            this.key = JsonWebTokenAuthenticator.loadKeyFile(new File(keyFile));
        }

        @Override
        public Key apply(JwsHeader<?> header) {
            SignatureAlgorithm algorithm = SignatureAlgorithm.forName((String)header.getAlgorithm());
            return this.key.getKey(algorithm);
        }
    }
}

