/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.jmx;

import com.google.common.base.MoreObjects;
import com.google.common.base.StandardSystemProperty;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class JavaVersion {
    private static final String VERSION_NUMBER = "(?<MAJOR>[1-9][0-9]*)(\\.(?<MINOR>(0|[1-9][0-9]*))(\\.(?:(0|[1-9][0-9]*)))?)*";
    private static final String PRE = "(?:-(?:[a-zA-Z0-9]+))?";
    private static final String BUILD = "(?:(?:\\+)(?:0|[1-9][0-9]*)?)?";
    private static final String OPT = "(?:-(?:[-a-zA-Z0-9.]+))?";
    private static final Pattern PATTERN = Pattern.compile("(?<MAJOR>[1-9][0-9]*)(\\.(?<MINOR>(0|[1-9][0-9]*))(\\.(?:(0|[1-9][0-9]*)))?)*(?:-(?:[a-zA-Z0-9]+))?(?:(?:\\+)(?:0|[1-9][0-9]*)?)?(?:-(?:[-a-zA-Z0-9.]+))?");
    private static final Pattern LEGACY_PATTERN = Pattern.compile("1\\.(?<MAJOR>[0-9]+)(\\.(?<MINOR>(0|[1-9][0-9]*)))?(_(?<UPDATE>[1-9][0-9]*))?(?:-[a-zA-Z0-9.]+)*");
    private final int major;
    private final int minor;
    private final OptionalInt update;

    public static JavaVersion current() {
        return JavaVersion.parse(StandardSystemProperty.JAVA_VERSION.value());
    }

    public static JavaVersion parse(String version) {
        Matcher matcher = LEGACY_PATTERN.matcher(version);
        if (matcher.matches()) {
            int major = Integer.parseInt(matcher.group("MAJOR"));
            int minor = Optional.ofNullable(matcher.group("MINOR")).map(Integer::parseInt).orElse(0);
            String update = matcher.group("UPDATE");
            if (update == null) {
                return new JavaVersion(major, minor);
            }
            return new JavaVersion(major, minor, OptionalInt.of(Integer.parseInt(update)));
        }
        matcher = PATTERN.matcher(version);
        if (matcher.matches()) {
            int major = Integer.parseInt(matcher.group("MAJOR"));
            int minor = Optional.ofNullable(matcher.group("MINOR")).map(Integer::parseInt).orElse(0);
            return new JavaVersion(major, minor);
        }
        throw new IllegalArgumentException(String.format("Cannot parse version %s", version));
    }

    public JavaVersion(int major, int minor, OptionalInt update) {
        this.major = major;
        this.minor = minor;
        this.update = update;
    }

    public JavaVersion(int major, int minor) {
        this(major, minor, OptionalInt.empty());
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public OptionalInt getUpdate() {
        return this.update;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaVersion that = (JavaVersion)o;
        return this.major == that.major && this.minor == that.minor && Objects.equals(this.update, that.update);
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.update);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("major", this.major).add("minor", this.minor).add("update", (Object)this.update).toString();
    }
}

