/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.aggregate.web.loader;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.fizzgate.aggregate.core.flow.Flow;
import com.fizzgate.aggregate.core.flow.FlowContext;
import com.fizzgate.aggregate.web.loader.AggregateResource;
import com.fizzgate.aggregate.web.loader.AppConfigProperties;
import com.fizzgate.aggregate.web.loader.ClientInputConfig;
import com.fizzgate.aggregate.web.loader.ConfigLoaderProperties;
import com.fizzgate.aggregate.web.loader.Input;
import com.fizzgate.aggregate.web.loader.Pipeline;
import com.fizzgate.util.ReactorUtils;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.ThreadContext;
import org.noear.snack.ONode;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.data.redis.core.ReactiveStringRedisTemplate;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ConfigLoader {
    private static final Logger \u00d400000 = LoggerFactory.getLogger(ConfigLoader.class);
    private static final String oO0000 = "/proxy";
    private static final String \u00d5O0000 = "/proxytest";
    private static final String float = "/_proxytest";
    private static final int \u00d500000 = "/_proxytest".length() + 1;
    private final ConfigurableApplicationContext public;
    private static final String \u00d2O0000 = "fizz_aggregate_config";
    private static Map<String, String> \u00f400000 = null;
    private static Map<String, String> \u00d4O0000 = null;
    private static Map<String, ConfigInfo> \u00f600000 = null;
    private static Map<String, String> \u00d200000 = null;
    private final ReactiveStringRedisTemplate \u00d600000;
    private final ConfigLoaderProperties void;
    private final AppConfigProperties Object;
    private String OO0000;
    private int \u00f500000;

    public ConfigLoader(ConfigurableApplicationContext configurableApplicationContext, ReactiveStringRedisTemplate reactiveStringRedisTemplate, ConfigLoaderProperties configLoaderProperties, AppConfigProperties appConfigProperties) {
        this.public = configurableApplicationContext;
        this.\u00d600000 = reactiveStringRedisTemplate;
        this.void = configLoaderProperties;
        this.Object = appConfigProperties;
    }

    public Input createInput(String string) throws IOException {
        ONode oNode = ONode.loadStr((String)string);
        Input input = new Input();
        input.setName(oNode.select("$.name").getString());
        ClientInputConfig clientInputConfig = new ClientInputConfig();
        clientInputConfig.setDataMapping((Map)oNode.select("$.dataMapping").toObject(Map.class));
        clientInputConfig.setHeaders((Map)oNode.select("$.headers").toObject(Map.class));
        clientInputConfig.setMethod(oNode.select("$.method").getString());
        clientInputConfig.setPath(oNode.select("$.path").getString());
        if (clientInputConfig.getPath().startsWith(float)) {
            clientInputConfig.setDebug(true);
        } else if (oNode.select("$.debug") != null) {
            clientInputConfig.setDebug(oNode.select("$.debug").getBoolean());
        }
        clientInputConfig.setLangDef((Map)oNode.select("$.langDef").toObject(Map.class));
        clientInputConfig.setBodyDef((Map)oNode.select("$.bodyDef").toObject(Map.class));
        clientInputConfig.setHeadersDef((Map)oNode.select("$.headersDef").toObject(Map.class));
        clientInputConfig.setParamsDef((Map)oNode.select("$.paramsDef").toObject(Map.class));
        clientInputConfig.setScriptValidate((Map)oNode.select("$.scriptValidate").toObject(Map.class));
        clientInputConfig.setValidateResponse((Map)oNode.select("$.validateResponse").toObject(Map.class));
        clientInputConfig.setContentType(oNode.select("$.contentType").getString());
        clientInputConfig.setXmlArrPaths(oNode.select("$.xmlArrPaths").getString());
        input.setConfig(clientInputConfig);
        return input;
    }

    public Pipeline createPipeline(String string) {
        Flow flow = Flow.build((String)string, (FlowContext)new FlowContext());
        Pipeline pipeline = new Pipeline();
        pipeline.setFlow(flow);
        return pipeline;
    }

    public List<ConfigInfo> getConfigInfo() {
        if (\u00f400000 == null) {
            try {
                this.init();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return new ArrayList<ConfigInfo>(\u00f600000.values());
    }

    public String getConfigStr(String string) {
        String string2;
        if (\u00f400000 == null) {
            try {
                this.init();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if ((string2 = \u00d200000.get(string)) == null) {
            return null;
        }
        String string3 = \u00f400000.get(string2);
        return string3 != null ? string3 : \u00d4O0000.get(string2);
    }

    public synchronized void init() throws Exception {
        this.refreshLocalCache();
    }

    public synchronized void refreshLocalCache() throws Exception {
        Object object;
        if (this.OO0000 == null) {
            object = this.public.getEnvironment().getProperty("gateway.prefix", oO0000);
            if (((String)object).endsWith("/")) {
                object = ((String)object).substring(0, ((String)object).length() - 1);
            }
            this.OO0000 = object;
            this.\u00f500000 = this.OO0000.length() + 1;
        }
        object = new ConcurrentHashMap(1024);
        ConcurrentHashMap<String, String> concurrentHashMap = new ConcurrentHashMap<String, String>(1024);
        ConcurrentHashMap<String, ConfigInfo> concurrentHashMap2 = new ConcurrentHashMap<String, ConfigInfo>(1024);
        ConcurrentHashMap<String, String> concurrentHashMap3 = new ConcurrentHashMap<String, String>(1024);
        if (this.void.getReadLocalConfigFlag().booleanValue()) {
            File[] fileArray;
            File file = new File("json");
            if (file.exists() && file.isDirectory() && (fileArray = file.listFiles()) != null && fileArray.length > 0) {
                for (File file2 : fileArray) {
                    if (!file2.exists()) {
                        throw new IOException("File not found");
                    }
                    String string = FileUtils.readFileToString((File)file2, (Charset)StandardCharsets.UTF_8);
                    this.o00000(string, (Map<String, String>)object, concurrentHashMap, concurrentHashMap2, concurrentHashMap3);
                }
            }
        } else {
            Throwable[] throwableArray = new Throwable[1];
            Throwable throwable2 = (Throwable)Mono.just((Object)Objects.requireNonNull(this.\u00d600000.opsForHash().entries((Object)\u00d2O0000).defaultIfEmpty(new AbstractMap.SimpleEntry<Object, Object>(ReactorUtils.OBJ, ReactorUtils.OBJ)).onErrorStop().doOnError(throwable -> \u00d400000.info(null, throwable)).concatMap(arg_0 -> this.o00000((Map)object, concurrentHashMap, concurrentHashMap2, concurrentHashMap3, throwableArray, arg_0)).blockLast())).flatMap(entry -> {
                if (throwableArray[0] != null) {
                    return Mono.error((Throwable)throwableArray[0]);
                }
                return Mono.just((Object)ReactorUtils.EMPTY_THROWABLE);
            }).block();
            if (throwable2 != ReactorUtils.EMPTY_THROWABLE) {
                assert (throwable2 != null);
                throw new RuntimeException(throwable2);
            }
        }
        \u00f400000 = object;
        \u00d4O0000 = concurrentHashMap;
        \u00f600000 = concurrentHashMap2;
        \u00d200000 = concurrentHashMap3;
    }

    public synchronized void addConfig(String string) {
        if (\u00f400000 == null) {
            try {
                this.init();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.o00000(string, \u00f400000, \u00d4O0000, \u00f600000, \u00d200000);
    }

    private void o00000(String string, Map<String, String> map, Map<String, String> map2, Map<String, ConfigInfo> map3, Map<String, String> map4) {
        ONode oNode = ONode.loadStr((String)string);
        boolean bl = false;
        boolean bl2 = !oNode.contains("aggrVersion");
        String string2 = oNode.select("$.method").getString();
        String string3 = oNode.select("$.path").getString();
        if (string3.startsWith(\u00d5O0000)) {
            string3 = string3.replaceFirst(\u00d5O0000, float);
            bl = true;
        } else if (string3.startsWith(oO0000)) {
            string3 = string3.replace(oO0000, "");
            bl = true;
        }
        if (!string3.startsWith(float)) {
            string3 = String.format("%s%s", this.OO0000, string3);
            bl = true;
        }
        String string4 = string2.toUpperCase() + ":" + string3;
        String string5 = oNode.select("$.id").getString();
        String string6 = oNode.select("$.name").getString();
        long l = oNode.select("$.version").getLong();
        if (bl) {
            oNode.set("path", (Object)string3);
            string = oNode.toJson();
        }
        \u00d400000.debug("add aggregation config, key={} config={}", (Object)string4, (Object)string);
        if (StringUtils.hasText((String)string5)) {
            String string7 = map4.get(string5);
            if (StringUtils.hasText((String)string7)) {
                map.remove(string7);
                map2.remove(string7);
                map3.remove(string7);
            }
            map4.put(string5, string4);
        }
        if (bl2) {
            map2.put(string4, string);
        } else {
            map.put(string4, string);
        }
        map3.put(string4, this.o00000(string5, string6, string2, string3, l));
    }

    public synchronized void deleteConfig(String string) {
        if (CollectionUtils.isEmpty(\u00d200000)) {
            return;
        }
        JSONArray jSONArray = JSON.parseArray((String)string);
        jSONArray.forEach(object -> {
            String string = (String)object;
            String string2 = \u00d200000.get(string);
            if (StringUtils.hasText((String)string2)) {
                \u00d400000.debug("delete aggregation config: {}", (Object)string2);
                \u00f400000.remove(string2);
                \u00d4O0000.remove(string2);
                \u00f600000.remove(string2);
                \u00d200000.remove(string);
            }
        });
    }

    public AggregateResource matchAggregateResource(String string, String string2) {
        String string3;
        String string4;
        if (\u00f400000 == null) {
            try {
                this.init();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }
        if (\u00f400000.containsKey(string4 = string.toUpperCase() + ":" + string2) && \u00f400000.get(string4) != null) {
            Pipeline pipeline;
            Input input;
            string3 = \u00f400000.get(string4);
            try {
                input = this.createInput(string3);
                pipeline = this.createPipeline(string3);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return null;
            }
            if (pipeline != null && input != null) {
                return AggregateResource.build(pipeline, input);
            }
        }
        if (\u00d4O0000.containsKey(string4) && (string3 = \u00d4O0000.get(string4)) != null) {
            return AggregateResource.buildLegacy(string3, this.Object.getEnv());
        }
        return null;
    }

    private ConfigInfo o00000(String string, String string2, String string3, String string4, long l) {
        String string5 = this.o00000(string4);
        ConfigInfo configInfo = new ConfigInfo();
        configInfo.setConfigId(string);
        configInfo.setConfigName(string2);
        configInfo.setServiceName(string5);
        configInfo.setMethod(string3);
        configInfo.setPath(string4);
        configInfo.setVersion(l == 0L ? null : Long.valueOf(l));
        return configInfo;
    }

    private String o00000(String string) {
        if (string != null) {
            int n;
            if (string.startsWith(float)) {
                int n2 = string.indexOf(47, \u00d500000);
                if (n2 > \u00d500000) {
                    return string.substring(\u00d500000, n2);
                }
            } else if (string.startsWith(this.OO0000) && (n = string.indexOf(47, this.\u00f500000)) > this.\u00f500000) {
                return string.substring(this.\u00f500000, n);
            }
        }
        return null;
    }

    private /* synthetic */ Publisher o00000(Map map, Map map2, Map map3, Map map4, Throwable[] throwableArray, Map.Entry entry) {
        Object k = entry.getKey();
        if (k == ReactorUtils.OBJ) {
            return Flux.just((Object)entry);
        }
        String string = (String)entry.getValue();
        ThreadContext.put((String)"traceId", (String)k.toString());
        \u00d400000.info("aggregate config: " + k.toString() + ':' + string);
        try {
            this.o00000(string, map, map2, map3, map4);
            return Flux.just((Object)entry);
        }
        catch (Throwable throwable) {
            throwableArray[0] = throwable;
            \u00d400000.info(string, throwable);
            return Flux.error((Throwable)throwable);
        }
    }

    public static class ConfigInfo
    implements Serializable {
        private static final long \u00d800000 = 1L;
        private String \u00d600000;
        private String String;
        private String \u00d200000;
        private String \u00d500000;
        private String \u00d300000;
        private Long o00000;

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            ConfigInfo configInfo = (ConfigInfo)object;
            return Objects.equals(this.\u00d600000, configInfo.\u00d600000) && Objects.equals(this.String, configInfo.String) && Objects.equals(this.\u00d200000, configInfo.\u00d200000) && Objects.equals(this.\u00d500000, configInfo.\u00d500000) && Objects.equals(this.\u00d300000, configInfo.\u00d300000) && Objects.equals(this.o00000, configInfo.o00000);
        }

        public int hashCode() {
            return Objects.hash(this.\u00d600000, this.String, this.\u00d200000, this.\u00d500000, this.\u00d300000, this.o00000);
        }

        public String getConfigId() {
            return this.\u00d600000;
        }

        public String getConfigName() {
            return this.String;
        }

        public String getServiceName() {
            return this.\u00d200000;
        }

        public String getMethod() {
            return this.\u00d500000;
        }

        public String getPath() {
            return this.\u00d300000;
        }

        public Long getVersion() {
            return this.o00000;
        }

        public void setConfigId(String string) {
            this.\u00d600000 = string;
        }

        public void setConfigName(String string) {
            this.String = string;
        }

        public void setServiceName(String string) {
            this.\u00d200000 = string;
        }

        public void setMethod(String string) {
            this.\u00d500000 = string;
        }

        public void setPath(String string) {
            this.\u00d300000 = string;
        }

        public void setVersion(Long l) {
            this.o00000 = l;
        }
    }
}

