/*
 * Decompiled with CFR 0.152.
 */
package com.gettyio.core.buffer;

import com.gettyio.core.buffer.AbstractBufferWriter;
import com.gettyio.core.buffer.ChunkPool;
import com.gettyio.core.function.Function;
import com.gettyio.core.logging.InternalLogger;
import com.gettyio.core.logging.InternalLoggerFactory;
import com.gettyio.core.util.LinkedNonReadBlockQueue;
import com.gettyio.core.util.LinkedQueue;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeoutException;

public final class AioBufferWriter
extends AbstractBufferWriter<ByteBuffer> {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(AioBufferWriter.class);
    private final Function<AioBufferWriter, Void> function;
    private final LinkedQueue<ByteBuffer> queue;

    public AioBufferWriter(ChunkPool chunkPool, Function<AioBufferWriter, Void> flushFunction, int bufferWriterQueueSize, int chunkPoolBlockTime) {
        this.chunkPool = chunkPool;
        this.chunkPoolBlockTime = chunkPoolBlockTime;
        this.function = flushFunction;
        this.queue = new LinkedNonReadBlockQueue<ByteBuffer>(bufferWriterQueueSize);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            IOException ioException = new IOException("OutputStream has closed");
            LOGGER.error(ioException.getMessage(), ioException);
            throw ioException;
        }
        if (len <= 0 || b.length == 0) {
            return;
        }
        try {
            ByteBuffer chunkPage = this.chunkPool.allocate(len - off, this.chunkPoolBlockTime);
            int minSize = chunkPage.remaining();
            if (minSize == 0) {
                this.chunkPool.deallocate(chunkPage);
                throw new RuntimeException("ByteBuffer remaining is 0");
            }
            chunkPage.put(b, off, b.length);
            chunkPage.flip();
            if (this.queue.getCount() < this.queue.getCapacity()) {
                this.queue.put(chunkPage);
            }
        }
        catch (InterruptedException e) {
            LOGGER.error(e);
        }
        catch (TimeoutException e) {
            LOGGER.error(e);
        }
    }

    @Override
    public void writeAndFlush(byte[] b) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        this.write(b, 0, b.length);
        this.flush();
    }

    @Override
    public void flush() throws IOException {
        if (this.closed) {
            throw new IOException("outputStream was closed");
        }
        if (this.queue.getCount() > 0) {
            this.function.apply(this);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            throw new IOException("outputStream was closed");
        }
        while (this.queue.getCount() > 0) {
            this.flush();
        }
        this.closed = true;
        if (this.chunkPool != null) {
            this.chunkPool.clear();
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public ByteBuffer poll() {
        try {
            return this.queue.poll();
        }
        catch (InterruptedException e) {
            LOGGER.error(e.getMessage(), e);
            return null;
        }
    }
}

