/*
 * Decompiled with CFR 0.152.
 */
package com.gettyio.core.channel.starter;

import com.gettyio.core.buffer.ChunkPool;
import com.gettyio.core.channel.NioChannel;
import com.gettyio.core.channel.SocketChannel;
import com.gettyio.core.channel.SocketMode;
import com.gettyio.core.channel.UdpChannel;
import com.gettyio.core.channel.config.ClientConfig;
import com.gettyio.core.channel.loop.NioEventLoop;
import com.gettyio.core.channel.starter.ConnectHandler;
import com.gettyio.core.channel.starter.NioStarter;
import com.gettyio.core.handler.ssl.sslfacade.IHandshakeCompletedListener;
import com.gettyio.core.logging.InternalLogger;
import com.gettyio.core.logging.InternalLoggerFactory;
import com.gettyio.core.pipeline.ChannelPipeline;
import com.gettyio.core.util.ThreadPool;
import com.gettyio.core.util.Time;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.Map;

public class NioClientStarter
extends NioStarter {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(NioClientStarter.class);
    private ClientConfig clientConfig = new ClientConfig();
    private SocketChannel nioChannel;
    private NioEventLoop nioEventLoop;
    Selector selector;

    public NioClientStarter(String host, int port) {
        this.clientConfig.setHost(host);
        this.clientConfig.setPort(port);
    }

    public NioClientStarter(ClientConfig clientConfig) {
        if (null == clientConfig.getHost() || "".equals(clientConfig.getHost())) {
            throw new NullPointerException("The connection host is null.");
        }
        if (0 == clientConfig.getPort()) {
            throw new NullPointerException("The connection port is null.");
        }
        this.clientConfig = clientConfig;
    }

    public NioClientStarter channelInitializer(ChannelPipeline channelPipeline) {
        this.channelPipeline = channelPipeline;
        return this;
    }

    public NioClientStarter socketMode(SocketMode socketMode) {
        this.socketMode = socketMode;
        return this;
    }

    public final void start() throws Exception {
        try {
            this.start0(null);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
            throw new Exception(e);
        }
    }

    public final void start(ConnectHandler connectHandler) {
        try {
            this.start0(connectHandler);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
            connectHandler.onFailed(e);
            return;
        }
    }

    private void start0(ConnectHandler connectHandler) throws Exception {
        if (this.channelPipeline == null) {
            throw new NullPointerException("The ChannelPipeline is null.");
        }
        this.workerThreadPool = new ThreadPool(0, 1);
        this.chunkPool = new ChunkPool(this.clientConfig.getClientChunkSize().intValue(), new Time(), this.clientConfig.isDirect());
        this.nioEventLoop = new NioEventLoop(this.clientConfig, this.chunkPool);
        this.nioEventLoop.run();
        if (this.socketMode == SocketMode.TCP) {
            this.startTcp(connectHandler);
        } else {
            this.startUdp(connectHandler);
        }
    }

    private void startTcp(final ConnectHandler connectHandler) throws Exception {
        java.nio.channels.SocketChannel socketChannel = java.nio.channels.SocketChannel.open();
        if (this.clientConfig.getSocketOptions() != null) {
            for (Map.Entry<SocketOption<Object>, Object> entry : this.clientConfig.getSocketOptions().entrySet()) {
                socketChannel.setOption((SocketOption)entry.getKey(), entry.getValue());
            }
        }
        socketChannel.configureBlocking(false);
        socketChannel.connect(new InetSocketAddress(this.clientConfig.getHost(), this.clientConfig.getPort()));
        this.selector = Selector.open();
        socketChannel.register(this.selector, 8);
        while (this.selector.select() > 0) {
            Iterator<SelectionKey> it = this.selector.selectedKeys().iterator();
            while (it.hasNext()) {
                java.nio.channels.SocketChannel channel;
                SelectionKey sk = it.next();
                if (!sk.isConnectable() || !(channel = (java.nio.channels.SocketChannel)sk.channel()).isConnectionPending()) continue;
                channel.finishConnect();
                try {
                    this.nioChannel = new NioChannel(this.clientConfig, socketChannel, this.nioEventLoop, this.channelPipeline);
                    if (null != connectHandler) {
                        if (null != this.nioChannel.getSslHandler()) {
                            this.nioChannel.setSslHandshakeCompletedListener(new IHandshakeCompletedListener(){

                                @Override
                                public void onComplete() {
                                    LOGGER.info("Ssl Handshake Completed");
                                    connectHandler.onCompleted(NioClientStarter.this.nioChannel);
                                }
                            });
                        } else {
                            connectHandler.onCompleted(this.nioChannel);
                        }
                    }
                    ((NioChannel)this.nioChannel).register();
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), e);
                    if (this.nioChannel != null) {
                        this.closeChannel(socketChannel);
                    }
                    if (null == connectHandler) continue;
                    connectHandler.onFailed(e);
                }
            }
            it.remove();
        }
    }

    private final void startUdp(ConnectHandler connectHandler) throws IOException {
        DatagramChannel datagramChannel = DatagramChannel.open();
        datagramChannel.configureBlocking(false);
        Selector selector = Selector.open();
        datagramChannel.register(selector, 1);
        this.nioChannel = new UdpChannel(datagramChannel, selector, this.clientConfig, this.chunkPool, this.channelPipeline, 3);
        this.nioChannel.starRead();
        if (null != connectHandler) {
            connectHandler.onCompleted(this.nioChannel);
        }
    }

    public final void shutdown() {
        this.showdown0(false);
    }

    private void showdown0(boolean flag) {
        if (this.nioChannel != null) {
            this.nioChannel.close();
            this.nioChannel = null;
        }
        if (this.selector != null && this.selector.isOpen()) {
            try {
                this.selector.close();
            }
            catch (IOException e) {
                LOGGER.error(e);
            }
        }
        if (this.nioEventLoop != null) {
            this.nioEventLoop.shutdown();
        }
    }

    private void closeChannel(java.nio.channels.SocketChannel channel) {
        try {
            channel.shutdownInput();
        }
        catch (IOException e) {
            LOGGER.debug(e.getMessage(), e);
        }
        try {
            channel.shutdownOutput();
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), e);
        }
        try {
            channel.close();
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), e);
        }
    }

    @Deprecated
    public SocketChannel getNioChannel() {
        if (this.nioChannel != null) {
            if (this.nioChannel.getSslHandler() != null && this.socketMode != SocketMode.UDP) {
                if (this.nioChannel.getSslHandler().getSslService().getSsl().isHandshakeCompleted()) {
                    return this.nioChannel;
                }
                this.nioChannel.close();
                throw new RuntimeException("The SSL handshcke is not yet complete");
            }
            return this.nioChannel;
        }
        throw new NullPointerException("AioChannel was null");
    }
}

