/*
 * Decompiled with CFR 0.152.
 */
package com.gettyio.core.handler.codec.string;

import com.gettyio.core.channel.SocketChannel;
import com.gettyio.core.pipeline.in.ChannelInboundHandlerAdapter;
import com.gettyio.core.util.LinkedNonReadBlockQueue;

public class FixedLengthFrameDecoder
extends ChannelInboundHandlerAdapter {
    private int frameLength;

    public FixedLengthFrameDecoder(int frameLength) {
        if (frameLength <= 0) {
            throw new IllegalArgumentException("frameLength must be a positive integer: " + frameLength);
        }
        this.frameLength = frameLength;
    }

    @Override
    public void decode(SocketChannel socketChannel, Object obj, LinkedNonReadBlockQueue<Object> out) throws Exception {
        byte[] bytes = (byte[])obj;
        for (int index = 0; index < bytes.length; index += this.frameLength) {
            byte[] byte2;
            if (bytes.length - index > this.frameLength) {
                byte2 = new byte[this.frameLength];
                System.arraycopy(bytes, index, byte2, 0, this.frameLength);
            } else {
                byte2 = new byte[bytes.length - index];
                System.arraycopy(bytes, index, byte2, 0, bytes.length - index);
            }
            super.decode(socketChannel, obj, out);
        }
    }
}

