/*
 * Decompiled with CFR 0.152.
 */
package com.gettyio.core.handler.ssl.sslfacade;

import java.nio.ByteBuffer;

class AppendableBuffer {
    private ByteBuffer b;

    AppendableBuffer() {
    }

    public ByteBuffer append(ByteBuffer data) {
        ByteBuffer nb = ByteBuffer.allocate(this.calculateSize(data));
        if (this.notNull()) {
            nb.put(this.b);
            this.clear();
        }
        nb.put(data);
        return nb;
    }

    public void set(ByteBuffer data) {
        if (data.hasRemaining()) {
            this.b = ByteBuffer.allocate(data.remaining());
            this.b.put(data);
            this.b.rewind();
        }
    }

    public void clear() {
        this.b = null;
    }

    private int calculateSize(ByteBuffer data) {
        int result = data.limit();
        if (this.notNull()) {
            result += this.b.capacity();
        }
        return result;
    }

    private boolean notNull() {
        return this.b != null;
    }

    public boolean hasRemaining() {
        if (this.notNull()) {
            return this.b.hasRemaining();
        }
        return false;
    }

    public ByteBuffer get() {
        return this.b;
    }
}

