/*
 * Decompiled with CFR 0.152.
 */
package com.gettyio.core.handler.ssl.sslfacade;

import com.gettyio.core.handler.ssl.sslfacade.IHandshakeCompletedListener;
import com.gettyio.core.handler.ssl.sslfacade.ISessionClosedListener;
import com.gettyio.core.handler.ssl.sslfacade.ITaskHandler;
import com.gettyio.core.handler.ssl.sslfacade.SSLLog;
import com.gettyio.core.handler.ssl.sslfacade.Tasks;
import com.gettyio.core.handler.ssl.sslfacade.Worker;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;

class Handshaker {
    private static final String TAG = "Handshaker";
    private final ITaskHandler _taskHandler;
    private final Worker _worker;
    private boolean _finished;
    private IHandshakeCompletedListener _hscl;
    private ISessionClosedListener _sessionClosedListener;
    private boolean _client;

    public Handshaker(boolean client, Worker worker, ITaskHandler taskHandler) {
        this._worker = worker;
        this._taskHandler = taskHandler;
        this._finished = false;
        this._client = client;
    }

    private void debug(String msg, String ... args) {
        SSLLog.debug(TAG, msg, args);
    }

    void begin() throws SSLException {
        this._worker.beginHandshake();
        this.shakehands();
    }

    void carryOn() throws SSLException {
        this.debug("carryOn", new String[0]);
        this.shakehands();
    }

    void handleUnwrapResult(SSLEngineResult result) throws SSLException {
        this.debug("handleUnwrapResult", new String[0]);
        if (result.getHandshakeStatus().equals((Object)SSLEngineResult.HandshakeStatus.FINISHED)) {
            this.handshakeFinished();
        } else {
            this.shakehands();
        }
    }

    void addCompletedListener(IHandshakeCompletedListener hscl) {
        this._hscl = hscl;
    }

    void removeCompletedListener(IHandshakeCompletedListener hscl) {
        this._hscl = hscl;
    }

    boolean isFinished() {
        return this._finished;
    }

    private void shakehands() throws SSLException {
        this.debug("shakehands : " + (Object)((Object)this._worker.getHandshakeStatus()), new String[0]);
        switch (this._worker.getHandshakeStatus()) {
            case NOT_HANDSHAKING: {
                break;
            }
            case FINISHED: {
                this.handshakeFinished();
                break;
            }
            case NEED_TASK: {
                this._taskHandler.process(new Tasks(this._worker, this));
                break;
            }
            case NEED_WRAP: {
                SSLEngineResult w_result = this._worker.wrap(null);
                this.debug("Wrap result " + w_result, new String[0]);
                if (w_result.getStatus().equals((Object)SSLEngineResult.Status.CLOSED) && null != this._sessionClosedListener) {
                    this._sessionClosedListener.onSessionClosed();
                }
                if (w_result.getHandshakeStatus().equals((Object)SSLEngineResult.HandshakeStatus.FINISHED)) {
                    this.handshakeFinished();
                    break;
                }
                this.shakehands();
                break;
            }
            case NEED_UNWRAP: {
                if (this._worker.pendingUnwrap()) {
                    SSLEngineResult u_result = this._worker.unwrap(null);
                    this.debug("Unwrap result " + u_result, new String[0]);
                    if (u_result.getHandshakeStatus().equals((Object)SSLEngineResult.HandshakeStatus.FINISHED)) {
                        this.handshakeFinished();
                    }
                    if (!u_result.getStatus().equals((Object)SSLEngineResult.Status.OK)) break;
                    this.shakehands();
                    break;
                }
                this.debug("No pending data to unwrap", new String[0]);
            }
        }
    }

    private void handshakeFinished() {
        this._finished = true;
        this._hscl.onComplete();
    }
}

