/*
 * Decompiled with CFR 0.152.
 */
package com.gettyio.core.util;

import com.gettyio.core.util.LinkedQueue;
import java.lang.reflect.Array;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class LinkedBlockQueue<T>
implements LinkedQueue<T> {
    T[] items;
    int capacity;
    private int count;
    private int putIndex = 0;
    private int removeIndex = 0;
    ReentrantLock lock = new ReentrantLock(true);
    Condition notFull = this.lock.newCondition();
    Condition notEmpty = this.lock.newCondition();

    public LinkedBlockQueue() {
        this(1024);
    }

    public LinkedBlockQueue(int capacity) {
        this.items = new Object[capacity];
        this.capacity = capacity;
    }

    @Override
    public <T> T[] getArray(Class<T> componentType, int length) {
        return (Object[])Array.newInstance(componentType, length);
    }

    @Override
    public T put(T t) throws InterruptedException {
        this.checkNull(t);
        this.lock.lock();
        try {
            while (this.items.length == this.count) {
                this.notFull.await();
            }
            this.items[this.putIndex] = t;
            if (++this.putIndex == this.items.length) {
                this.putIndex = 0;
            }
            ++this.count;
            this.notEmpty.signal();
        }
        finally {
            this.lock.unlock();
        }
        return t;
    }

    @Override
    public T poll() throws InterruptedException {
        T t;
        this.lock.lock();
        try {
            while (this.count == 0) {
                this.notEmpty.await();
            }
            t = this.items[this.removeIndex];
            this.items[this.removeIndex] = null;
            if (++this.removeIndex == this.items.length) {
                this.removeIndex = 0;
            }
            --this.count;
            this.notFull.signal();
        }
        finally {
            this.lock.unlock();
        }
        return t;
    }

    private void checkNull(T t) {
        if (t == null) {
            throw new NullPointerException();
        }
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public int getCount() {
        return this.count;
    }
}

