/*
 * Decompiled with CFR 0.152.
 */
package com.gettyio.core.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NetWorkUtil {
    public static boolean ipValid(String ip) {
        String regex0 = "(2[0-4]\\d)|(25[0-5])";
        String regex1 = "1\\d{2}";
        String regex2 = "[1-9]\\d";
        String regex3 = "\\d";
        String regex = "(" + regex0 + ")|(" + regex1 + ")|(" + regex2 + ")|(" + regex3 + ")";
        regex = "(" + regex + ").(" + regex + ").(" + regex + ").(" + regex + ")";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(ip);
        return m.matches();
    }

    public static String getLocalIP() {
        String localIP = "127.0.0.1";
        try {
            Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
            while (netInterfaces.hasMoreElements()) {
                NetworkInterface ni = netInterfaces.nextElement();
                InetAddress ip = ni.getInetAddresses().nextElement();
                if (ip.isLoopbackAddress() || ip.getHostAddress().indexOf(":") != -1) continue;
                localIP = ip.getHostAddress();
                break;
            }
        }
        catch (Exception e) {
            try {
                localIP = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e1) {
                e1.printStackTrace();
            }
        }
        return localIP;
    }

    public static long ipToLong(String strIp) {
        String[] ip = strIp.split("\\.");
        return (Long.parseLong(ip[0]) << 24) + (Long.parseLong(ip[1]) << 16) + (Long.parseLong(ip[2]) << 8) + Long.parseLong(ip[3]);
    }

    public static String longToIP(long longIp) {
        StringBuffer sb = new StringBuffer("");
        sb.append(String.valueOf(longIp >>> 24));
        sb.append(".");
        sb.append(String.valueOf((longIp & 0xFFFFFFL) >>> 16));
        sb.append(".");
        sb.append(String.valueOf((longIp & 0xFFFFL) >>> 8));
        sb.append(".");
        sb.append(String.valueOf(longIp & 0xFFL));
        return sb.toString();
    }

    public static String getLocalMACAddress() throws Exception {
        InetAddress ia = InetAddress.getLocalHost();
        byte[] mac = NetworkInterface.getByInetAddress(ia).getHardwareAddress();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < mac.length; ++i) {
            String s;
            if (i != 0) {
                sb.append("-");
            }
            sb.append((s = Integer.toHexString(mac[i] & 0xFF)).length() == 1 ? 0 + s : s);
        }
        return sb.toString().toUpperCase();
    }

    public static String getMACAddress(InetAddress ia) throws Exception {
        byte[] mac = NetworkInterface.getByInetAddress(ia).getHardwareAddress();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < mac.length; ++i) {
            String s;
            if (i != 0) {
                sb.append("-");
            }
            sb.append((s = Integer.toHexString(mac[i] & 0xFF)).length() == 1 ? 0 + s : s);
        }
        return sb.toString().toUpperCase();
    }

    public static boolean isInRange(String ip, String cidr) {
        String cidrIp;
        String[] cidrIps;
        int cidrIpAddr;
        int type;
        int mask;
        String[] ips = ip.split("\\.");
        int ipAddr = Integer.parseInt(ips[0]) << 24 | Integer.parseInt(ips[1]) << 16 | Integer.parseInt(ips[2]) << 8 | Integer.parseInt(ips[3]);
        return (ipAddr & (mask = -1 << 32 - (type = Integer.parseInt(cidr.replaceAll(".*/", ""))))) == ((cidrIpAddr = Integer.parseInt((cidrIps = (cidrIp = cidr.replaceAll("/.*", "")).split("\\."))[0]) << 24 | Integer.parseInt(cidrIps[1]) << 16 | Integer.parseInt(cidrIps[2]) << 8 | Integer.parseInt(cidrIps[3])) & mask);
    }
}

