/*
 * Decompiled with CFR 0.152.
 */
package com.gettyio.core.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Collection;

public final class ObjectUtil {
    private ObjectUtil() {
    }

    public static <T> T checkNotNull(T arg, String text) {
        if (arg == null) {
            throw new NullPointerException(text);
        }
        return arg;
    }

    public static int checkPositive(int i, String name) {
        if (i <= 0) {
            throw new IllegalArgumentException(name + ": " + i + " (expected: > 0)");
        }
        return i;
    }

    public static long checkPositive(long i, String name) {
        if (i <= 0L) {
            throw new IllegalArgumentException(name + ": " + i + " (expected: > 0)");
        }
        return i;
    }

    public static int checkPositiveOrZero(int i, String name) {
        if (i < 0) {
            throw new IllegalArgumentException(name + ": " + i + " (expected: >= 0)");
        }
        return i;
    }

    public static long checkPositiveOrZero(long i, String name) {
        if (i < 0L) {
            throw new IllegalArgumentException(name + ": " + i + " (expected: >= 0)");
        }
        return i;
    }

    public static <T> T[] checkNonEmpty(T[] array, String name) {
        ObjectUtil.checkNotNull(array, name);
        ObjectUtil.checkPositive(array.length, name + ".length");
        return array;
    }

    public static <T extends Collection<?>> T checkNonEmpty(T collection, String name) {
        ObjectUtil.checkNotNull(collection, name);
        ObjectUtil.checkPositive(collection.size(), name + ".size");
        return collection;
    }

    public static int intValue(Integer wrapper, int defaultValue) {
        return wrapper != null ? wrapper : defaultValue;
    }

    public static long longValue(Long wrapper, long defaultValue) {
        return wrapper != null ? wrapper : defaultValue;
    }

    public static int toInt(byte ... b) {
        return (int)ObjectUtil.toLong(b);
    }

    public static long toLong(byte ... b) {
        int mask = 255;
        int temp = 0;
        long res = 0L;
        int byteslen = b.length;
        if (byteslen > 8) {
            return 0L;
        }
        for (int i = 0; i < byteslen; ++i) {
            res <<= 8;
            temp = b[i] & mask;
            res |= (long)temp;
        }
        return res;
    }

    private static byte[] numberToByte(long l, int length) {
        byte[] bts = new byte[length];
        for (int i = 0; i < length; ++i) {
            bts[i] = (byte)(l >> (length - i - 1) * 8);
        }
        return bts;
    }

    public static byte[] shortToByte(int i) {
        return ObjectUtil.numberToByte(i, 2);
    }

    public static byte[] longToByte(long i) {
        return ObjectUtil.numberToByte(i, 8);
    }

    public static byte[] ObjToByteArray(Object obj) {
        byte[] bytes = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(obj);
            oos.flush();
            bytes = bos.toByteArray();
            oos.close();
            bos.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return bytes;
    }
}

