/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.ueditor.upload;

import com.baidu.ueditor.PathFormat;
import com.baidu.ueditor.define.BaseState;
import com.baidu.ueditor.define.FileType;
import com.baidu.ueditor.define.State;
import com.baidu.ueditor.upload.IStorageManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartRequest;

public class BinaryUploader {
    private IStorageManager storage;

    public BinaryUploader(IStorageManager storage) {
        this.storage = storage;
    }

    public State save(HttpServletRequest request, Map<String, Object> conf) {
        if (request instanceof MultipartRequest) {
            return this.doSave((MultipartRequest)request, conf);
        }
        return this.doSave(request, conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected State doSave(MultipartRequest request, Map<String, Object> conf) {
        State state;
        Map map = request.getFileMap();
        MultipartFile file = null;
        for (MultipartFile temp : map.values()) {
            if (temp.isEmpty()) continue;
            file = temp;
            break;
        }
        if (file == null) {
            return new BaseState(false, 7);
        }
        long maxSize = (Long)conf.get("maxSize");
        long fileSize = file.getSize();
        if (fileSize > maxSize) {
            return new BaseState(false, 1);
        }
        String savePath = (String)conf.get("savePath");
        String originFileName = file.getOriginalFilename();
        String suffix = FileType.getSuffixByFilename(originFileName);
        originFileName = originFileName.substring(0, originFileName.length() - suffix.length());
        savePath = savePath + suffix;
        if (!BinaryUploader.validType(suffix, (String[])conf.get("allowFiles"))) {
            return new BaseState(false, 8);
        }
        savePath = PathFormat.parse(savePath, originFileName);
        String rootPath = (String)conf.get("rootPath");
        InputStream is = file.getInputStream();
        try {
            State storageState = this.storage.saveFileByInputStream(is, fileSize, rootPath, savePath);
            if (storageState.isSuccess()) {
                storageState.putInfo("type", suffix);
                storageState.putInfo("original", originFileName + suffix);
            }
            state = storageState;
        }
        catch (Throwable throwable) {
            try {
                is.close();
                throw throwable;
            }
            catch (IOException e) {
                return new BaseState(false, 4);
            }
        }
        is.close();
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected State doSave(HttpServletRequest request, Map<String, Object> conf) {
        State state;
        boolean isAjaxUpload;
        FileItem fileItem = null;
        boolean bl = isAjaxUpload = request.getHeader("X_Requested_With") != null;
        if (!ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            return new BaseState(false, 5);
        }
        long maxSize = (Long)conf.get("maxSize");
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());
        upload.setFileSizeMax(maxSize);
        if (isAjaxUpload) {
            upload.setHeaderEncoding("UTF-8");
        }
        List fileItems = upload.parseRequest(request);
        Iterator iterator = fileItems.iterator();
        while (iterator.hasNext() && (fileItem = (FileItem)iterator.next()).isFormField()) {
            fileItem = null;
        }
        if (fileItem == null) {
            return new BaseState(false, 7);
        }
        long fileSize = fileItem.getSize();
        if (fileSize > maxSize) {
            return new BaseState(false, 1);
        }
        String savePath = (String)conf.get("savePath");
        String originFileName = fileItem.getName();
        String suffix = FileType.getSuffixByFilename(originFileName);
        originFileName = originFileName.substring(0, originFileName.length() - suffix.length());
        savePath = savePath + suffix;
        if (!BinaryUploader.validType(suffix, (String[])conf.get("allowFiles"))) {
            return new BaseState(false, 8);
        }
        savePath = PathFormat.parse(savePath, originFileName);
        String rootPath = (String)conf.get("rootPath");
        InputStream is = fileItem.getInputStream();
        try {
            State storageState = this.storage.saveFileByInputStream(is, fileSize, rootPath, savePath);
            if (storageState.isSuccess()) {
                storageState.putInfo("type", suffix);
                storageState.putInfo("original", originFileName + suffix);
            }
            state = storageState;
        }
        catch (Throwable throwable) {
            try {
                is.close();
                throw throwable;
            }
            catch (FileUploadBase.FileSizeLimitExceededException e) {
                return new BaseState(false, 1);
            }
            catch (FileUploadException e) {
                return new BaseState(false, 6);
            }
            catch (IOException e) {
                return new BaseState(false, 4);
            }
        }
        is.close();
        return state;
    }

    private static boolean validType(String type, String[] allowTypes) {
        List<String> list = Arrays.asList(allowTypes);
        return list.contains(type);
    }
}

