/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.ueditor.hunter;

import com.baidu.ueditor.PathFormat;
import com.baidu.ueditor.define.BaseState;
import com.baidu.ueditor.define.MIMEType;
import com.baidu.ueditor.define.MultiState;
import com.baidu.ueditor.define.State;
import com.baidu.ueditor.upload.IStorageManager;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class ImageHunter {
    private String filename = null;
    private String savePath = null;
    private String rootPath = null;
    private List<String> allowTypes = null;
    private long maxSize = -1L;
    private List<String> filters = null;
    private IStorageManager storage;

    public ImageHunter(IStorageManager storage, Map<String, Object> conf) {
        this.storage = storage;
        this.filename = (String)conf.get("filename");
        this.savePath = (String)conf.get("savePath");
        this.rootPath = (String)conf.get("rootPath");
        this.maxSize = (Long)conf.get("maxSize");
        this.allowTypes = Arrays.asList((String[])conf.get("allowFiles"));
        this.filters = Arrays.asList((String[])conf.get("filter"));
    }

    public State capture(String[] list) {
        MultiState state = new MultiState(true);
        for (String source : list) {
            state.addState(this.captureRemoteData(source));
        }
        return state;
    }

    public State captureRemoteData(String urlStr) {
        HttpURLConnection connection = null;
        URL url = null;
        String suffix = null;
        try {
            url = new URL(urlStr);
            if (!this.validHost(url.getHost())) {
                return new BaseState(false, 201);
            }
            connection = (HttpURLConnection)url.openConnection();
            connection.setInstanceFollowRedirects(true);
            connection.setUseCaches(true);
            if (!this.validContentState(connection.getResponseCode())) {
                return new BaseState(false, 202);
            }
            suffix = MIMEType.getSuffix(connection.getContentType());
            if (!this.validFileType(suffix)) {
                return new BaseState(false, 8);
            }
            int contentLength = connection.getContentLength();
            if (!this.validFileSize(contentLength)) {
                return new BaseState(false, 1);
            }
            String savePath = this.getPath(this.savePath, this.filename, suffix);
            State state = this.storage.saveFileByInputStream(connection.getInputStream(), contentLength, this.rootPath, savePath);
            if (state.isSuccess()) {
                state.putInfo("source", urlStr);
            }
            return state;
        }
        catch (Exception e) {
            return new BaseState(false, 203);
        }
    }

    private String getPath(String savePath, String filename, String suffix) {
        return PathFormat.parse(savePath + suffix, filename);
    }

    private boolean validHost(String hostname) {
        try {
            InetAddress ip = InetAddress.getByName(hostname);
            if (ip.isSiteLocalAddress()) {
                return false;
            }
        }
        catch (UnknownHostException e) {
            return false;
        }
        return !this.filters.contains(hostname);
    }

    private boolean validContentState(int code) {
        return 200 == code;
    }

    private boolean validFileType(String type) {
        return this.allowTypes.contains(type);
    }

    private boolean validFileSize(int size) {
        return (long)size < this.maxSize;
    }
}

