/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.ueditor.upload;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baidu.ueditor.PathFormat;
import com.baidu.ueditor.define.BaseState;
import com.baidu.ueditor.define.FileType;
import com.baidu.ueditor.define.State;
import com.baidu.ueditor.upload.IStorageManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;

public final class Base64Uploader {
    private IStorageManager storage;
    private Pattern DATA_PREFIX = Pattern.compile("^data:([-\\w]+)/([-\\w]+)(;base64)?,", 2);

    public Base64Uploader(IStorageManager storage) {
        this.storage = storage;
    }

    public State save(HttpServletRequest request, Map<String, Object> conf) {
        String rootPath;
        State storageState;
        long maxSize;
        byte[] data;
        Map<String, String> parameters;
        String filedName = (String)conf.get("fieldName");
        try {
            parameters = this.getRequestParameter(request, filedName);
        }
        catch (IOException e) {
            return new BaseState(false, 4);
        }
        String originFileName = parameters.get("fileName");
        String content = parameters.get(filedName);
        if (content == null || content.length() == 0) {
            return new BaseState(false, 4);
        }
        Matcher matcher = this.DATA_PREFIX.matcher(content);
        String suffix = null;
        if (!matcher.find()) {
            try {
                data = Base64Uploader.decode(content);
            }
            catch (Exception e) {
                return new BaseState(false, 4);
            }
            if (originFileName != null) {
                suffix = FileType.getExtension(originFileName);
            }
        } else {
            content = content.substring(matcher.end());
            String dataType = matcher.group(1);
            String formatType = matcher.group(2);
            String base64 = matcher.group(3);
            suffix = FileType.getSuffix(formatType);
            if (base64 != null) {
                try {
                    data = Base64Uploader.decode(content);
                }
                catch (Exception e) {
                    return new BaseState(false, 4);
                }
            } else {
                data = content.getBytes(Charset.forName("UTF-8"));
            }
            if (originFileName == null) {
                originFileName = dataType + suffix;
            }
        }
        if (!Base64Uploader.validSize(data, maxSize = ((Long)conf.get("maxSize")).longValue())) {
            return new BaseState(false, 1);
        }
        if (suffix != null && !Base64Uploader.validType(suffix, (String[])conf.get("allowFiles"))) {
            return new BaseState(false, 8);
        }
        String filename = originFileName == null ? Base64Uploader.generateUuid() : FileType.removeExtension(new File(originFileName).getName());
        String savePath = PathFormat.parse((String)conf.get("savePath"), filename);
        if (suffix != null) {
            savePath = savePath + suffix;
        }
        if ((storageState = this.storage.saveBinaryFile(data, rootPath = (String)conf.get("rootPath"), savePath)).isSuccess()) {
            storageState.putInfo("type", suffix);
            storageState.putInfo("original", originFileName);
        }
        return storageState;
    }

    private static byte[] decode(String content) {
        return Base64.decodeBase64((String)content);
    }

    private static boolean validSize(byte[] data, long length) {
        return (long)data.length <= length;
    }

    private static boolean validType(String type, String[] allowTypes) {
        List<String> list = Arrays.asList(allowTypes);
        return list.contains(type);
    }

    private static String generateUuid() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    private Map<String, String> getRequestParameter(HttpServletRequest request, String filedName) throws IOException {
        String content = request.getParameter(filedName);
        if (content != null) {
            HashMap<String, String> result = new HashMap<String, String>();
            Map params = request.getParameterMap();
            for (Map.Entry entry : params.entrySet()) {
                result.put((String)entry.getKey(), Base64Uploader.joinToString((Object[])entry.getValue(), ','));
            }
            return result;
        }
        StringBuilder buffer = new StringBuilder();
        String line = null;
        BufferedReader reader = request.getReader();
        while ((line = reader.readLine()) != null) {
            buffer.append(line);
        }
        String string = buffer.toString().trim();
        if (string.startsWith("{") && string.endsWith("}")) {
            return Base64Uploader.parseJsonParams(string);
        }
        return Base64Uploader.parseRequestParams(string, "UTF-8");
    }

    private static String joinToString(Object[] array, char seprator) {
        if (array == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        if (array.length > 0) {
            for (Object tmp : array) {
                if (buffer.length() > 0) {
                    buffer.append(seprator);
                }
                buffer.append(tmp);
            }
        }
        return buffer.toString();
    }

    private static Map<String, String> parseJsonParams(String params) {
        JSONObject json = JSON.parseObject((String)params);
        HashMap<String, String> result = new HashMap<String, String>();
        for (String key : json.keySet()) {
            result.put(key, json.getString(key));
        }
        return result;
    }

    private static Map<String, String> parseRequestParams(String params, String charset) {
        String[] array;
        HashMap<String, String> map = new HashMap<String, String>();
        for (String item : array = Base64Uploader.split(params, '&')) {
            int index = item.indexOf(61);
            if (index < 0) {
                map.put(item, null);
                continue;
            }
            if (index == 0) {
                map.put(item, "");
                continue;
            }
            String key = item.substring(0, index);
            String value = item.substring(index + 1);
            if (charset != null) {
                try {
                    value = URLDecoder.decode(value, charset);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            map.put(key, value);
        }
        return map;
    }

    private static String[] split(String string, char ... chars) {
        return Base64Uploader.split(string, true, chars);
    }

    private static String[] split(String string, boolean trim, char ... chars) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return new String[0];
        }
        if (chars == null || chars.length == 0) {
            return new String[]{string};
        }
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder buffer = new StringBuilder();
        char[] textChars = string.toCharArray();
        boolean lastIsSplitChar = false;
        for (int i = 0; i < textChars.length; ++i) {
            char c = textChars[i];
            boolean isSplitChar = false;
            for (int j = 0; j < chars.length; ++j) {
                if (c != chars[j]) continue;
                isSplitChar = true;
                break;
            }
            if (!isSplitChar) {
                buffer.append(c);
                lastIsSplitChar = false;
                continue;
            }
            if (trim) {
                list.add(buffer.toString().trim());
            } else {
                list.add(buffer.toString());
            }
            buffer.setLength(0);
            lastIsSplitChar = true;
        }
        if (buffer.length() > 0) {
            if (trim) {
                list.add(buffer.toString().trim());
            } else {
                list.add(buffer.toString());
            }
            buffer.setLength(0);
        }
        if (lastIsSplitChar) {
            list.add("");
        }
        return list.toArray(new String[0]);
    }
}

