/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.ueditor.upload;

import com.baidu.ueditor.PathFormat;
import com.baidu.ueditor.define.BaseState;
import com.baidu.ueditor.define.State;
import com.baidu.ueditor.upload.IStorageManager;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;

public class StorageManager
implements IStorageManager {
    public static final int BUFFER_SIZE = 8192;

    @Override
    public State saveBinaryFile(byte[] data, String rootPath, String savePath) {
        File file = new File(rootPath + savePath);
        State state = StorageManager.valid(file);
        if (!state.isSuccess()) {
            return state;
        }
        try {
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
            bos.write(data);
            bos.flush();
            bos.close();
        }
        catch (IOException ioe) {
            return new BaseState(false, 4);
        }
        state = new BaseState(true, file.getAbsolutePath());
        state.putInfo("url", PathFormat.format(savePath));
        state.putInfo("size", data.length);
        state.putInfo("title", file.getName());
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public State saveFileByInputStream(InputStream input, long inputSize, String rootPath, String savePath) {
        State state = null;
        File tmpFile = StorageManager.getTmpFile();
        byte[] dataBuf = new byte[2048];
        BufferedInputStream bis = new BufferedInputStream(input, 8192);
        FilterOutputStream bos = null;
        try {
            bos = new BufferedOutputStream(new FileOutputStream(tmpFile), 8192);
            int count = 0;
            while ((count = bis.read(dataBuf)) != -1) {
                ((BufferedOutputStream)bos).write(dataBuf, 0, count);
            }
            ((BufferedOutputStream)bos).flush();
            state = StorageManager.saveTmpFile(tmpFile, rootPath + savePath);
            state.putInfo("url", PathFormat.format(savePath));
            if (!state.isSuccess()) {
                tmpFile.delete();
            }
            State state2 = state;
            return state2;
        }
        catch (IOException e) {
            BaseState baseState = new BaseState(false, 4);
            return baseState;
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static File getTmpFile() {
        File tmpDir = FileUtils.getTempDirectory();
        String tmpFileName = (Math.random() * 10000.0 + "").replace(".", "");
        return new File(tmpDir, tmpFileName);
    }

    private static State saveTmpFile(File tmpFile, String path) {
        BaseState state = null;
        File targetFile = new File(path);
        if (targetFile.canWrite()) {
            return new BaseState(false, 2);
        }
        try {
            FileUtils.moveFile((File)tmpFile, (File)targetFile);
        }
        catch (IOException e) {
            return new BaseState(false, 4);
        }
        state = new BaseState(true);
        state.putInfo("size", targetFile.length());
        state.putInfo("title", targetFile.getName());
        return state;
    }

    private static State valid(File file) {
        File parentPath = file.getParentFile();
        if (!parentPath.exists() && !parentPath.mkdirs()) {
            return new BaseState(false, 3);
        }
        if (!parentPath.canWrite()) {
            return new BaseState(false, 2);
        }
        return new BaseState(true);
    }
}

