/*
 * Decompiled with CFR 0.152.
 */
package com.beemans.common;

import android.util.SparseArray;
import android.util.SparseIntArray;
import android.view.View;
import androidx.databinding.DataBinderMapper;
import androidx.databinding.DataBindingComponent;
import androidx.databinding.ViewDataBinding;
import com.beemans.common.R;
import com.beemans.common.databinding.ViewStripCardBindingImpl;
import com.beemans.common.databinding.ViewTitleBarLayoutBindingImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class DataBinderMapperImpl
extends DataBinderMapper {
    private static final int LAYOUT_VIEWSTRIPCARD = 1;
    private static final int LAYOUT_VIEWTITLEBARLAYOUT = 2;
    private static final SparseIntArray INTERNAL_LAYOUT_ID_LOOKUP = new SparseIntArray(2);

    public ViewDataBinding getDataBinder(DataBindingComponent component, View view, int layoutId) {
        int localizedLayoutId = INTERNAL_LAYOUT_ID_LOOKUP.get(layoutId);
        if (localizedLayoutId > 0) {
            Object tag = view.getTag();
            if (tag == null) {
                throw new RuntimeException("view must have a tag");
            }
            switch (localizedLayoutId) {
                case 1: {
                    if ("layout/view_strip_card_0".equals(tag)) {
                        return new ViewStripCardBindingImpl(component, view);
                    }
                    throw new IllegalArgumentException("The tag for view_strip_card is invalid. Received: " + tag);
                }
                case 2: {
                    if ("layout/view_title_bar_layout_0".equals(tag)) {
                        return new ViewTitleBarLayoutBindingImpl(component, view);
                    }
                    throw new IllegalArgumentException("The tag for view_title_bar_layout is invalid. Received: " + tag);
                }
            }
        }
        return null;
    }

    public ViewDataBinding getDataBinder(DataBindingComponent component, View[] views, int layoutId) {
        if (views == null || views.length == 0) {
            return null;
        }
        int localizedLayoutId = INTERNAL_LAYOUT_ID_LOOKUP.get(layoutId);
        if (localizedLayoutId > 0) {
            Object tag = views[0].getTag();
            if (tag == null) {
                throw new RuntimeException("view must have a tag");
            }
        }
        return null;
    }

    public int getLayoutId(String tag) {
        if (tag == null) {
            return 0;
        }
        Integer tmpVal = InnerLayoutIdLookup.sKeys.get(tag);
        return tmpVal == null ? 0 : tmpVal;
    }

    public String convertBrIdToString(int localId) {
        String tmpVal = (String)InnerBrLookup.sKeys.get(localId);
        return tmpVal;
    }

    public List<DataBinderMapper> collectDependencies() {
        ArrayList<DataBinderMapper> result = new ArrayList<DataBinderMapper>(4);
        result.add((DataBinderMapper)new androidx.databinding.library.baseAdapters.DataBinderMapperImpl());
        result.add((DataBinderMapper)new com.chad.library.DataBinderMapperImpl());
        result.add((DataBinderMapper)new com.tiamosu.fly.DataBinderMapperImpl());
        result.add((DataBinderMapper)new com.tiamosu.navigation.databinding.DataBinderMapperImpl());
        return result;
    }

    static {
        INTERNAL_LAYOUT_ID_LOOKUP.put(R.layout.view_strip_card, 1);
        INTERNAL_LAYOUT_ID_LOOKUP.put(R.layout.view_title_bar_layout, 2);
    }

    private static class InnerLayoutIdLookup {
        static final HashMap<String, Integer> sKeys = new HashMap(2);

        private InnerLayoutIdLookup() {
        }

        static {
            sKeys.put("layout/view_strip_card_0", R.layout.view_strip_card);
            sKeys.put("layout/view_title_bar_layout_0", R.layout.view_title_bar_layout);
        }
    }

    private static class InnerBrLookup {
        static final SparseArray<String> sKeys = new SparseArray(1);

        private InnerBrLookup() {
        }

        static {
            sKeys.put(0, (Object)"_all");
        }
    }
}

