/*
 * Decompiled with CFR 0.152.
 */
package com.beemans.common.app;

import com.beemans.common.R;
import com.beemans.common.ext.CommonResourceExtKt;
import com.blankj.utilcode.util.NetworkUtils;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.io.NotSerializableException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.text.ParseException;
import javax.net.ssl.SSLHandshakeException;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import retrofit2.HttpException;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/beemans/common/app/ResponseErrorListenerImpl;", "", "()V", "BAD_GATEWAY", "", "FORBIDDEN", "GATEWAY_TIMEOUT", "INTERNAL_SERVER_ERROR", "NOT_FOUND", "REQUEST_TIMEOUT", "SERVICE_UNAVAILABLE", "UNAUTHORIZED", "convertStatusCode", "", "httpException", "Lretrofit2/HttpException;", "parseError", "t", "", "common_release"})
public final class ResponseErrorListenerImpl {
    @NotNull
    public static final ResponseErrorListenerImpl INSTANCE = new ResponseErrorListenerImpl();
    private static final int UNAUTHORIZED = 401;
    private static final int FORBIDDEN = 403;
    private static final int NOT_FOUND = 404;
    private static final int REQUEST_TIMEOUT = 408;
    private static final int INTERNAL_SERVER_ERROR = 500;
    private static final int BAD_GATEWAY = 502;
    private static final int SERVICE_UNAVAILABLE = 503;
    private static final int GATEWAY_TIMEOUT = 504;

    private ResponseErrorListenerImpl() {
    }

    @NotNull
    public final String parseError(@Nullable Throwable t) {
        String string2;
        if (t instanceof HttpException) {
            string2 = this.convertStatusCode((HttpException)t);
        } else if (t instanceof JsonSyntaxException || t instanceof JSONException || t instanceof JsonParseException || t instanceof ParseException || t instanceof NotSerializableException) {
            string2 = CommonResourceExtKt.toString2$default(R.string.common_net_request_failed, null, new Object[0], 1, null);
        } else if (t instanceof ClassCastException) {
            string2 = CommonResourceExtKt.toString2$default(R.string.common_net_request_failed, null, new Object[0], 1, null);
        } else if (t instanceof ConnectException) {
            string2 = CommonResourceExtKt.toString2$default(R.string.common_net_connect_failed, null, new Object[0], 1, null);
        } else if (t instanceof SocketTimeoutException) {
            string2 = CommonResourceExtKt.toString2$default(R.string.common_net_request_timeout, null, new Object[0], 1, null);
        } else if (t instanceof SSLHandshakeException) {
            string2 = CommonResourceExtKt.toString2$default(R.string.common_net_connect_failed, null, new Object[0], 1, null);
        } else if (t instanceof UnknownHostException) {
            string2 = CommonResourceExtKt.toString2$default(R.string.common_net_connect_failed, null, new Object[0], 1, null);
        } else if (t instanceof NullPointerException) {
            string2 = CommonResourceExtKt.toString2$default(R.string.common_net_request_failed, null, new Object[0], 1, null);
        } else if (t instanceof RuntimeException) {
            string2 = ((RuntimeException)t).getMessage();
            if (string2 == null) {
                string2 = CommonResourceExtKt.toString2$default(R.string.common_net_abnormal_operation, null, new Object[0], 1, null);
            }
        } else {
            string2 = !NetworkUtils.isConnected() ? CommonResourceExtKt.toString2$default(R.string.common_net_connect_failed, null, new Object[0], 1, null) : CommonResourceExtKt.toString2$default(R.string.common_net_request_failed, null, new Object[0], 1, null);
        }
        return string2;
    }

    private final String convertStatusCode(HttpException httpException) {
        String string2;
        switch (httpException.code()) {
            case 401: 
            case 403: 
            case 404: 
            case 408: 
            case 500: 
            case 502: 
            case 503: 
            case 504: {
                string2 = CommonResourceExtKt.toString2$default(R.string.common_net_connect_service_timeout, null, new Object[0], 1, null);
                break;
            }
            default: {
                string2 = CommonResourceExtKt.toString2$default(R.string.common_net_connect_service_timeout, null, new Object[0], 1, null);
            }
        }
        return string2;
    }
}

