/*
 * Decompiled with CFR 0.152.
 */
package com.beemans.common.ui.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;
import android.widget.FrameLayout;
import android.widget.TextSwitcher;
import android.widget.TextView;
import android.widget.ViewSwitcher;
import com.beemans.common.R;
import com.beemans.common.ui.views.AutoScrollTextView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010!\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u001b\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u000fH\u0014J\u0016\u0010!\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020\u001dJ\u0010\u0010$\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020\u0019H\u0016J\u0014\u0010&\u001a\u00020\u000f2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00190(J+\u0010)\u001a\u00020\u000f2#\b\u0002\u0010*\u001a\u001d\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u000f0\u000bJ\u0006\u0010+\u001a\u00020\u000fR\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R)\u0010\n\u001a\u001d\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u000f0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0010\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0016\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/beemans/common/ui/views/AutoScrollTextView;", "Landroid/widget/TextSwitcher;", "Landroid/widget/ViewSwitcher$ViewFactory;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "currentId", "", "startScrollCallback", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "position", "", "startScrollRunnable", "Ljava/lang/Runnable;", "getStartScrollRunnable", "()Ljava/lang/Runnable;", "startScrollRunnable$delegate", "Lkotlin/Lazy;", "textColor", "textList", "Ljava/util/ArrayList;", "", "textSize", "", "time", "", "makeView", "Landroid/view/View;", "onDetachedFromWindow", "setAnimTime", "animIn", "animOut", "setText", "text", "setTextList", "titles", "", "startAutoScroll", "callback", "stopAutoScroll", "common_release"})
public final class AutoScrollTextView
extends TextSwitcher
implements ViewSwitcher.ViewFactory {
    private float textSize;
    private int textColor;
    private long time;
    private int currentId;
    @NotNull
    private final ArrayList<CharSequence> textList;
    @NotNull
    private Function1<? super Integer, Unit> startScrollCallback;
    @NotNull
    private final Lazy startScrollRunnable$delegate;

    @JvmOverloads
    public AutoScrollTextView(@NotNull Context context, @Nullable AttributeSet attrs) {
        TypedArray typedArray;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        this.textSize = 12.0f;
        this.textColor = -1;
        this.currentId = -1;
        this.textList = new ArrayList();
        this.startScrollCallback = startScrollCallback.1.INSTANCE;
        this.startScrollRunnable$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Runnable>(this){
            final /* synthetic */ AutoScrollTextView this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Runnable invoke() {
                return () -> startScrollRunnable.2.invoke$lambda-0(this.this$0);
            }

            private static final void invoke$lambda-0(AutoScrollTextView this$0) {
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                this$0.startAutoScroll((Function1<? super Integer, Unit>)AutoScrollTextView.access$getStartScrollCallback$p(this$0));
            }
        }));
        TypedArray $this$_init__u24lambda_u2d0 = typedArray = context.obtainStyledAttributes(attrs, R.styleable.AutoScrollTextView);
        boolean bl = false;
        this.textSize = $this$_init__u24lambda_u2d0.getDimensionPixelSize(R.styleable.AutoScrollTextView_astv_textSize, 12);
        this.textColor = $this$_init__u24lambda_u2d0.getColor(R.styleable.AutoScrollTextView_astv_textColor, this.textColor);
        this.time = $this$_init__u24lambda_u2d0.getInt(R.styleable.AutoScrollTextView_astv_duration, 1000);
        $this$_init__u24lambda_u2d0.recycle();
        this.setFactory(this);
    }

    public /* synthetic */ AutoScrollTextView(Context context, AttributeSet attributeSet, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            attributeSet = null;
        }
        this(context, attributeSet);
    }

    private final Runnable getStartScrollRunnable() {
        Lazy lazy = this.startScrollRunnable$delegate;
        return (Runnable)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public final void setAnimTime(long animIn, long animOut) {
        if (this.textList.size() > 1) {
            void $this$setAnimTime_u24lambda_u2d2;
            TranslateAnimation $this$setAnimTime_u24lambda_u2d1;
            TranslateAnimation translateAnimation;
            TranslateAnimation translateAnimation2 = translateAnimation = new TranslateAnimation(0.0f, 0.0f, (float)animIn, 0.0f);
            AutoScrollTextView autoScrollTextView = this;
            boolean bl = false;
            $this$setAnimTime_u24lambda_u2d1.setDuration(animIn);
            autoScrollTextView.setInAnimation((Animation)translateAnimation);
            $this$setAnimTime_u24lambda_u2d1 = translateAnimation = new TranslateAnimation(0.0f, 0.0f, 0.0f, (float)(-animOut));
            autoScrollTextView = this;
            boolean bl2 = false;
            $this$setAnimTime_u24lambda_u2d2.setDuration(animOut);
            autoScrollTextView.setOutAnimation((Animation)translateAnimation);
        }
    }

    public void setText(@NotNull CharSequence text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        View view = this.getNextView();
        TextView textView = view instanceof TextView ? (TextView)view : null;
        if (textView != null) {
            textView.setText(text);
        }
        this.showNext();
    }

    public final void setTextList(@NotNull List<CharSequence> titles) {
        Intrinsics.checkNotNullParameter(titles, (String)"titles");
        if (!((Collection)this.textList).isEmpty()) {
            this.textList.clear();
        }
        this.textList.addAll((Collection<CharSequence>)titles);
        this.currentId = -1;
    }

    public final void startAutoScroll(@NotNull Function1<? super Integer, Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.startScrollCallback = callback;
        if (this.textList.size() > 0) {
            int n = this.currentId;
            this.currentId = n + 1;
            int position = this.currentId % this.textList.size();
            CharSequence charSequence = this.textList.get(position);
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"textList[position]");
            this.setText(charSequence);
            callback.invoke((Object)position);
        }
        if (this.textList.size() > 1) {
            this.stopAutoScroll();
            this.postDelayed(this.getStartScrollRunnable(), this.time);
        }
    }

    public static /* synthetic */ void startAutoScroll$default(AutoScrollTextView autoScrollTextView, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = startAutoScroll.1.INSTANCE;
        }
        autoScrollTextView.startAutoScroll((Function1<? super Integer, Unit>)function1);
    }

    public final void stopAutoScroll() {
        this.removeCallbacks(this.getStartScrollRunnable());
    }

    @NotNull
    public View makeView() {
        TextView textView;
        TextView $this$makeView_u24lambda_u2d3 = textView = new TextView(this.getContext());
        boolean bl = false;
        $this$makeView_u24lambda_u2d3.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        $this$makeView_u24lambda_u2d3.setGravity(17);
        $this$makeView_u24lambda_u2d3.setMaxLines(1);
        $this$makeView_u24lambda_u2d3.setTextColor(this.textColor);
        $this$makeView_u24lambda_u2d3.setTextSize(0, this.textSize);
        return (View)textView;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.stopAutoScroll();
    }

    @JvmOverloads
    public AutoScrollTextView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 2, null);
    }

    public static final /* synthetic */ Function1 access$getStartScrollCallback$p(AutoScrollTextView $this) {
        return $this.startScrollCallback;
    }
}

