/*
 * Decompiled with CFR 0.152.
 */
package com.beemans.common.ui.views;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.OvershootInterpolator;
import androidx.annotation.ColorRes;
import androidx.core.content.ContextCompat;
import com.beemans.common.R;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\t\n\u0000\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J\u0018\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u0007H\u0015J\u0010\u0010#\u001a\u00020\u001d2\b\b\u0001\u0010$\u001a\u00020\u0007J\u001a\u0010#\u001a\u00020\u001d2\b\b\u0001\u0010%\u001a\u00020\u00072\b\b\u0001\u0010&\u001a\u00020\u0007J\u0010\u0010#\u001a\u00020\u001d2\b\b\u0001\u0010'\u001a\u00020\nJ\u000e\u0010(\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020\u0007J\u0010\u0010*\u001a\u00020\u001d2\b\b\u0001\u0010$\u001a\u00020\u0007J\u001a\u0010*\u001a\u00020\u001d2\b\b\u0001\u0010%\u001a\u00020\u00072\b\b\u0001\u0010+\u001a\u00020\u0007J\u0010\u0010*\u001a\u00020\u001d2\b\b\u0001\u0010'\u001a\u00020\nJ\u000e\u0010,\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020\u0007J\u0016\u0010\u001a\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010-\u001a\u00020.R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006/"}, d2={"Lcom/beemans/common/ui/views/CircularProgressView;", "Landroid/view/View;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "mBackColorArray", "", "mBackEndAngle", "", "mBackPaint", "Landroid/graphics/Paint;", "mBackStartAngle", "mProgColorArray", "mProgEndAngle", "mProgPaint", "mProgStartAngle", "mProgress", "mRectF", "Landroid/graphics/RectF;", "progress", "getProgress", "()I", "setProgress", "(I)V", "onDraw", "", "canvas", "Landroid/graphics/Canvas;", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "setBackColor", "color", "startColor", "endColor", "colorArray", "setBackWidth", "width", "setProgColor", "firstColor", "setProgWidth", "animTime", "", "common_release"})
public final class CircularProgressView
extends View {
    @NotNull
    private final Paint mBackPaint;
    @NotNull
    private final Paint mProgPaint;
    @Nullable
    private RectF mRectF;
    @NotNull
    private int[] mBackColorArray;
    @NotNull
    private int[] mProgColorArray;
    private int mProgress;
    private float mBackStartAngle;
    private float mProgStartAngle;
    private float mBackEndAngle;
    private float mProgEndAngle;

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public CircularProgressView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        void $this$_init__u24lambda_u2d1;
        Paint $this$_init__u24lambda_u2d0;
        Paint paint;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.mBackColorArray = new int[0];
        this.mProgColorArray = new int[0];
        this.mProgStartAngle = 270.0f;
        this.mBackEndAngle = 360.0f;
        this.mProgEndAngle = 360.0f;
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.CircularProgressView);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.obtainStyledAttr\u2026ble.CircularProgressView)");
        TypedArray typedArray2 = typedArray;
        Paint paint2 = paint = new Paint();
        CircularProgressView circularProgressView = this;
        boolean bl = false;
        $this$_init__u24lambda_u2d0.setStyle(Paint.Style.STROKE);
        $this$_init__u24lambda_u2d0.setStrokeCap(Paint.Cap.ROUND);
        $this$_init__u24lambda_u2d0.setAntiAlias(true);
        $this$_init__u24lambda_u2d0.setDither(true);
        $this$_init__u24lambda_u2d0.setStrokeWidth(typedArray2.getDimension(R.styleable.CircularProgressView_tcp_backWidth, 5.0f));
        $this$_init__u24lambda_u2d0.setColor(typedArray2.getColor(R.styleable.CircularProgressView_tcp_backColor, -3355444));
        circularProgressView.mBackPaint = paint;
        $this$_init__u24lambda_u2d0 = paint = new Paint();
        circularProgressView = this;
        boolean bl22 = false;
        $this$_init__u24lambda_u2d1.setStyle(Paint.Style.STROKE);
        $this$_init__u24lambda_u2d1.setStrokeCap(Paint.Cap.ROUND);
        $this$_init__u24lambda_u2d1.setAntiAlias(true);
        $this$_init__u24lambda_u2d1.setDither(true);
        $this$_init__u24lambda_u2d1.setStrokeWidth(typedArray2.getDimension(R.styleable.CircularProgressView_tcp_progWidth, 10.0f));
        $this$_init__u24lambda_u2d1.setColor(typedArray2.getColor(R.styleable.CircularProgressView_tcp_progColor, -16776961));
        circularProgressView.mProgPaint = paint;
        int backStartColor = typedArray2.getColor(R.styleable.CircularProgressView_tcp_backStartColor, -1);
        int backEndColor = typedArray2.getColor(R.styleable.CircularProgressView_tcp_backEndColor, -1);
        if (backStartColor != -1 && backEndColor != -1) {
            int[] bl22 = new int[]{backStartColor, backEndColor};
            this.mBackColorArray = bl22;
        }
        int progStartColor = typedArray2.getColor(R.styleable.CircularProgressView_tcp_progStartColor, -1);
        int progEndColor = typedArray2.getColor(R.styleable.CircularProgressView_tcp_progEndColor, -1);
        if (progStartColor != -1 && progEndColor != -1) {
            int[] nArray = new int[]{progStartColor, progEndColor};
            this.mProgColorArray = nArray;
        }
        this.mProgress = typedArray2.getInteger(R.styleable.CircularProgressView_tcp_progress, this.mProgress);
        this.mBackStartAngle = typedArray2.getFloat(R.styleable.CircularProgressView_tcp_backStartAngle, this.mBackStartAngle);
        this.mProgStartAngle = typedArray2.getFloat(R.styleable.CircularProgressView_tcp_progStartAngle, this.mProgStartAngle);
        this.mBackEndAngle = typedArray2.getFloat(R.styleable.CircularProgressView_tcp_backEndAngle, this.mBackEndAngle);
        this.mProgEndAngle = typedArray2.getFloat(R.styleable.CircularProgressView_tcp_progEndAngle, this.mProgEndAngle);
        typedArray2.recycle();
    }

    public /* synthetic */ CircularProgressView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @SuppressLint(value={"DrawAllocation"})
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int viewWide = this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight();
        int viewHigh = this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom();
        int minWidth = RangesKt.coerceAtMost((int)viewWide, (int)viewHigh);
        float maxStrokeWidth = RangesKt.coerceAtLeast((float)this.mBackPaint.getStrokeWidth(), (float)this.mProgPaint.getStrokeWidth());
        float mRectLength = (float)minWidth - maxStrokeWidth;
        float mRectL = (float)this.getPaddingLeft() + ((float)viewWide - mRectLength) / (float)2;
        float mRectT = (float)this.getPaddingTop() + ((float)viewHigh - mRectLength) / (float)2;
        this.mRectF = new RectF(mRectL, mRectT, mRectL + mRectLength, mRectT + mRectLength);
        if (this.mBackColorArray.length > 1) {
            this.mBackPaint.setShader((Shader)new LinearGradient(0.0f, 0.0f, 0.0f, (float)this.getMeasuredWidth(), this.mBackColorArray, null, Shader.TileMode.MIRROR));
        }
        if (this.mProgColorArray.length > 1) {
            this.mProgPaint.setShader((Shader)new LinearGradient(0.0f, 0.0f, 0.0f, (float)this.getMeasuredWidth(), this.mProgColorArray, null, Shader.TileMode.MIRROR));
        }
    }

    protected void onDraw(@NotNull Canvas canvas) {
        block1: {
            RectF it;
            Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
            super.onDraw(canvas);
            RectF rectF = this.mRectF;
            if (rectF != null) {
                it = rectF;
                boolean bl = false;
                canvas.drawArc(it, this.mBackStartAngle, this.mBackEndAngle, false, this.mBackPaint);
            }
            RectF rectF2 = this.mRectF;
            if (rectF2 == null) break block1;
            it = rectF2;
            boolean bl = false;
            canvas.drawArc(it, this.mProgStartAngle, this.mProgEndAngle * (float)this.mProgress / (float)100, false, this.mProgPaint);
        }
    }

    public final int getProgress() {
        return this.mProgress;
    }

    public final void setProgress(int progress) {
        this.mProgress = progress;
        this.invalidate();
    }

    public final void setProgress(int progress, long animTime) {
        if (animTime <= 0L) {
            this.setProgress(progress);
        } else {
            int[] nArray = new int[]{this.mProgress, progress};
            ValueAnimator animator = ValueAnimator.ofInt((int[])nArray);
            animator.addUpdateListener(arg_0 -> CircularProgressView.setProgress$lambda-4(this, arg_0));
            animator.setInterpolator((TimeInterpolator)new OvershootInterpolator());
            animator.setDuration(animTime);
            animator.start();
        }
    }

    public final void setBackWidth(int width) {
        this.mBackPaint.setStrokeWidth((float)width);
        this.invalidate();
    }

    public final void setBackColor(@ColorRes int color2) {
        this.mBackPaint.setColor(ContextCompat.getColor((Context)this.getContext(), (int)color2));
        this.invalidate();
    }

    public final void setBackColor(@ColorRes int startColor, @ColorRes int endColor) {
        int[] nArray = new int[]{ContextCompat.getColor((Context)this.getContext(), (int)startColor), ContextCompat.getColor((Context)this.getContext(), (int)endColor)};
        this.mBackColorArray = nArray;
        this.mBackPaint.setShader((Shader)new LinearGradient(0.0f, 0.0f, 0.0f, (float)this.getMeasuredWidth(), this.mBackColorArray, null, Shader.TileMode.MIRROR));
        this.invalidate();
    }

    /*
     * WARNING - void declaration
     */
    public final void setBackColor(@ColorRes @NotNull int[] colorArray) {
        Intrinsics.checkNotNullParameter((Object)colorArray, (String)"colorArray");
        if (colorArray.length < 2) {
            return;
        }
        this.mBackColorArray = new int[colorArray.length];
        int[] $this$forEachIndexed$iv = colorArray;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (int item$iv : $this$forEachIndexed$iv) {
            void id2;
            int n = index$iv++;
            int n2 = item$iv;
            int index = n;
            boolean bl = false;
            this.mBackColorArray[index] = ContextCompat.getColor((Context)this.getContext(), (int)id2);
        }
        this.mBackPaint.setShader((Shader)new LinearGradient(0.0f, 0.0f, 0.0f, (float)this.getMeasuredWidth(), this.mBackColorArray, null, Shader.TileMode.MIRROR));
        this.invalidate();
    }

    public final void setProgWidth(int width) {
        this.mProgPaint.setStrokeWidth((float)width);
        this.invalidate();
    }

    public final void setProgColor(@ColorRes int color2) {
        this.mProgPaint.setColor(ContextCompat.getColor((Context)this.getContext(), (int)color2));
        this.mProgPaint.setShader(null);
        this.invalidate();
    }

    public final void setProgColor(@ColorRes int startColor, @ColorRes int firstColor) {
        int[] nArray = new int[]{ContextCompat.getColor((Context)this.getContext(), (int)startColor), ContextCompat.getColor((Context)this.getContext(), (int)firstColor)};
        this.mProgColorArray = nArray;
        this.mProgPaint.setShader((Shader)new LinearGradient(0.0f, 0.0f, 0.0f, (float)this.getMeasuredWidth(), this.mProgColorArray, null, Shader.TileMode.MIRROR));
        this.invalidate();
    }

    /*
     * WARNING - void declaration
     */
    public final void setProgColor(@ColorRes @NotNull int[] colorArray) {
        Intrinsics.checkNotNullParameter((Object)colorArray, (String)"colorArray");
        if (colorArray.length < 2) {
            return;
        }
        this.mProgColorArray = new int[colorArray.length];
        int[] $this$forEachIndexed$iv = colorArray;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (int item$iv : $this$forEachIndexed$iv) {
            void id2;
            int n = index$iv++;
            int n2 = item$iv;
            int index = n;
            boolean bl = false;
            this.mProgColorArray[index] = ContextCompat.getColor((Context)this.getContext(), (int)id2);
        }
        this.mProgPaint.setShader((Shader)new LinearGradient(0.0f, 0.0f, 0.0f, (float)this.getMeasuredWidth(), this.mProgColorArray, null, Shader.TileMode.MIRROR));
        this.invalidate();
    }

    @JvmOverloads
    public CircularProgressView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public CircularProgressView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final void setProgress$lambda-4(CircularProgressView this$0, ValueAnimator animation) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Object object = animation.getAnimatedValue();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
        this$0.setProgress((Integer)object);
    }
}

