/*
 * Decompiled with CFR 0.152.
 */
package com.beemans.common.ui.views;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewParent;
import android.widget.FrameLayout;
import androidx.viewpager2.widget.ViewPager2;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\fH\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/beemans/common/ui/views/NestedScrollableHost;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "child", "Landroid/view/View;", "getChild", "()Landroid/view/View;", "initialX", "", "initialY", "parentViewPager", "Landroidx/viewpager2/widget/ViewPager2;", "getParentViewPager", "()Landroidx/viewpager2/widget/ViewPager2;", "touchSlop", "", "canChildScroll", "", "orientation", "delta", "handleInterceptTouchEvent", "", "e", "Landroid/view/MotionEvent;", "onInterceptTouchEvent", "common_release"})
public final class NestedScrollableHost
extends FrameLayout {
    private int touchSlop;
    private float initialX;
    private float initialY;

    @JvmOverloads
    public NestedScrollableHost(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        this.touchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
    }

    public /* synthetic */ NestedScrollableHost(Context context, AttributeSet attributeSet, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            attributeSet = null;
        }
        this(context, attributeSet);
    }

    private final ViewPager2 getParentViewPager() {
        View v;
        ViewParent viewParent = this.getParent();
        View view = v = viewParent instanceof View ? (View)viewParent : null;
        while (v != null && !(v instanceof ViewPager2)) {
            viewParent = v.getParent();
            v = viewParent instanceof View ? (View)viewParent : null;
        }
        viewParent = v;
        return viewParent instanceof ViewPager2 ? (ViewPager2)viewParent : null;
    }

    private final View getChild() {
        return this.getChildCount() > 0 ? this.getChildAt(0) : null;
    }

    private final boolean canChildScroll(int orientation, float delta) {
        boolean bl;
        int direction = -((int)Math.signum(delta));
        switch (orientation) {
            case 0: {
                View view = this.getChild();
                if (view != null) {
                    bl = view.canScrollHorizontally(direction);
                    break;
                }
                bl = false;
                break;
            }
            case 1: {
                View view = this.getChild();
                if (view != null) {
                    bl = view.canScrollVertically(direction);
                    break;
                }
                bl = false;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return bl;
    }

    public boolean onInterceptTouchEvent(@NotNull MotionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.handleInterceptTouchEvent(e);
        return super.onInterceptTouchEvent(e);
    }

    private final void handleInterceptTouchEvent(MotionEvent e) {
        ViewPager2 viewPager2 = this.getParentViewPager();
        if (viewPager2 == null) {
            return;
        }
        int orientation = viewPager2.getOrientation();
        if (!this.canChildScroll(orientation, -1.0f) && !this.canChildScroll(orientation, 1.0f)) {
            return;
        }
        if (e.getAction() == 0) {
            this.initialX = e.getX();
            this.initialY = e.getY();
            this.getParent().requestDisallowInterceptTouchEvent(true);
        } else if (e.getAction() == 2) {
            float dx = e.getX() - this.initialX;
            float dy = e.getY() - this.initialY;
            boolean isVpHorizontal = orientation == 0;
            float scaledDx = Math.abs(dx) * (isVpHorizontal ? 0.5f : 1.0f);
            float scaledDy = Math.abs(dy) * (isVpHorizontal ? 1.0f : 0.5f);
            if (scaledDx > (float)this.touchSlop || scaledDy > (float)this.touchSlop) {
                if (isVpHorizontal == scaledDy > scaledDx) {
                    this.getParent().requestDisallowInterceptTouchEvent(false);
                } else if (this.canChildScroll(orientation, isVpHorizontal ? dx : dy)) {
                    this.getParent().requestDisallowInterceptTouchEvent(true);
                } else {
                    this.getParent().requestDisallowInterceptTouchEvent(false);
                }
            }
        }
    }

    @JvmOverloads
    public NestedScrollableHost(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 2, null);
    }
}

