/*
 * Decompiled with CFR 0.152.
 */
package com.beemans.common.ui.views.exposure;

import android.graphics.Rect;
import android.os.Handler;
import android.view.View;
import android.view.ViewTreeObserver;
import com.beemans.common.ui.views.exposure.ExposureHandler;
import com.beemans.common.ui.views.exposure.IExposureCallback;
import com.tiamosu.fly.base.action.HandlerAction;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000f\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\u001dJ\b\u0010\u001f\u001a\u00020\u000bH\u0016J\u000e\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u000bJ\u000e\u0010\"\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020\u000bJ\u000e\u0010$\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\u0007J\u000e\u0010&\u001a\u00020\u001d2\u0006\u0010'\u001a\u00020\u0019J\u000e\u0010(\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020\u001bJ\b\u0010*\u001a\u00020\u001dH\u0002J\b\u0010+\u001a\u00020\u001dH\u0002R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0012\u001a\u00020\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/beemans/common/ui/views/exposure/ExposureHandler;", "Landroid/view/ViewTreeObserver$OnPreDrawListener;", "Lcom/tiamosu/fly/base/action/HandlerAction;", "view", "Landroid/view/View;", "(Landroid/view/View;)V", "exposureCallback", "Lcom/beemans/common/ui/views/exposure/IExposureCallback;", "exposureRunnable", "Ljava/lang/Runnable;", "isAttachedToWindow", "", "isExposure", "<set-?>", "isLocalVisible", "()Z", "isVisibilityAggregated", "isWindowFocusChanged", "rect", "Landroid/graphics/Rect;", "getRect", "()Landroid/graphics/Rect;", "rect$delegate", "Lkotlin/Lazy;", "showRatio", "", "timeLimit", "", "onAttachedToWindow", "", "onDetachedFromWindow", "onPreDraw", "onVisibilityAggregated", "isVisible", "onWindowFocusChanged", "hasWindowFocus", "setExposureCallback", "callback", "setShowRatio", "area", "setTimeLimit", "index", "tryExposure", "tryStopExposure", "common_release"})
public final class ExposureHandler
implements ViewTreeObserver.OnPreDrawListener,
HandlerAction {
    @NotNull
    private final View view;
    private boolean isAttachedToWindow;
    private boolean isWindowFocusChanged;
    private boolean isVisibilityAggregated;
    private boolean isExposure;
    private float showRatio;
    private long timeLimit;
    @NotNull
    private final Lazy rect$delegate;
    @Nullable
    private IExposureCallback exposureCallback;
    @Nullable
    private Runnable exposureRunnable;
    private boolean isLocalVisible;

    public ExposureHandler(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        this.view = view;
        this.isWindowFocusChanged = true;
        this.isVisibilityAggregated = true;
        this.rect$delegate = LazyKt.lazy((Function0)rect.2.INSTANCE);
    }

    private final Rect getRect() {
        Lazy lazy = this.rect$delegate;
        return (Rect)lazy.getValue();
    }

    public final boolean isLocalVisible() {
        return this.isLocalVisible;
    }

    public final void onAttachedToWindow() {
        ViewTreeObserver viewTreeObserver;
        this.isAttachedToWindow = true;
        ViewTreeObserver $this$onAttachedToWindow_u24lambda_u2d0 = viewTreeObserver = this.view.getViewTreeObserver();
        boolean bl = false;
        if ($this$onAttachedToWindow_u24lambda_u2d0.isAlive()) {
            $this$onAttachedToWindow_u24lambda_u2d0.addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
        }
        this.tryExposure();
    }

    public final void onDetachedFromWindow() {
        ViewTreeObserver viewTreeObserver;
        this.isAttachedToWindow = false;
        ViewTreeObserver $this$onDetachedFromWindow_u24lambda_u2d1 = viewTreeObserver = this.view.getViewTreeObserver();
        boolean bl = false;
        if ($this$onDetachedFromWindow_u24lambda_u2d1.isAlive()) {
            $this$onDetachedFromWindow_u24lambda_u2d1.removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
        }
        this.tryStopExposure();
    }

    public final void onWindowFocusChanged(boolean hasWindowFocus) {
        this.isWindowFocusChanged = hasWindowFocus;
        if (hasWindowFocus) {
            this.tryExposure();
        } else {
            this.tryStopExposure();
        }
    }

    public final void onVisibilityAggregated(boolean isVisible) {
        this.isVisibilityAggregated = isVisible;
        if (isVisible) {
            this.tryExposure();
        } else {
            this.tryStopExposure();
        }
    }

    public boolean onPreDraw() {
        boolean visible;
        boolean bl = visible = this.view.getLocalVisibleRect(this.getRect()) && this.view.isShown();
        if (!visible) {
            this.tryStopExposure();
            return true;
        }
        if (this.showRatio > 0.0f) {
            if ((float)Math.abs(this.getRect().bottom - this.getRect().top) > (float)this.view.getHeight() * this.showRatio && (float)Math.abs(this.getRect().right - this.getRect().left) > (float)this.view.getWidth() * this.showRatio) {
                this.tryExposure();
            } else {
                this.tryStopExposure();
            }
        } else {
            this.tryExposure();
        }
        return true;
    }

    public final void setExposureCallback(@NotNull IExposureCallback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.exposureCallback = callback;
    }

    public final void setShowRatio(float area) {
        this.showRatio = area;
    }

    public final void setTimeLimit(long index) {
        this.timeLimit = index;
    }

    private final void tryExposure() {
        if (this.isAttachedToWindow && this.isWindowFocusChanged && this.isVisibilityAggregated && !this.isExposure) {
            this.isExposure = true;
            this.exposureRunnable = () -> ExposureHandler.tryExposure$lambda-2(this);
            this.postDelayed(this.exposureRunnable, this.timeLimit);
        }
    }

    private final void tryStopExposure() {
        block2: {
            if (!this.isExposure) break block2;
            this.isExposure = false;
            this.removeCallbacks(this.exposureRunnable);
            if (this.isLocalVisible) {
                this.isLocalVisible = false;
                IExposureCallback iExposureCallback = this.exposureCallback;
                if (iExposureCallback != null) {
                    iExposureCallback.invoke(false);
                }
            }
        }
    }

    @NotNull
    public Handler getHandler() {
        return HandlerAction.DefaultImpls.getHandler((HandlerAction)this);
    }

    public boolean post(@Nullable Runnable r) {
        return HandlerAction.DefaultImpls.post((HandlerAction)this, (Runnable)r);
    }

    public boolean postAtTime(@Nullable Runnable r, long uptimeMillis) {
        return HandlerAction.DefaultImpls.postAtTime((HandlerAction)this, (Runnable)r, (long)uptimeMillis);
    }

    public boolean postDelayed(@Nullable Runnable r, long delayMillis) {
        return HandlerAction.DefaultImpls.postDelayed((HandlerAction)this, (Runnable)r, (long)delayMillis);
    }

    public void removeCallbacks() {
        HandlerAction.DefaultImpls.removeCallbacks((HandlerAction)this);
    }

    public void removeCallbacks(@Nullable Runnable r) {
        HandlerAction.DefaultImpls.removeCallbacks((HandlerAction)this, (Runnable)r);
    }

    private static final void tryExposure$lambda-2(ExposureHandler this$0) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            if (this$0.isLocalVisible) break block1;
            this$0.isLocalVisible = true;
            IExposureCallback iExposureCallback = this$0.exposureCallback;
            if (iExposureCallback != null) {
                iExposureCallback.invoke(true);
            }
        }
    }
}

