/*
 * Decompiled with CFR 0.152.
 */
package com.beemans.common.ui.views.sticky;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.beemans.common.R;
import com.beemans.common.ui.views.sticky.OnStickyScrollChangeListener;
import com.beemans.common.ui.views.sticky.StickyLinearLayout;
import com.beemans.common.ui.views.sticky.ViewOffsetHelper;
import com.google.android.material.R;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0011\u0018\u0000 52\u00020\u00012\u00020\u0002:\u000256B%\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\b\u0010\u001b\u001a\u00020\u001cH\u0014J\u0010\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\u0018\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\bH\u0014J\u0012\u0010!\u001a\u0004\u0018\u00010\u00122\u0006\u0010\"\u001a\u00020\u0011H\u0002J\u0012\u0010#\u001a\u0004\u0018\u00010\u00112\u0006\u0010$\u001a\u00020\bH\u0002J0\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00182\u0006\u0010(\u001a\u00020\b2\u0006\u0010)\u001a\u00020\b2\u0006\u0010*\u001a\u00020\b2\u0006\u0010+\u001a\u00020\bH\u0014J\u0018\u0010,\u001a\u00020&2\u0006\u0010-\u001a\u00020\b2\u0006\u0010.\u001a\u00020\bH\u0014J0\u0010/\u001a\u00020&2\u0006\u00100\u001a\u00020\u00112\u0006\u00101\u001a\u00020\b2\u0006\u00102\u001a\u00020\b2\u0006\u00103\u001a\u00020\b2\u0006\u00104\u001a\u00020\bH\u0016R\u001a\u0010\n\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR)\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014\u00a8\u00067"}, d2={"Lcom/beemans/common/ui/views/sticky/StickyLinearLayout;", "Landroid/widget/LinearLayout;", "Lcom/beemans/common/ui/views/sticky/OnStickyScrollChangeListener;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "stickyFixedViewTop", "getStickyFixedViewTop", "()I", "setStickyFixedViewTop", "(I)V", "viewOffsetHelpers", "", "Landroid/view/View;", "Lcom/beemans/common/ui/views/sticky/ViewOffsetHelper;", "getViewOffsetHelpers", "()Ljava/util/Map;", "viewOffsetHelpers$delegate", "Lkotlin/Lazy;", "checkLayoutParams", "", "p", "Landroid/view/ViewGroup$LayoutParams;", "generateDefaultLayoutParams", "Lcom/beemans/common/ui/views/sticky/StickyLinearLayout$LayoutParams;", "generateLayoutParams", "getChildDrawingOrder", "childCount", "i", "getViewOffsetHelper", "child", "nextStickyView", "index", "onLayout", "", "changed", "left", "top", "right", "bottom", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onScrollChange", "v", "scrollX", "scrollY", "oldScrollX", "oldScrollY", "Companion", "LayoutParams", "common_release"})
public final class StickyLinearLayout
extends LinearLayout
implements OnStickyScrollChangeListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int stickyFixedViewTop;
    @NotNull
    private final Lazy viewOffsetHelpers$delegate;
    public static final int TYPE_DEFAULT = 0;
    public static final int TYPE_ONLY_STICKY = 1;
    public static final int TYPE_STICKY_FIXED = 2;

    @JvmOverloads
    public StickyLinearLayout(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.viewOffsetHelpers$delegate = LazyKt.lazy((Function0)viewOffsetHelpers.2.INSTANCE);
        this.setChildrenDrawingOrderEnabled(true);
    }

    public /* synthetic */ StickyLinearLayout(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    public final int getStickyFixedViewTop() {
        return this.stickyFixedViewTop;
    }

    public final void setStickyFixedViewTop(int n) {
        this.stickyFixedViewTop = n;
    }

    private final Map<View, ViewOffsetHelper> getViewOffsetHelpers() {
        Lazy lazy = this.viewOffsetHelpers$delegate;
        return (Map)lazy.getValue();
    }

    @Override
    public void onScrollChange(@NotNull View v, int scrollX, int scrollY, int oldScrollX, int oldScrollY) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        boolean isFixed = false;
        boolean isNext = false;
        isNext = true;
        int previousOffset = 0;
        for (int i = this.getChildCount() - 1; -1 < i; --i) {
            View nextView;
            ViewOffsetHelper offsetHelper;
            View child = this.getChildAt(i);
            Intrinsics.checkNotNullExpressionValue((Object)child, (String)"child");
            if (this.getViewOffsetHelper(child) == null) continue;
            boolean bl = false;
            int offset = scrollY - offsetHelper.getLayoutTop();
            if (isFixed) {
                if (!isNext) continue;
                isNext = false;
                int currentOffset = offset - previousOffset;
                offsetHelper.setTopAndBottomOffset(currentOffset);
                continue;
            }
            offsetHelper.setTopAndBottomOffset(Math.max(offset, 0));
            if (this.nextStickyView(i) == null) continue;
            boolean bl2 = false;
            previousOffset = Math.max(offset + nextView.getMeasuredHeight(), 0);
            isFixed = previousOffset > 0;
        }
    }

    private final View nextStickyView(int index) {
        for (int i = index - 1; -1 < i; --i) {
            View child = this.getChildAt(i);
            Intrinsics.checkNotNullExpressionValue((Object)child, (String)"child");
            ViewOffsetHelper offsetHelper = this.getViewOffsetHelper(child);
            if (offsetHelper == null) continue;
            return child;
        }
        return null;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        for (int i = this.getChildCount() - 1; -1 < i; --i) {
            View child = this.getChildAt(i);
            ViewGroup.LayoutParams layoutParams = child.getLayoutParams();
            Intrinsics.checkNotNull((Object)layoutParams, (String)"null cannot be cast to non-null type com.beemans.common.ui.views.sticky.StickyLinearLayout.LayoutParams");
            if (!((LayoutParams)layoutParams).isSticky()) continue;
            this.setMinimumHeight(child.getMeasuredHeight());
            break;
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            ViewOffsetHelper it;
            View view = this.getChildAt(i);
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"getChildAt(i)");
            if (this.getViewOffsetHelper(view) == null) continue;
            boolean bl = false;
            it.onViewLayout();
            it.applyOffsets();
        }
    }

    protected int getChildDrawingOrder(int childCount, int i) {
        return childCount - i - 1;
    }

    protected boolean checkLayoutParams(@NotNull ViewGroup.LayoutParams p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        return p instanceof LayoutParams;
    }

    @NotNull
    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-1, -1);
    }

    @NotNull
    public LayoutParams generateLayoutParams(@NotNull AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        return new LayoutParams(context, attrs);
    }

    @NotNull
    protected LayoutParams generateLayoutParams(@NotNull ViewGroup.LayoutParams p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        return new LayoutParams(p);
    }

    private final ViewOffsetHelper getViewOffsetHelper(View child) {
        ViewOffsetHelper viewOffsetHelper;
        LayoutParams lp;
        ViewGroup.LayoutParams layoutParams = child.getLayoutParams();
        LayoutParams layoutParams2 = lp = layoutParams instanceof LayoutParams ? (LayoutParams)layoutParams : null;
        if (!(layoutParams2 != null ? layoutParams2.isSticky() : false)) {
            return null;
        }
        if (lp.isStickyFixed()) {
            this.stickyFixedViewTop = child.getTop();
        }
        Map<View, ViewOffsetHelper> $this$getOrPut$iv = this.getViewOffsetHelpers();
        boolean $i$f$getOrPut = false;
        ViewOffsetHelper value$iv = $this$getOrPut$iv.get(child);
        if (value$iv == null) {
            boolean bl = false;
            ViewOffsetHelper answer$iv = StickyLinearLayout.getViewOffsetHelper$viewOffsetHelper(child);
            $this$getOrPut$iv.put(child, answer$iv);
            viewOffsetHelper = answer$iv;
        } else {
            viewOffsetHelper = value$iv;
        }
        return viewOffsetHelper;
    }

    @JvmOverloads
    public StickyLinearLayout(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public StickyLinearLayout(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final ViewOffsetHelper getViewOffsetHelper$viewOffsetHelper(View $child) {
        ViewOffsetHelper offsetHelper;
        Object object = $child.getTag(R.id.view_offset_helper);
        ViewOffsetHelper viewOffsetHelper = offsetHelper = object instanceof ViewOffsetHelper ? (ViewOffsetHelper)object : null;
        if (offsetHelper == null) {
            offsetHelper = new ViewOffsetHelper($child);
            $child.setTag(R.id.view_offset_helper, (Object)offsetHelper);
        }
        return offsetHelper;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/beemans/common/ui/views/sticky/StickyLinearLayout$Companion;", "", "()V", "TYPE_DEFAULT", "", "TYPE_ONLY_STICKY", "TYPE_STICKY_FIXED", "common_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006B\u0017\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nB\u001f\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rB\u0011\b\u0016\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0010B\u0011\b\u0016\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\u0002\u0010\u0013B\u0011\b\u0016\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0017\"\u0004\b\u001b\u0010\u0019\u00a8\u0006\u001c"}, d2={"Lcom/beemans/common/ui/views/sticky/StickyLinearLayout$LayoutParams;", "Landroid/widget/LinearLayout$LayoutParams;", "c", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "width", "", "height", "(II)V", "weight", "", "(IIF)V", "p", "Landroid/view/ViewGroup$LayoutParams;", "(Landroid/view/ViewGroup$LayoutParams;)V", "source", "Landroid/view/ViewGroup$MarginLayoutParams;", "(Landroid/view/ViewGroup$MarginLayoutParams;)V", "(Landroid/widget/LinearLayout$LayoutParams;)V", "isSticky", "", "()Z", "setSticky", "(Z)V", "isStickyFixed", "setStickyFixed", "common_release"})
    public static final class LayoutParams
    extends LinearLayout.LayoutParams {
        private boolean isSticky;
        private boolean isStickyFixed;

        public final boolean isSticky() {
            return this.isSticky;
        }

        public final void setSticky(boolean bl) {
            this.isSticky = bl;
        }

        public final boolean isStickyFixed() {
            return this.isStickyFixed;
        }

        public final void setStickyFixed(boolean bl) {
            this.isStickyFixed = bl;
        }

        public LayoutParams(@NotNull Context c, @Nullable AttributeSet attrs) {
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            super(c, attrs);
            TypedArray typedArray = c.obtainStyledAttributes(attrs, R.styleable.StickyLinearLayout_Layout);
            Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"c.obtainStyledAttributes\u2026tickyLinearLayout_Layout)");
            TypedArray a = typedArray;
            int stickyType = a.getInt(R.styleable.StickyLinearLayout_Layout_stickyType, 0);
            this.isSticky = stickyType == 1 || stickyType == 2;
            this.isStickyFixed = stickyType == 2;
            a.recycle();
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(int width, int height, float weight) {
            super(width, height, weight);
        }

        public LayoutParams(@Nullable ViewGroup.LayoutParams p) {
            super(p);
        }

        public LayoutParams(@Nullable ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        public LayoutParams(@Nullable LinearLayout.LayoutParams source) {
            super(source);
        }
    }
}

