/*
 * Decompiled with CFR 0.152.
 */
package com.beemans.common.ui.views.sticky;

import android.view.View;
import androidx.core.view.ViewCompat;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u0018J\u000e\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\rJ\u000e\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\rR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\tR\u001e\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0011\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u001e\u0010\u0013\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u001e\u0010\u0015\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/beemans/common/ui/views/sticky/ViewOffsetHelper;", "", "view", "Landroid/view/View;", "(Landroid/view/View;)V", "isHorizontalOffsetEnabled", "", "()Z", "setHorizontalOffsetEnabled", "(Z)V", "isVerticalOffsetEnabled", "setVerticalOffsetEnabled", "<set-?>", "", "layoutLeft", "getLayoutLeft", "()I", "layoutTop", "getLayoutTop", "leftAndRightOffset", "getLeftAndRightOffset", "topAndBottomOffset", "getTopAndBottomOffset", "applyOffsets", "", "onViewLayout", "setLeftAndRightOffset", "offset", "setTopAndBottomOffset", "common_release"})
public final class ViewOffsetHelper {
    @NotNull
    private final View view;
    private int layoutTop;
    private int layoutLeft;
    private int topAndBottomOffset;
    private int leftAndRightOffset;
    private boolean isVerticalOffsetEnabled;
    private boolean isHorizontalOffsetEnabled;

    public ViewOffsetHelper(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        this.view = view;
        this.isVerticalOffsetEnabled = true;
        this.isHorizontalOffsetEnabled = true;
    }

    public final int getLayoutTop() {
        return this.layoutTop;
    }

    public final int getLayoutLeft() {
        return this.layoutLeft;
    }

    public final int getTopAndBottomOffset() {
        return this.topAndBottomOffset;
    }

    public final int getLeftAndRightOffset() {
        return this.leftAndRightOffset;
    }

    public final boolean isVerticalOffsetEnabled() {
        return this.isVerticalOffsetEnabled;
    }

    public final void setVerticalOffsetEnabled(boolean bl) {
        this.isVerticalOffsetEnabled = bl;
    }

    public final boolean isHorizontalOffsetEnabled() {
        return this.isHorizontalOffsetEnabled;
    }

    public final void setHorizontalOffsetEnabled(boolean bl) {
        this.isHorizontalOffsetEnabled = bl;
    }

    public final void onViewLayout() {
        this.layoutTop = this.view.getTop();
        this.layoutLeft = this.view.getLeft();
    }

    public final void applyOffsets() {
        ViewCompat.offsetTopAndBottom((View)this.view, (int)(this.topAndBottomOffset - (this.view.getTop() - this.layoutTop)));
        ViewCompat.offsetLeftAndRight((View)this.view, (int)(this.leftAndRightOffset - (this.view.getLeft() - this.layoutLeft)));
    }

    public final boolean setTopAndBottomOffset(int offset) {
        if (this.isVerticalOffsetEnabled && this.topAndBottomOffset != offset) {
            this.topAndBottomOffset = offset;
            this.applyOffsets();
            return true;
        }
        return false;
    }

    public final boolean setLeftAndRightOffset(int offset) {
        if (this.isHorizontalOffsetEnabled && this.leftAndRightOffset != offset) {
            this.leftAndRightOffset = offset;
            this.applyOffsets();
            return true;
        }
        return false;
    }
}

