/*
 * Decompiled with CFR 0.152.
 */
package com.beemans.common.ui.views.tabview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.appcompat.widget.AppCompatTextView;
import com.beemans.common.R;
import com.beemans.common.ext.CommonImageExtKt;
import com.beemans.common.ext.CommonScreenExtKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 12\u00020\u0001:\u00011B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010#\u001a\u00020$2\b\b\u0002\u0010%\u001a\u00020\u0013H\u0002J\u0010\u0010&\u001a\u00020$2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u001f\u0010'\u001a\u00020\u00002\u0017\u0010(\u001a\u0013\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020$0)\u00a2\u0006\u0002\b*J\u001a\u0010+\u001a\u00020$2\b\b\u0003\u0010\f\u001a\u00020\u00072\b\b\u0003\u0010\u000e\u001a\u00020\u0007J\u0010\u0010,\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0013H\u0016J\u000e\u0010-\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0013J\u001f\u0010.\u001a\u00020\u00002\u0017\u0010(\u001a\u0013\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020$0)\u00a2\u0006\u0002\b*J\u001a\u0010/\u001a\u00020$2\b\b\u0003\u0010\u001d\u001a\u00020\u00072\b\b\u0003\u0010\u001e\u001a\u00020\u0007J\u0012\u00100\u001a\u00020$2\b\b\u0002\u0010%\u001a\u00020\u0013H\u0002R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/beemans/common/ui/views/tabview/TabBarItem;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "drawablePadding", "iconHeight", "iconNormalColor", "iconNormalResId", "iconSelectedColor", "iconSelectedResId", "iconWidth", "imgIcon", "Landroidx/appcompat/widget/AppCompatImageView;", "isItemSelected", "", "isTextBold", "itemType", "tabPosition", "getTabPosition", "()I", "setTabPosition", "(I)V", "text", "", "textNormalColor", "textSelectedColor", "textSize", "", "tvText", "Landroidx/appcompat/widget/AppCompatTextView;", "imgChange", "", "selected", "initView", "setImg", "block", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "setImgIcon", "setSelected", "setSelectedStatus", "setText", "setTextColor", "textChange", "Companion", "common_release"})
public final class TabBarItem
extends FrameLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int iconNormalResId;
    private int iconSelectedResId;
    private int iconNormalColor;
    private int iconSelectedColor;
    private int iconWidth;
    private int iconHeight;
    @Nullable
    private String text;
    private float textSize;
    private int textNormalColor;
    private int textSelectedColor;
    private boolean isTextBold;
    private int drawablePadding;
    private boolean isItemSelected;
    private int tabPosition;
    private int itemType;
    @Nullable
    private AppCompatImageView imgIcon;
    @Nullable
    private AppCompatTextView tvText;
    public static final int TYPE_PIC_TEXT = 0;
    public static final int TYPE_TEXT_PIC = 1;
    public static final int TYPE_ONLY_PIC = 2;
    public static final int TYPE_ONLY_TEXT = 3;

    @JvmOverloads
    public TabBarItem(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.iconNormalResId = -1;
        this.iconSelectedResId = -1;
        this.iconNormalColor = -1;
        this.iconSelectedColor = -1;
        this.iconWidth = 12;
        this.iconHeight = 12;
        this.textSize = 12.0f;
        this.textNormalColor = -1;
        this.textSelectedColor = -1;
        this.tabPosition = -1;
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.TabBarItem);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.obtainStyledAttr\u2026, R.styleable.TabBarItem)");
        TypedArray ta = typedArray;
        this.iconNormalResId = ta.getResourceId(R.styleable.TabBarItem_tbi_iconNormal, -1);
        this.iconNormalColor = ta.getColor(R.styleable.TabBarItem_tbi_iconNormalColor, -1);
        this.iconSelectedResId = ta.getResourceId(R.styleable.TabBarItem_tbi_iconSelected, -1);
        this.iconSelectedColor = ta.getColor(R.styleable.TabBarItem_tbi_iconSelectedColor, -1);
        this.iconWidth = ta.getDimensionPixelSize(R.styleable.TabBarItem_tbi_iconWidth, CommonScreenExtKt.getPt2px(12));
        this.iconHeight = ta.getDimensionPixelSize(R.styleable.TabBarItem_tbi_iconHeight, CommonScreenExtKt.getPt2px(12));
        this.text = ta.getString(R.styleable.TabBarItem_tbi_text);
        this.textSize = ta.getDimensionPixelSize(R.styleable.TabBarItem_tbi_textSize, CommonScreenExtKt.getPt2px(12));
        this.textNormalColor = ta.getColor(R.styleable.TabBarItem_tbi_textNormalColor, -7829368);
        this.textSelectedColor = ta.getColor(R.styleable.TabBarItem_tbi_textSelectedColor, -1);
        this.isTextBold = ta.getBoolean(R.styleable.TabBarItem_tbi_textBold, false);
        this.drawablePadding = ta.getDimensionPixelSize(R.styleable.TabBarItem_tbi_drawablePadding, 0);
        this.isItemSelected = ta.getBoolean(R.styleable.TabBarItem_tbi_selected, false);
        this.itemType = ta.getInt(R.styleable.TabBarItem_tbi_type, 0);
        ta.recycle();
        this.initView(context);
    }

    public /* synthetic */ TabBarItem(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    public final int getTabPosition() {
        return this.tabPosition;
    }

    public final void setTabPosition(int n) {
        this.tabPosition = n;
    }

    private final void initView(Context context) {
        LinearLayout it;
        FrameLayout.LayoutParams layoutParams;
        LinearLayout linearLayout;
        LinearLayout $this$initView_u24lambda_u2d1 = linearLayout = new LinearLayout(context);
        boolean bl = false;
        $this$initView_u24lambda_u2d1.setOrientation(1);
        $this$initView_u24lambda_u2d1.setGravity(17);
        FrameLayout.LayoutParams layoutParams2 = layoutParams = new FrameLayout.LayoutParams(-2, -2);
        LinearLayout linearLayout2 = $this$initView_u24lambda_u2d1;
        boolean bl2 = false;
        $this$initView_u24lambda_u2d1_u24lambda_u2d0.gravity = 17;
        linearLayout2.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        LinearLayout containerLayout = linearLayout;
        $this$initView_u24lambda_u2d1 = linearLayout = new AppCompatImageView(context);
        TabBarItem tabBarItem = this;
        boolean bl3 = false;
        it.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(this.iconWidth, this.iconHeight));
        if (this.iconNormalResId != -1) {
            CommonImageExtKt.loadImage$default((ImageView)it, this.iconNormalResId, null, null, 6, null);
        }
        tabBarItem.imgIcon = linearLayout;
        it = linearLayout = new AppCompatTextView(context);
        tabBarItem = this;
        boolean bl4 = false;
        it.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        it.setText((CharSequence)this.text);
        it.setTextSize(0, this.textSize);
        if (this.textNormalColor != -1) {
            it.setTextColor(this.textNormalColor);
        }
        if (this.isTextBold) {
            it.setTypeface(Typeface.defaultFromStyle((int)1));
        }
        tabBarItem.tvText = linearLayout;
        switch (this.itemType) {
            case 0: {
                boolean bl5;
                FrameLayout.LayoutParams $this$updateMarginLayoutParams_u24lambda_u2d0$iv;
                containerLayout.addView((View)this.imgIcon);
                containerLayout.addView((View)this.tvText);
                AppCompatTextView appCompatTextView = this.tvText;
                if (appCompatTextView != null) {
                    View $this$updateMarginLayoutParams$iv = (View)appCompatTextView;
                    boolean $i$f$updateMarginLayoutParams = false;
                    layoutParams2 = $this$updateMarginLayoutParams$iv.getLayoutParams();
                    ViewGroup.MarginLayoutParams marginLayoutParams = layoutParams2 instanceof ViewGroup.MarginLayoutParams ? (ViewGroup.MarginLayoutParams)layoutParams2 : null;
                    if (marginLayoutParams != null) {
                        $this$updateMarginLayoutParams_u24lambda_u2d0$iv = layoutParams2 = marginLayoutParams;
                        bl5 = false;
                        FrameLayout.LayoutParams $this$initView_u24lambda_u2d4 = $this$updateMarginLayoutParams_u24lambda_u2d0$iv;
                        boolean bl6 = false;
                        $this$initView_u24lambda_u2d4.topMargin = this.drawablePadding;
                        $this$updateMarginLayoutParams$iv.setLayoutParams((ViewGroup.LayoutParams)$this$updateMarginLayoutParams_u24lambda_u2d0$iv);
                    }
                }
                break;
            }
            case 1: {
                boolean bl5;
                FrameLayout.LayoutParams $this$updateMarginLayoutParams_u24lambda_u2d0$iv;
                containerLayout.addView((View)this.tvText);
                containerLayout.addView((View)this.imgIcon);
                AppCompatImageView appCompatImageView = this.imgIcon;
                if (appCompatImageView != null) {
                    View $this$updateMarginLayoutParams$iv = (View)appCompatImageView;
                    boolean $i$f$updateMarginLayoutParams = false;
                    layoutParams2 = $this$updateMarginLayoutParams$iv.getLayoutParams();
                    ViewGroup.MarginLayoutParams marginLayoutParams = layoutParams2 instanceof ViewGroup.MarginLayoutParams ? (ViewGroup.MarginLayoutParams)layoutParams2 : null;
                    if (marginLayoutParams != null) {
                        $this$updateMarginLayoutParams_u24lambda_u2d0$iv = layoutParams2 = marginLayoutParams;
                        bl5 = false;
                        FrameLayout.LayoutParams $this$initView_u24lambda_u2d5 = $this$updateMarginLayoutParams_u24lambda_u2d0$iv;
                        boolean bl7 = false;
                        $this$initView_u24lambda_u2d5.topMargin = this.drawablePadding;
                        $this$updateMarginLayoutParams$iv.setLayoutParams((ViewGroup.LayoutParams)$this$updateMarginLayoutParams_u24lambda_u2d0$iv);
                    }
                }
                break;
            }
            case 2: {
                containerLayout.addView((View)this.imgIcon);
                break;
            }
            case 3: {
                containerLayout.addView((View)this.tvText);
            }
        }
        this.addView((View)containerLayout);
        this.setSelected(this.isItemSelected);
    }

    public void setSelected(boolean selected) {
        this.setSelectedStatus(selected);
        super.setSelected(selected);
    }

    public final void setSelectedStatus(boolean selected) {
        this.textChange(selected);
        this.imgChange(selected);
    }

    private final void textChange(boolean selected) {
        block1: {
            block0: {
                if (!selected) break block0;
                AppCompatTextView appCompatTextView = this.tvText;
                if (appCompatTextView == null) break block1;
                appCompatTextView.setTextColor(this.textSelectedColor);
                break block1;
            }
            AppCompatTextView appCompatTextView = this.tvText;
            if (appCompatTextView == null) break block1;
            appCompatTextView.setTextColor(this.textNormalColor);
        }
    }

    static /* synthetic */ void textChange$default(TabBarItem tabBarItem, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = tabBarItem.isSelected();
        }
        tabBarItem.textChange(bl);
    }

    private final void imgChange(boolean selected) {
        block7: {
            block6: {
                if (!selected) break block6;
                if (this.iconSelectedResId != -1) {
                    AppCompatImageView appCompatImageView = this.imgIcon;
                    if (appCompatImageView != null) {
                        CommonImageExtKt.loadImage$default((ImageView)appCompatImageView, this.iconSelectedResId, null, null, 6, null);
                    }
                }
                if (this.iconSelectedColor == -1) break block7;
                AppCompatImageView appCompatImageView = this.imgIcon;
                if (appCompatImageView != null) {
                    appCompatImageView.setColorFilter(this.iconSelectedColor);
                }
                break block7;
            }
            if (this.iconNormalResId != -1) {
                AppCompatImageView appCompatImageView = this.imgIcon;
                if (appCompatImageView != null) {
                    CommonImageExtKt.loadImage$default((ImageView)appCompatImageView, this.iconNormalResId, null, null, 6, null);
                }
            }
            if (this.iconNormalColor == -1) break block7;
            AppCompatImageView appCompatImageView = this.imgIcon;
            if (appCompatImageView != null) {
                appCompatImageView.setColorFilter(this.iconNormalColor);
            }
        }
    }

    static /* synthetic */ void imgChange$default(TabBarItem tabBarItem, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = tabBarItem.isSelected();
        }
        tabBarItem.imgChange(bl);
    }

    @NotNull
    public final TabBarItem setImg(@NotNull Function1<? super AppCompatImageView, Unit> block) {
        block0: {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            AppCompatImageView appCompatImageView = this.imgIcon;
            if (appCompatImageView == null) break block0;
            AppCompatImageView appCompatImageView2 = appCompatImageView;
            block.invoke((Object)appCompatImageView2);
        }
        return this;
    }

    public final void setImgIcon(@DrawableRes int iconNormalResId, @DrawableRes int iconSelectedResId) {
        if (iconNormalResId != -1) {
            this.iconNormalResId = iconNormalResId;
        }
        if (iconSelectedResId != -1) {
            this.iconSelectedResId = iconSelectedResId;
        }
        TabBarItem.imgChange$default(this, false, 1, null);
    }

    public static /* synthetic */ void setImgIcon$default(TabBarItem tabBarItem, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = -1;
        }
        if ((n3 & 2) != 0) {
            n2 = -1;
        }
        tabBarItem.setImgIcon(n, n2);
    }

    @NotNull
    public final TabBarItem setText(@NotNull Function1<? super AppCompatTextView, Unit> block) {
        block0: {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            AppCompatTextView appCompatTextView = this.tvText;
            if (appCompatTextView == null) break block0;
            AppCompatTextView appCompatTextView2 = appCompatTextView;
            block.invoke((Object)appCompatTextView2);
        }
        return this;
    }

    public final void setTextColor(@ColorInt int textNormalColor, @ColorInt int textSelectedColor) {
        if (textNormalColor != -1) {
            this.textNormalColor = textNormalColor;
        }
        if (textSelectedColor != -1) {
            this.textSelectedColor = textSelectedColor;
        }
        TabBarItem.textChange$default(this, false, 1, null);
    }

    public static /* synthetic */ void setTextColor$default(TabBarItem tabBarItem, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = -1;
        }
        if ((n3 & 2) != 0) {
            n2 = -1;
        }
        tabBarItem.setTextColor(n, n2);
    }

    @JvmOverloads
    public TabBarItem(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public TabBarItem(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/beemans/common/ui/views/tabview/TabBarItem$Companion;", "", "()V", "TYPE_ONLY_PIC", "", "TYPE_ONLY_TEXT", "TYPE_PIC_TEXT", "TYPE_TEXT_PIC", "common_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

